/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.Window;
import org.apache.flink.table.runtime.operators.window.assigners.MergingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.SessionWindowAssigner;
import org.apache.flink.table.runtime.operators.window.internal.MergingWindowSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;

public class MergingWindowSetTest {
    @Test
    public void testNonEagerMerging() throws Exception {
        HeapMapState mockState = new HeapMapState();
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)new NonEagerlyMergingWindowAssigner(3000L), mockState);
        windowSet.initializeCache((Object)"key1");
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        TimeWindow result = (TimeWindow)windowSet.addWindow((Window)new TimeWindow(0L, 2L), (MergingWindowSet.MergeFunction)mergeFunction);
        Assert.assertNotNull((Object)windowSet.getStateWindow((Window)result));
        mergeFunction.reset();
        result = (TimeWindow)windowSet.addWindow((Window)new TimeWindow(2L, 5L), (MergingWindowSet.MergeFunction)mergeFunction);
        Assert.assertNotNull((Object)windowSet.getStateWindow((Window)result));
        mergeFunction.reset();
        result = (TimeWindow)windowSet.addWindow((Window)new TimeWindow(1L, 2L), (MergingWindowSet.MergeFunction)mergeFunction);
        Assert.assertNotNull((Object)windowSet.getStateWindow((Window)result));
        mergeFunction.reset();
        result = (TimeWindow)windowSet.addWindow((Window)new TimeWindow(10L, 12L), (MergingWindowSet.MergeFunction)mergeFunction);
        Assert.assertNotNull((Object)windowSet.getStateWindow((Window)result));
    }

    @Test
    public void testIncrementalMerging() throws Exception {
        HeapMapState mockState = new HeapMapState();
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)SessionWindowAssigner.withGap((Duration)Duration.ofMillis(3L)), mockState);
        windowSet.initializeCache((Object)"key1");
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)windowSet.addWindow((Window)new TimeWindow(0L, 4L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertTrue((boolean)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(0L, 4L))).equals((Object)new TimeWindow(0L, 4L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)windowSet.addWindow((Window)new TimeWindow(0L, 4L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 5L), (Object)windowSet.addWindow((Window)new TimeWindow(3L, 5L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(0L, 5L), (Object)mergeFunction.mergeTarget());
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)mergeFunction.stateWindow());
        Assert.assertThat(mergeFunction.mergeSources(), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 4L)}));
        Assert.assertTrue((boolean)mergeFunction.mergedStateWindows().isEmpty());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 6L), (Object)windowSet.addWindow((Window)new TimeWindow(4L, 6L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(0L, 6L), (Object)mergeFunction.mergeTarget());
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)mergeFunction.stateWindow());
        Assert.assertThat(mergeFunction.mergeSources(), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 5L)}));
        Assert.assertTrue((boolean)mergeFunction.mergedStateWindows().isEmpty());
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 6L), (Object)windowSet.addWindow((Window)new TimeWindow(1L, 4L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 6L), (Object)windowSet.addWindow((Window)new TimeWindow(0L, 4L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 6L), (Object)windowSet.addWindow((Window)new TimeWindow(3L, 5L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 6L), (Object)windowSet.addWindow((Window)new TimeWindow(4L, 6L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(11L, 14L), (Object)windowSet.addWindow((Window)new TimeWindow(11L, 14L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)));
        Assert.assertEquals((Object)new TimeWindow(11L, 14L), (Object)windowSet.getStateWindow((Window)new TimeWindow(11L, 14L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(10L, 14L), (Object)windowSet.addWindow((Window)new TimeWindow(10L, 13L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(10L, 14L), (Object)mergeFunction.mergeTarget());
        Assert.assertEquals((Object)new TimeWindow(11L, 14L), (Object)mergeFunction.stateWindow());
        Assert.assertThat(mergeFunction.mergeSources(), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(11L, 14L)}));
        Assert.assertTrue((boolean)mergeFunction.mergedStateWindows().isEmpty());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(10L, 15L), (Object)windowSet.addWindow((Window)new TimeWindow(12L, 15L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(10L, 15L), (Object)mergeFunction.mergeTarget());
        Assert.assertEquals((Object)new TimeWindow(11L, 14L), (Object)mergeFunction.stateWindow());
        Assert.assertThat(mergeFunction.mergeSources(), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(10L, 14L)}));
        Assert.assertTrue((boolean)mergeFunction.mergedStateWindows().isEmpty());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(10L, 15L), (Object)windowSet.addWindow((Window)new TimeWindow(11L, 14L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)));
        Assert.assertEquals((Object)new TimeWindow(11L, 14L), (Object)windowSet.getStateWindow((Window)new TimeWindow(10L, 15L)));
        windowSet.retireWindow((Window)new TimeWindow(0L, 6L));
        Assert.assertTrue((windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)) == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(10L, 15L))).equals((Object)new TimeWindow(11L, 14L)));
    }

    @Test
    public void testLateMerging() throws Exception {
        HeapMapState mockState = new HeapMapState();
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)SessionWindowAssigner.withGap((Duration)Duration.ofMillis(3L)), mockState);
        windowSet.initializeCache((Object)"key1");
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 3L), (Object)windowSet.addWindow((Window)new TimeWindow(0L, 3L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(0L, 3L), (Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 3L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(5L, 8L), (Object)windowSet.addWindow((Window)new TimeWindow(5L, 8L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(5L, 8L), (Object)windowSet.getStateWindow((Window)new TimeWindow(5L, 8L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(10L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(10L, 13L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(10L, 13L), (Object)windowSet.getStateWindow((Window)new TimeWindow(10L, 13L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(5L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(8L, 10L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(5L, 13L), (Object)mergeFunction.mergeTarget());
        Assert.assertThat((Object)mergeFunction.stateWindow(), (Matcher)Matchers.anyOf((Matcher)Is.is((Object)new TimeWindow(5L, 8L)), (Matcher)Is.is((Object)new TimeWindow(10L, 13L))));
        Assert.assertThat(mergeFunction.mergeSources(), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(5L, 8L), new TimeWindow(10L, 13L)}));
        Assert.assertThat(mergeFunction.mergedStateWindows(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(10L, 13L)}), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(5L, 8L)})));
        Assert.assertThat(mergeFunction.mergedStateWindows(), (Matcher)IsNot.not((Matcher)Matchers.hasItem((Object)mergeFunction.mergeTarget())));
        Assert.assertEquals((Object)new TimeWindow(0L, 3L), (Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 3L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(5L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(5L, 8L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(5L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(8L, 10L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(5L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(10L, 13L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertThat((Object)windowSet.getStateWindow((Window)new TimeWindow(5L, 13L)), (Matcher)Matchers.anyOf((Matcher)Is.is((Object)new TimeWindow(5L, 8L)), (Matcher)Is.is((Object)new TimeWindow(10L, 13L))));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(3L, 5L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(0L, 13L), (Object)mergeFunction.mergeTarget());
        Assert.assertThat((Object)mergeFunction.stateWindow(), (Matcher)Matchers.anyOf((Matcher)Is.is((Object)new TimeWindow(0L, 3L)), (Matcher)Is.is((Object)new TimeWindow(5L, 8L)), (Matcher)Is.is((Object)new TimeWindow(10L, 13L))));
        Assert.assertThat(mergeFunction.mergeSources(), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 3L), new TimeWindow(5L, 13L)}));
        Assert.assertThat(mergeFunction.mergedStateWindows(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 3L)}), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(5L, 8L)}), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(10L, 13L)})));
        Assert.assertThat(mergeFunction.mergedStateWindows(), (Matcher)IsNot.not((Matcher)Matchers.hasItem((Object)mergeFunction.mergeTarget())));
        Assert.assertThat((Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 13L)), (Matcher)Matchers.anyOf((Matcher)Is.is((Object)new TimeWindow(0L, 3L)), (Matcher)Is.is((Object)new TimeWindow(5L, 8L)), (Matcher)Is.is((Object)new TimeWindow(10L, 13L))));
    }

    @Test
    public void testMergeLargeWindowCoveringSingleWindow() throws Exception {
        HeapMapState mockState = new HeapMapState();
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)SessionWindowAssigner.withGap((Duration)Duration.ofMillis(3L)), mockState);
        windowSet.initializeCache((Object)"key1");
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.addWindow((Window)new TimeWindow(1L, 2L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 3L), (Object)windowSet.addWindow((Window)new TimeWindow(0L, 3L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 3L)));
    }

    @Test
    public void testAddingIdenticalWindows() throws Exception {
        HeapMapState mockState = new HeapMapState();
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)SessionWindowAssigner.withGap((Duration)Duration.ofMillis(3L)), mockState);
        windowSet.initializeCache((Object)"key1");
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.addWindow((Window)new TimeWindow(1L, 2L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.addWindow((Window)new TimeWindow(1L, 2L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)));
    }

    @Test
    public void testMergeLargeWindowCoveringMultipleWindows() throws Exception {
        HeapMapState mockState = new HeapMapState();
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)SessionWindowAssigner.withGap((Duration)Duration.ofMillis(3L)), mockState);
        windowSet.initializeCache((Object)"key1");
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(1L, 3L), (Object)windowSet.addWindow((Window)new TimeWindow(1L, 3L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(1L, 3L), (Object)windowSet.getStateWindow((Window)new TimeWindow(1L, 3L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(5L, 8L), (Object)windowSet.addWindow((Window)new TimeWindow(5L, 8L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(5L, 8L), (Object)windowSet.getStateWindow((Window)new TimeWindow(5L, 8L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(10L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(10L, 13L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(10L, 13L), (Object)windowSet.getStateWindow((Window)new TimeWindow(10L, 13L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(5L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(5L, 13L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertThat(mergeFunction.mergedStateWindows(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(5L, 8L)}), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(10L, 13L)})));
        Assert.assertThat((Object)windowSet.getStateWindow((Window)new TimeWindow(5L, 13L)), (Matcher)Matchers.anyOf((Matcher)Is.is((Object)new TimeWindow(5L, 8L)), (Matcher)Is.is((Object)new TimeWindow(10L, 13L))));
    }

    private static class HeapMapState<UK, UV>
    implements MapState<UK, UV> {
        private final Map<UK, UV> internalMap = new HashMap<UK, UV>();

        HeapMapState() {
        }

        public UV get(UK key) throws Exception {
            return this.internalMap.get(key);
        }

        public void put(UK key, UV value) throws Exception {
            this.internalMap.put(key, value);
        }

        public void putAll(Map<UK, UV> map) throws Exception {
            this.internalMap.putAll(map);
        }

        public void remove(UK key) throws Exception {
            this.internalMap.remove(key);
        }

        public boolean contains(UK key) throws Exception {
            return this.internalMap.containsKey(key);
        }

        public Iterable<Map.Entry<UK, UV>> entries() throws Exception {
            return this.internalMap.entrySet();
        }

        public Iterable<UK> keys() throws Exception {
            return this.internalMap.keySet();
        }

        public Iterable<UV> values() throws Exception {
            return this.internalMap.values();
        }

        public Iterator<Map.Entry<UK, UV>> iterator() throws Exception {
            return this.internalMap.entrySet().iterator();
        }

        public boolean isEmpty() {
            return this.internalMap.isEmpty();
        }

        public void clear() {
            this.internalMap.clear();
        }
    }

    static class NonEagerlyMergingWindowAssigner
    extends MergingWindowAssigner<TimeWindow> {
        private static final long serialVersionUID = 1L;
        protected long sessionTimeout;

        public NonEagerlyMergingWindowAssigner(long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        public Collection<TimeWindow> assignWindows(BaseRow element, long timestamp) {
            return Collections.singletonList(new TimeWindow(timestamp, timestamp + this.sessionTimeout));
        }

        public TypeSerializer<TimeWindow> getWindowSerializer(ExecutionConfig executionConfig) {
            return null;
        }

        public boolean isEventTime() {
            return true;
        }

        public void mergeWindows(TimeWindow newWindow, NavigableSet<TimeWindow> sortedWindows, MergingWindowAssigner.MergeCallback<TimeWindow> callback) {
            TreeSet<TimeWindow> treeWindows = new TreeSet<TimeWindow>();
            treeWindows.add(newWindow);
            treeWindows.addAll(sortedWindows);
            TimeWindow earliestStart = (TimeWindow)treeWindows.first();
            ArrayList<TimeWindow> associatedWindows = new ArrayList<TimeWindow>();
            for (TimeWindow win : treeWindows) {
                if (win.getStart() >= earliestStart.getEnd() || win.getStart() < earliestStart.getStart()) continue;
                associatedWindows.add(win);
            }
            TimeWindow target = new TimeWindow(earliestStart.getStart(), earliestStart.getEnd() + 1L);
            if (associatedWindows.size() > 1) {
                callback.merge((Object)target, associatedWindows);
            }
        }

        public String toString() {
            return "NonEagerlyMergingWindows";
        }
    }

    private static class TestingMergeFunction
    implements MergingWindowSet.MergeFunction<TimeWindow> {
        private TimeWindow target = null;
        private Collection<TimeWindow> sources = null;
        private TimeWindow stateWindow = null;
        private Collection<TimeWindow> mergedStateWindows = null;

        private TestingMergeFunction() {
        }

        public void reset() {
            this.target = null;
            this.sources = null;
            this.stateWindow = null;
            this.mergedStateWindows = null;
        }

        public boolean hasMerged() {
            return this.target != null;
        }

        public TimeWindow mergeTarget() {
            return this.target;
        }

        public Collection<TimeWindow> mergeSources() {
            return this.sources;
        }

        public TimeWindow stateWindow() {
            return this.stateWindow;
        }

        public Collection<TimeWindow> mergedStateWindows() {
            return this.mergedStateWindows;
        }

        public void merge(TimeWindow mergeResult, Collection<TimeWindow> mergedWindows, TimeWindow stateWindowResult, Collection<TimeWindow> mergedStateWindows) throws Exception {
            if (this.target != null) {
                Assert.fail((String)"More than one merge for adding a Window should not occur.");
            }
            this.stateWindow = stateWindowResult;
            this.target = mergeResult;
            this.mergedStateWindows = mergedStateWindows;
            this.sources = mergedWindows;
        }
    }

    private static class MockMapState<K, V>
    implements MapState<K, V> {
        private final Map<K, V> map = new HashMap();

        private MockMapState() {
        }

        public V get(K k) throws Exception {
            return this.map.get(k);
        }

        public void put(K k, V v) throws Exception {
            this.map.put(k, v);
        }

        public void putAll(Map<K, V> map) throws Exception {
            this.map.putAll(map);
        }

        public void remove(K k) throws Exception {
            this.map.remove(k);
        }

        public boolean contains(K k) throws Exception {
            return this.map.containsKey(k);
        }

        public Iterable<Map.Entry<K, V>> entries() throws Exception {
            return this.map.entrySet();
        }

        public Iterable<K> keys() throws Exception {
            return this.map.keySet();
        }

        public Iterable<V> values() throws Exception {
            return this.map.values();
        }

        public Iterator<Map.Entry<K, V>> iterator() throws Exception {
            return this.map.entrySet().iterator();
        }

        public boolean isEmpty() throws Exception {
            return this.map.isEmpty();
        }

        public void clear() {
            this.map.clear();
        }
    }
}

