/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.operators.sort.SortUtil;

public class StringNormalizedKeyComputer
implements NormalizedKeyComputer {
    public void putKey(BaseRow record, MemorySegment target, int offset) {
        if (record.isNullAt(0)) {
            SortUtil.minNormalizedKey((MemorySegment)target, (int)offset, (int)8);
        } else {
            SortUtil.putStringNormalizedKey((BinaryString)record.getString(0), (MemorySegment)target, (int)offset, (int)8);
        }
        target.putLong(offset, Long.reverseBytes(target.getLong(offset)));
    }

    public int compareKey(MemorySegment segI, int offsetI, MemorySegment segJ, int offsetJ) {
        long l1;
        long l0 = segI.getLong(offsetI);
        if (l0 != (l1 = segJ.getLong(offsetJ))) {
            return l0 < l1 ^ l0 < 0L ^ l1 < 0L ? -1 : 1;
        }
        return 0;
    }

    public void swapKey(MemorySegment segI, int offsetI, MemorySegment segJ, int offsetJ) {
        long temp0 = segI.getLong(offsetI);
        segI.putLong(offsetI, segJ.getLong(offsetJ));
        segJ.putLong(offsetJ, temp0);
    }

    public int getNumKeyBytes() {
        return 8;
    }

    public boolean isKeyFullyDetermines() {
        return false;
    }

    public boolean invertKey() {
        return false;
    }
}

