/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.operators.sort.SortUtil;

public class IntNormalizedKeyComputer
implements NormalizedKeyComputer {
    public static final IntNormalizedKeyComputer INSTANCE = new IntNormalizedKeyComputer();

    public void putKey(BaseRow record, MemorySegment target, int offset) {
        if (record.isNullAt(0)) {
            SortUtil.minNormalizedKey((MemorySegment)target, (int)offset, (int)5);
        } else {
            target.put(offset, (byte)1);
            SortUtil.putIntNormalizedKey((int)record.getInt(0), (MemorySegment)target, (int)(offset + 1), (int)4);
        }
        target.putInt(offset, Integer.reverseBytes(target.getInt(offset)));
    }

    public int compareKey(MemorySegment segI, int offsetI, MemorySegment segJ, int offsetJ) {
        byte byte2;
        int int2;
        int int1 = segI.getInt(offsetI);
        if (int1 != (int2 = segJ.getInt(offsetJ))) {
            return int1 < int2 ^ int1 < 0 ^ int2 < 0 ? -1 : 1;
        }
        byte byte1 = segI.get(offsetI + 4);
        if (byte1 != (byte2 = segJ.get(offsetJ + 4))) {
            return byte1 < byte2 ^ byte1 < 0 ^ byte2 < 0 ? -1 : 1;
        }
        return 0;
    }

    public void swapKey(MemorySegment segI, int offsetI, MemorySegment segJ, int offsetJ) {
        int temp0 = segI.getInt(offsetI);
        segI.putInt(offsetI, segJ.getInt(offsetJ));
        segJ.putInt(offsetJ, temp0);
        byte temp1 = segI.get(offsetI + 4);
        segI.put(offsetI + 4, segJ.get(offsetJ + 4));
        segJ.put(offsetJ + 4, temp1);
    }

    public int getNumKeyBytes() {
        return 5;
    }

    public boolean isKeyFullyDetermines() {
        return true;
    }

    public boolean invertKey() {
        return false;
    }
}

