/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.util.ArrayList;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRangeWithoutEnd;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.VariableRankRange;
import org.apache.flink.table.runtime.operators.sort.IntRecordComparator;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.runtime.util.BaseRowHarnessAssertor;
import org.apache.flink.table.runtime.util.BaseRowRecordEqualiser;
import org.apache.flink.table.runtime.util.BinaryRowKeySelector;
import org.apache.flink.table.runtime.util.GenericRowRecordSortComparator;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.junit.Test;

abstract class TopNFunctionTestBase {
    Time minTime = Time.milliseconds((long)10L);
    Time maxTime = Time.milliseconds((long)20L);
    long cacheSize = 10000L;
    BaseRowTypeInfo inputRowType = new BaseRowTypeInfo(new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new BigIntType(), new IntType()});
    static GeneratedRecordComparator sortKeyComparator = new GeneratedRecordComparator("", "", new Object[0]){
        private static final long serialVersionUID = 1434685115916728955L;

        public RecordComparator newInstance(ClassLoader classLoader) {
            return IntRecordComparator.INSTANCE;
        }
    };
    private int sortKeyIdx = 2;
    BinaryRowKeySelector sortKeySelector = new BinaryRowKeySelector(new int[]{this.sortKeyIdx}, this.inputRowType.getLogicalTypes());
    static GeneratedRecordEqualiser generatedEqualiser = new GeneratedRecordEqualiser("", "", new Object[0]){
        private static final long serialVersionUID = 8932460173848746733L;

        public RecordEqualiser newInstance(ClassLoader classLoader) {
            return new BaseRowRecordEqualiser();
        }
    };
    private int partitionKeyIdx = 0;
    private BinaryRowKeySelector keySelector = new BinaryRowKeySelector(new int[]{this.partitionKeyIdx}, this.inputRowType.getLogicalTypes());
    private BaseRowTypeInfo outputTypeWithoutRowNumber = this.inputRowType;
    private BaseRowTypeInfo outputTypeWithRowNumber = new BaseRowTypeInfo(new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new BigIntType(), new IntType(), new BigIntType()});
    BaseRowHarnessAssertor assertorWithoutRowNumber = new BaseRowHarnessAssertor(this.outputTypeWithoutRowNumber.getFieldTypes(), new GenericRowRecordSortComparator(this.sortKeyIdx, this.outputTypeWithoutRowNumber.getLogicalTypes()[this.sortKeyIdx]));
    BaseRowHarnessAssertor assertorWithRowNumber = new BaseRowHarnessAssertor(this.outputTypeWithRowNumber.getFieldTypes(), new GenericRowRecordSortComparator(this.sortKeyIdx, this.outputTypeWithRowNumber.getLogicalTypes()[this.sortKeyIdx]));
    private int rowKeyIdx = 1;
    BinaryRowKeySelector rowKeySelector = new BinaryRowKeySelector(new int[]{this.rowKeyIdx}, this.inputRowType.getLogicalTypes());

    TopNFunctionTestBase() {
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testInvalidVariableRankRangeWithIntType() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new VariableRankRange(0), true, false);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testNotSupportRank() throws Exception {
        this.createFunction(RankType.RANK, (RankRange)new ConstantRankRange(1L, 10L), true, true);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testNotSupportDenseRank() throws Exception {
        this.createFunction(RankType.DENSE_RANK, (RankRange)new ConstantRankRange(1L, 10L), true, true);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testNotSupportWithoutRankEnd() throws Exception {
        this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRangeWithoutEnd(1L), true, true);
    }

    @Test
    public void testDisableGenerateRetraction() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), false, false);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 3L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.record("book", 5L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 11));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.record("book", 5L, 11));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33));
        expectedOutput.add(StreamRecordUtils.record("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.deleteRecord("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.record("fruit", 5L, 22));
        this.assertorWithoutRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testDisableGenerateRetractionAndOutputRankNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), false, true);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.record("book", 5L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 5L, 11, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 3L, 44, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 5L, 22, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33, 2L));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testOutputRankNumberWithConstantRankRange() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, true);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.record("book", 5L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 1L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 5L, 11, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 3L, 44, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 3L, 44, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 5L, 22, 1L));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testConstantRankRangeWithOffset() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(2L, 2L), true, false);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.record("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33));
        this.assertorWithoutRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testOutputRankNumberWithVariableRankRange() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new VariableRankRange(1), true, true);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 1L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 1L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 1L, 22, 1L));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testConstantRankRangeWithoutOffset() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, false);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 5L, 22));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 11));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33));
        expectedOutput.add(StreamRecordUtils.record("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.record("fruit", 5L, 22));
        this.assertorWithoutRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        OperatorSubtaskState snapshot = testHarness.snapshot(0L, 0L);
        testHarness.close();
        expectedOutput.clear();
        func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, false);
        testHarness = this.createTestHarness(func);
        testHarness.setup();
        testHarness.initializeState(snapshot);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 10));
        testHarness.close();
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 10));
        this.assertorWithoutRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    OneInputStreamOperatorTestHarness<BaseRow, BaseRow> createTestHarness(AbstractTopNFunction rankFunction) throws Exception {
        KeyedProcessOperator operator = new KeyedProcessOperator((KeyedProcessFunction)rankFunction);
        rankFunction.setKeyContext((KeyContext)operator);
        return new KeyedOneInputStreamOperatorTestHarness((OneInputStreamOperator)operator, (KeySelector)this.keySelector, (TypeInformation)this.keySelector.getProducedType());
    }

    abstract AbstractTopNFunction createFunction(RankType var1, RankRange var2, boolean var3, boolean var4);
}

