/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.util.ArrayList;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.keyselector.BaseRowKeySelector;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.RetractableTopNFunction;
import org.apache.flink.table.runtime.operators.rank.TopNFunctionTestBase;
import org.apache.flink.table.runtime.operators.rank.VariableRankRange;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.junit.Test;

public class RetractableTopNFunctionTest
extends TopNFunctionTestBase {
    @Override
    protected AbstractTopNFunction createFunction(RankType rankType, RankRange rankRange, boolean generateRetraction, boolean outputRankNumber) {
        return new RetractableTopNFunction(this.minTime.toMilliseconds(), this.maxTime.toMilliseconds(), this.inputRowType, sortKeyComparator, (BaseRowKeySelector)this.sortKeySelector, rankType, rankRange, generatedEqualiser, generateRetraction, outputRankNumber);
    }

    @Test
    public void testProcessRetractMessageWithNotGenerateRetraction() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), false, true);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.retractRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 5L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 1L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 5L, 11, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 3L, 44, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 5L, 22, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33, 2L));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testProcessRetractMessageWithGenerateRetraction() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, true);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.retractRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 5L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 1L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 5L, 11, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 3L, 44, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 3L, 44, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 5L, 22, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33, 2L));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testConstantRankRangeWithoutOffsetWithRowNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, true);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 5L, 22));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 3L, 44, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 3L, 44, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 5L, 22, 1L));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        OperatorSubtaskState snapshot = testHarness.snapshot(0L, 0L);
        testHarness.close();
        expectedOutput.clear();
        func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, true);
        testHarness = this.createTestHarness(func);
        testHarness.setup();
        testHarness.initializeState(snapshot);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 10));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 1L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 4L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 11, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 10, 1L));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Test
    public void testConstantRankRangeWithoutOffsetWithoutRowNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, false);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 5L, 22));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 11));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33));
        expectedOutput.add(StreamRecordUtils.record("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.deleteRecord("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.record("fruit", 5L, 22));
        this.assertorWithoutRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
        OperatorSubtaskState snapshot = testHarness.snapshot(0L, 0L);
        testHarness.close();
        expectedOutput.clear();
        func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, false);
        testHarness = this.createTestHarness(func);
        testHarness.setup();
        testHarness.initializeState(snapshot);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 10));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 10));
        this.assertorWithoutRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Test
    public void testVariableRankRangeWithRowNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new VariableRankRange(1), true, true);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 1L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 1L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 1L, 22, 1L));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testVariableRankRangeWithoutRowNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new VariableRankRange(1), true, false);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 12));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.record("fruit", 1L, 33));
        expectedOutput.add(StreamRecordUtils.deleteRecord("fruit", 1L, 33));
        expectedOutput.add(StreamRecordUtils.record("fruit", 1L, 22));
        this.assertorWithoutRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testDisableGenerateRetractionWithRowNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), false, true);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 3L, 44, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 5L, 22, 1L));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testDisableGenerateRetractionWithoutRowNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), false, false);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 11));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 33));
        expectedOutput.add(StreamRecordUtils.record("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.deleteRecord("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.record("fruit", 5L, 22));
        this.assertorWithoutRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testCleanIdleState() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, true);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.setProcessingTime(0L);
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("fruit", 5L, 22));
        testHarness.setProcessingTime(9L);
        testHarness.processElement(StreamRecordUtils.retractRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("fruit", 4L, 11));
        testHarness.setProcessingTime(20L);
        testHarness.processElement(StreamRecordUtils.record("fruit", 8L, 100));
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 5L, 22, 1L));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.deleteRecord("fruit", 5L, 22, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 5L, 22, 2L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 4L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 8L, 100, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12, 1L));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }
}

