/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.runtime.dataview.StateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;

public class SumAggsHandleFunction
implements AggsHandleFunction {
    private final int inputIndex;
    private long sum;

    public SumAggsHandleFunction(int inputIndex) {
        this.inputIndex = inputIndex;
    }

    public void open(StateDataViewStore store) throws Exception {
    }

    public void accumulate(BaseRow input) throws Exception {
        this.sum += input.getLong(this.inputIndex);
    }

    public void retract(BaseRow input) throws Exception {
        this.sum -= input.getLong(this.inputIndex);
    }

    public void merge(BaseRow accumulator) throws Exception {
        this.sum += accumulator.getLong(0);
    }

    public void setAccumulators(BaseRow accumulator) throws Exception {
        this.sum = accumulator.getLong(0);
    }

    public void resetAccumulators() throws Exception {
        this.sum = 0L;
    }

    public BaseRow getAccumulators() throws Exception {
        return GenericRow.of((Object[])new Object[]{this.sum});
    }

    public BaseRow createAccumulators() throws Exception {
        return GenericRow.of((Object[])new Object[]{0L});
    }

    public BaseRow getValue() throws Exception {
        return this.getAccumulators();
    }

    public void cleanup() throws Exception {
    }

    public void close() throws Exception {
    }
}

