/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.TwoInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.TwoInputStreamTaskTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.operators.join.HashJoinOperator;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import org.apache.flink.table.runtime.operators.join.Int2HashJoinOperatorTest;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.junit.Test;

public class String2HashJoinOperatorTest
implements Serializable {
    private BaseRowTypeInfo typeInfo = new BaseRowTypeInfo(new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new VarCharType(Integer.MAX_VALUE)});
    private BaseRowTypeInfo joinedInfo = new BaseRowTypeInfo(new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new VarCharType(Integer.MAX_VALUE), new VarCharType(Integer.MAX_VALUE), new VarCharType(Integer.MAX_VALUE)});
    private transient TwoInputStreamTaskTestHarness<BinaryRow, BinaryRow, JoinedRow> testHarness;
    private ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue();
    private long initialTime = 0L;

    public static LinkedBlockingQueue<Object> transformToBinary(LinkedBlockingQueue<Object> output) {
        LinkedBlockingQueue<Object> ret = new LinkedBlockingQueue<Object>();
        for (Object o : output) {
            BinaryRow binaryRow;
            BaseRow row = (BaseRow)((StreamRecord)o).getValue();
            if (row.isNullAt(0)) {
                binaryRow = String2HashJoinOperatorTest.newRow(row.getString(2).toString(), row.getString(3) + "null");
            } else if (row.isNullAt(2)) {
                binaryRow = String2HashJoinOperatorTest.newRow(row.getString(0).toString(), row.getString(1) + "null");
            } else {
                String value1 = row.getString(1).toString();
                String value2 = row.getString(3).toString();
                binaryRow = String2HashJoinOperatorTest.newRow(row.getString(0).toString(), value1 + value2);
            }
            ret.add(new StreamRecord((Object)binaryRow));
        }
        return ret;
    }

    private void init(boolean leftOut, boolean rightOut, boolean buildLeft) throws Exception {
        HashJoinType type = HashJoinType.of((boolean)buildLeft, (boolean)leftOut, (boolean)rightOut);
        HashJoinOperator operator = this.newOperator(0x108000L, type, !buildLeft);
        this.testHarness = new TwoInputStreamTaskTestHarness(TwoInputStreamTask::new, 2, 2, new int[]{1, 2}, (TypeInformation)this.typeInfo, (TypeInformation)this.typeInfo, (TypeInformation)this.joinedInfo);
        this.testHarness.memorySize = 0x2400000L;
        this.testHarness.getExecutionConfig().enableObjectReuse();
        this.testHarness.setupOutputForSingletonOperatorChain();
        this.testHarness.getStreamConfig().setStreamOperator((StreamOperator)operator);
        this.testHarness.getStreamConfig().setOperatorID(new OperatorID());
        this.testHarness.getStreamConfig().setManagedMemoryFraction(0.99);
        this.testHarness.invoke();
        this.testHarness.waitForTaskRunning();
    }

    @Test
    public void testInnerHashJoin() throws Exception {
        this.init(false, false, true);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("d", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "1"), this.initialTime), 0, 1);
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(0, 0);
        this.testHarness.endInput(0, 1);
        this.testHarness.waitForInputProcessing();
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "2"), this.initialTime), 1, 1);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "02")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("c", "2"), this.initialTime), 1, 1);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "4"), this.initialTime), 1, 0);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "14")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(1, 0);
        this.testHarness.endInput(1, 1);
        this.testHarness.waitForTaskCompletion();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
    }

    @Test
    public void testProbeOuterHashJoin() throws Exception {
        this.init(true, false, false);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("d", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "1"), this.initialTime), 0, 1);
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(0, 0);
        this.testHarness.endInput(0, 1);
        this.testHarness.waitForInputProcessing();
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "2"), this.initialTime), 1, 1);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "20")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("c", "2"), this.initialTime), 1, 1);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "4"), this.initialTime), 1, 0);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("c", "2null")));
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "41")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(1, 0);
        this.testHarness.endInput(1, 1);
        this.testHarness.waitForTaskCompletion();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
    }

    @Test
    public void testBuildOuterHashJoin() throws Exception {
        this.init(false, true, false);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("d", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "1"), this.initialTime), 0, 1);
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(0, 0);
        this.testHarness.endInput(0, 1);
        this.testHarness.waitForInputProcessing();
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "2"), this.initialTime), 1, 1);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "20")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("c", "2"), this.initialTime), 1, 1);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "4"), this.initialTime), 1, 0);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "41")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(1, 0);
        this.testHarness.endInput(1, 1);
        this.testHarness.waitForTaskCompletion();
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("d", "0null")));
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
    }

    @Test
    public void testFullOuterHashJoin() throws Exception {
        this.init(true, true, true);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("d", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "1"), this.initialTime), 0, 1);
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(0, 0);
        this.testHarness.endInput(0, 1);
        this.testHarness.waitForInputProcessing();
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "2"), this.initialTime), 1, 1);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "02")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("c", "2"), this.initialTime), 1, 1);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "4"), this.initialTime), 1, 0);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("c", "2null")));
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "14")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(1, 0);
        this.testHarness.endInput(1, 1);
        this.testHarness.waitForTaskCompletion();
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("d", "0null")));
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
    }

    public static BinaryRow newRow(String ... s) {
        BinaryRow row = new BinaryRow(s.length);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null) {
                writer.setNullAt(i);
                continue;
            }
            writer.writeString(i, BinaryString.fromString((String)s[i]));
        }
        writer.complete();
        return row;
    }

    private HashJoinOperator newOperator(long memorySize, HashJoinType type, boolean reverseJoinFunction) {
        return HashJoinOperator.newHashJoinOperator((HashJoinType)type, (GeneratedJoinCondition)new GeneratedJoinCondition("", "", new Object[0]){

            public JoinCondition newInstance(ClassLoader classLoader) {
                return new Int2HashJoinOperatorTest.TrueCondition();
            }
        }, (boolean)reverseJoinFunction, (boolean[])new boolean[]{true}, (GeneratedProjection)new GeneratedProjection("", "", new Object[0]){

            public Projection newInstance(ClassLoader classLoader) {
                return new MyProjection();
            }
        }, (GeneratedProjection)new GeneratedProjection("", "", new Object[0]){

            public Projection newInstance(ClassLoader classLoader) {
                return new MyProjection();
            }
        }, (boolean)false, (int)20, (long)10000L, (long)10000L, (RowType)RowType.of((LogicalType[])new LogicalType[]{new VarCharType(Integer.MAX_VALUE)}));
    }

    public static final class MyProjection
    implements Projection<BinaryRow, BinaryRow> {
        BinaryRow innerRow = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(this.innerRow);

        public BinaryRow apply(BinaryRow row) {
            this.writer.reset();
            this.writer.writeString(0, row.getString(0));
            this.writer.complete();
            return this.innerRow;
        }
    }
}

