/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.ProcessOperator;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.collector.TableFunctionCollector;
import org.apache.flink.table.runtime.generated.GeneratedCollectorWrapper;
import org.apache.flink.table.runtime.generated.GeneratedFunctionWrapper;
import org.apache.flink.table.runtime.operators.join.lookup.LookupJoinRunner;
import org.apache.flink.table.runtime.operators.join.lookup.LookupJoinWithCalcRunner;
import org.apache.flink.table.runtime.typeutils.BaseRowSerializer;
import org.apache.flink.table.runtime.util.BaseRowHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.util.Collector;
import org.junit.Test;

public class LookupJoinHarnessTest {
    private final TypeSerializer<BaseRow> inSerializer = new BaseRowSerializer(new ExecutionConfig(), new LogicalType[]{new IntType(), new VarCharType(Integer.MAX_VALUE)});
    private final BaseRowHarnessAssertor assertor = new BaseRowHarnessAssertor(new TypeInformation[]{Types.INT, Types.STRING, Types.INT, Types.STRING});

    @Test
    public void testTemporalInnerJoin() throws Exception {
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createHarness(JoinType.INNER_JOIN, FilterOnTable.WITHOUT_FILTER);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record(1, "a"));
        testHarness.processElement(StreamRecordUtils.record(2, "b"));
        testHarness.processElement(StreamRecordUtils.record(3, "c"));
        testHarness.processElement(StreamRecordUtils.record(4, "d"));
        testHarness.processElement(StreamRecordUtils.record(5, "e"));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record(1, "a", 1, "Julian"));
        expectedOutput.add(StreamRecordUtils.record(3, "c", 3, "Jark"));
        expectedOutput.add(StreamRecordUtils.record(3, "c", 3, "Jackson"));
        expectedOutput.add(StreamRecordUtils.record(4, "d", 4, "Fabian"));
        this.assertor.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Test
    public void testTemporalInnerJoinWithFilter() throws Exception {
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createHarness(JoinType.INNER_JOIN, FilterOnTable.WITH_FILTER);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record(1, "a"));
        testHarness.processElement(StreamRecordUtils.record(2, "b"));
        testHarness.processElement(StreamRecordUtils.record(3, "c"));
        testHarness.processElement(StreamRecordUtils.record(4, "d"));
        testHarness.processElement(StreamRecordUtils.record(5, "e"));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record(1, "a", 1, "Julian"));
        expectedOutput.add(StreamRecordUtils.record(3, "c", 3, "Jackson"));
        expectedOutput.add(StreamRecordUtils.record(4, "d", 4, "Fabian"));
        this.assertor.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Test
    public void testTemporalLeftJoin() throws Exception {
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createHarness(JoinType.LEFT_JOIN, FilterOnTable.WITHOUT_FILTER);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record(1, "a"));
        testHarness.processElement(StreamRecordUtils.record(2, "b"));
        testHarness.processElement(StreamRecordUtils.record(3, "c"));
        testHarness.processElement(StreamRecordUtils.record(4, "d"));
        testHarness.processElement(StreamRecordUtils.record(5, "e"));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record(1, "a", 1, "Julian"));
        expectedOutput.add(StreamRecordUtils.record(2, "b", null, null));
        expectedOutput.add(StreamRecordUtils.record(3, "c", 3, "Jark"));
        expectedOutput.add(StreamRecordUtils.record(3, "c", 3, "Jackson"));
        expectedOutput.add(StreamRecordUtils.record(4, "d", 4, "Fabian"));
        expectedOutput.add(StreamRecordUtils.record(5, "e", null, null));
        this.assertor.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Test
    public void testTemporalLeftJoinWithFilter() throws Exception {
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createHarness(JoinType.LEFT_JOIN, FilterOnTable.WITH_FILTER);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record(1, "a"));
        testHarness.processElement(StreamRecordUtils.record(2, "b"));
        testHarness.processElement(StreamRecordUtils.record(3, "c"));
        testHarness.processElement(StreamRecordUtils.record(4, "d"));
        testHarness.processElement(StreamRecordUtils.record(5, "e"));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record(1, "a", 1, "Julian"));
        expectedOutput.add(StreamRecordUtils.record(2, "b", null, null));
        expectedOutput.add(StreamRecordUtils.record(3, "c", 3, "Jackson"));
        expectedOutput.add(StreamRecordUtils.record(4, "d", 4, "Fabian"));
        expectedOutput.add(StreamRecordUtils.record(5, "e", null, null));
        this.assertor.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    private OneInputStreamOperatorTestHarness<BaseRow, BaseRow> createHarness(JoinType joinType, FilterOnTable filterOnTable) throws Exception {
        boolean isLeftJoin = joinType == JoinType.LEFT_JOIN;
        Object joinRunner = filterOnTable == FilterOnTable.WITHOUT_FILTER ? new LookupJoinRunner(new GeneratedFunctionWrapper<TestingFetcherFunction>(new TestingFetcherFunction()), new GeneratedCollectorWrapper<TestingFetcherCollector>(new TestingFetcherCollector()), isLeftJoin, 2) : new LookupJoinWithCalcRunner(new GeneratedFunctionWrapper<TestingFetcherFunction>(new TestingFetcherFunction()), new GeneratedFunctionWrapper<CalculateOnTemporalTable>(new CalculateOnTemporalTable()), new GeneratedCollectorWrapper<TestingFetcherCollector>(new TestingFetcherCollector()), isLeftJoin, 2);
        ProcessOperator operator = new ProcessOperator((ProcessFunction)joinRunner);
        return new OneInputStreamOperatorTestHarness((OneInputStreamOperator)operator, this.inSerializer);
    }

    public static final class CalculateOnTemporalTable
    implements FlatMapFunction<BaseRow, BaseRow> {
        private static final long serialVersionUID = -1860345072157431136L;

        public void flatMap(BaseRow value, Collector<BaseRow> out) throws Exception {
            BinaryString name = value.getString(1);
            if (name.getSizeInBytes() >= 6) {
                out.collect((Object)value);
            }
        }
    }

    public static final class TestingFetcherCollector
    extends TableFunctionCollector {
        private static final long serialVersionUID = -312754413938303160L;

        public void collect(Object record) {
            BaseRow left = (BaseRow)this.getInput();
            BaseRow right = (BaseRow)record;
            this.outputResult(new JoinedRow(left, right));
        }
    }

    public static final class TestingFetcherFunction
    implements FlatMapFunction<BaseRow, BaseRow> {
        private static final long serialVersionUID = 4018474964018227081L;
        private static final Map<Integer, List<GenericRow>> data = new HashMap<Integer, List<GenericRow>>();

        public void flatMap(BaseRow value, Collector<BaseRow> out) throws Exception {
            int id = value.getInt(0);
            List<GenericRow> rows = data.get(id);
            if (rows != null) {
                for (GenericRow row : rows) {
                    out.collect((Object)row);
                }
            }
        }

        static {
            data.put(1, Collections.singletonList(GenericRow.of((Object[])new Object[]{1, BinaryString.fromString((String)"Julian")})));
            data.put(3, Arrays.asList(GenericRow.of((Object[])new Object[]{3, BinaryString.fromString((String)"Jark")}), GenericRow.of((Object[])new Object[]{3, BinaryString.fromString((String)"Jackson")})));
            data.put(4, Collections.singletonList(GenericRow.of((Object[])new Object[]{4, BinaryString.fromString((String)"Fabian")})));
        }
    }

    private static enum FilterOnTable {
        WITH_FILTER,
        WITHOUT_FILTER;

    }

    private static enum JoinType {
        INNER_JOIN,
        LEFT_JOIN;

    }
}

