/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.util.LinkedHashMap;
import org.apache.flink.table.filesystem.PartitionPathUtils;
import org.apache.flink.table.filesystem.RowPartitionComputer;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;

public class RowPartitionComputerTest {
    @Test
    public void testProjectColumnsToWrite() throws Exception {
        Row projected1 = new RowPartitionComputer("", new String[]{"f1", "p1", "p2", "f2"}, new String[]{"p1", "p2"}).projectColumnsToWrite(Row.of((Object[])new Object[]{1, 2, 3, 4}));
        Assert.assertEquals((Object)Row.of((Object[])new Object[]{1, 4}), (Object)projected1);
        Row projected2 = new RowPartitionComputer("", new String[]{"f1", "f2", "p1", "p2"}, new String[]{"p1", "p2"}).projectColumnsToWrite(Row.of((Object[])new Object[]{1, 2, 3, 4}));
        Assert.assertEquals((Object)Row.of((Object[])new Object[]{1, 2}), (Object)projected2);
        Row projected3 = new RowPartitionComputer("", new String[]{"f1", "p1", "f2", "p2"}, new String[]{"p1", "p2"}).projectColumnsToWrite(Row.of((Object[])new Object[]{1, 2, 3, 4}));
        Assert.assertEquals((Object)Row.of((Object[])new Object[]{1, 3}), (Object)projected3);
    }

    @Test
    public void testComputePartition() throws Exception {
        RowPartitionComputer computer = new RowPartitionComputer("myDefaultname", new String[]{"f1", "p1", "p2", "f2"}, new String[]{"p1", "p2"});
        Assert.assertEquals((Object)"p1=2/p2=3/", (Object)PartitionPathUtils.generatePartitionPath((LinkedHashMap)computer.generatePartValues(Row.of((Object[])new Object[]{1, 2, 3, 4}))));
        Assert.assertEquals((Object)"p1=myDefaultname/p2=3/", (Object)PartitionPathUtils.generatePartitionPath((LinkedHashMap)computer.generatePartValues(Row.of((Object[])new Object[]{1, null, 3, 4}))));
    }
}

