/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.math.BigDecimal;
import org.apache.flink.table.dataformat.Decimal;
import org.junit.Assert;
import org.junit.Test;

public class DecimalTest {
    @Test
    public void testNormal() {
        Decimal decimal1 = Decimal.fromLong((long)10L, (int)5, (int)0);
        Decimal decimal2 = Decimal.fromLong((long)15L, (int)5, (int)0);
        Assert.assertEquals((long)decimal1.hashCode(), (long)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)5, (int)0).hashCode());
        Assert.assertEquals((Object)decimal1, (Object)decimal1.copy());
        Assert.assertEquals((Object)decimal1, (Object)Decimal.fromUnscaledLong((int)5, (int)0, (long)decimal1.toUnscaledLong()));
        Assert.assertEquals((Object)decimal1, (Object)Decimal.fromUnscaledBytes((int)5, (int)0, (byte[])decimal1.toUnscaledBytes()));
        Assert.assertTrue((decimal1.compareTo(decimal2) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)decimal1.signum());
        Assert.assertTrue((10.5 == Decimal.castFrom((double)10.5, (int)5, (int)1).doubleValue() ? 1 : 0) != 0);
        Assert.assertEquals((Object)Decimal.fromLong((long)-10L, (int)5, (int)0), (Object)decimal1.negate());
        Assert.assertEquals((Object)decimal1, (Object)decimal1.abs());
        Assert.assertEquals((Object)decimal1, (Object)decimal1.negate().abs());
        Assert.assertEquals((long)25L, (long)Decimal.add((Decimal)decimal1, (Decimal)decimal2, (int)5, (int)0).toUnscaledLong());
        Assert.assertEquals((long)-5L, (long)Decimal.subtract((Decimal)decimal1, (Decimal)decimal2, (int)5, (int)0).toUnscaledLong());
        Assert.assertEquals((long)150L, (long)Decimal.multiply((Decimal)decimal1, (Decimal)decimal2, (int)5, (int)0).toUnscaledLong());
        Assert.assertTrue((0.67 == Decimal.divide((Decimal)decimal1, (Decimal)decimal2, (int)5, (int)2).doubleValue() ? 1 : 0) != 0);
        Assert.assertEquals((Object)decimal1, (Object)Decimal.mod((Decimal)decimal1, (Decimal)decimal2, (int)5, (int)0));
        Assert.assertEquals((long)5L, (long)Decimal.divideToIntegralValue((Decimal)decimal1, (Decimal)Decimal.fromLong((long)2L, (int)5, (int)0), (int)5, (int)0).toUnscaledLong());
        Assert.assertEquals((long)10L, (long)Decimal.castToIntegral((Decimal)decimal1));
        Assert.assertEquals((Object)true, (Object)Decimal.castToBoolean((Decimal)decimal1));
        Assert.assertTrue((Decimal.compare((Decimal)decimal1, (long)10L) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Decimal.compare((Decimal)decimal1, (long)5L) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)Decimal.castFrom((double)1.0, (int)10, (int)5), (Object)Decimal.sign((Decimal)Decimal.castFrom((double)5.556, (int)10, (int)5)));
        Assert.assertNull((Object)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(Long.MAX_VALUE), (int)5, (int)0));
        Assert.assertEquals((long)0L, (long)Decimal.zero((int)5, (int)2).toBigDecimal().intValue());
        Assert.assertEquals((long)0L, (long)Decimal.zero((int)20, (int)2).toBigDecimal().intValue());
        Assert.assertEquals((Object)Decimal.fromLong((long)10L, (int)5, (int)0), (Object)Decimal.castFrom((double)10.5, (int)5, (int)1).floor());
        Assert.assertEquals((Object)Decimal.fromLong((long)11L, (int)5, (int)0), (Object)Decimal.castFrom((double)10.5, (int)5, (int)1).ceil());
        Assert.assertEquals((Object)"5.00", (Object)Decimal.castToDecimal((Decimal)Decimal.castFrom((double)5.0, (int)10, (int)1), (int)10, (int)2).toString());
        Assert.assertEquals((Object)true, (Object)Decimal.castToBoolean((Decimal)Decimal.castFrom((boolean)true, (int)5, (int)0)));
        Assert.assertEquals((long)5L, (long)Decimal.castToIntegral((Decimal)Decimal.castFrom((long)5L, (int)5, (int)0)));
        Assert.assertEquals((long)5L, (long)Decimal.castToIntegral((Decimal)Decimal.castFrom((String)"5", (int)5, (int)0)));
        Assert.assertEquals((long)5000L, (long)Decimal.castToTimestamp((Decimal)Decimal.castFrom((String)"5", (int)5, (int)0)));
        Decimal newDecimal = Decimal.castFrom((Decimal)Decimal.castFrom((long)10L, (int)5, (int)2), (int)10, (int)4);
        Assert.assertEquals((long)10L, (long)newDecimal.getPrecision());
        Assert.assertEquals((long)4L, (long)newDecimal.getScale());
        Assert.assertEquals((Object)true, (Object)Decimal.is32BitDecimal((int)6));
        Assert.assertEquals((Object)true, (Object)Decimal.is64BitDecimal((int)11));
        Assert.assertEquals((Object)true, (Object)Decimal.isByteArrayDecimal((int)20));
        Assert.assertEquals((long)6L, (long)Decimal.sround((Decimal)Decimal.castFrom((double)5.555, (int)5, (int)0), (int)1).toUnscaledLong());
        Assert.assertEquals((long)56L, (long)Decimal.sround((Decimal)Decimal.castFrom((double)5.555, (int)5, (int)3), (int)1).toUnscaledLong());
    }

    @Test
    public void testNotCompact() {
        Decimal decimal1 = Decimal.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)20, (int)0);
        Decimal decimal2 = Decimal.fromBigDecimal((BigDecimal)new BigDecimal(15), (int)20, (int)0);
        Assert.assertEquals((long)decimal1.hashCode(), (long)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)20, (int)0).hashCode());
        Assert.assertEquals((Object)decimal1, (Object)decimal1.copy());
        Assert.assertEquals((Object)decimal1, (Object)Decimal.fromBigDecimal((BigDecimal)decimal1.toBigDecimal(), (int)20, (int)0));
        Assert.assertEquals((Object)decimal1, (Object)Decimal.fromUnscaledBytes((int)20, (int)0, (byte[])decimal1.toUnscaledBytes()));
        Assert.assertTrue((decimal1.compareTo(decimal2) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)decimal1.signum());
        Assert.assertTrue((10.5 == Decimal.castFrom((double)10.5, (int)20, (int)1).doubleValue() ? 1 : 0) != 0);
        Assert.assertEquals((Object)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(-10), (int)20, (int)0), (Object)decimal1.negate());
        Assert.assertEquals((Object)decimal1, (Object)decimal1.abs());
        Assert.assertEquals((Object)decimal1, (Object)decimal1.negate().abs());
        Assert.assertEquals((long)25L, (long)Decimal.add((Decimal)decimal1, (Decimal)decimal2, (int)20, (int)0).toBigDecimal().longValue());
        Assert.assertEquals((long)-5L, (long)Decimal.subtract((Decimal)decimal1, (Decimal)decimal2, (int)20, (int)0).toBigDecimal().longValue());
        Assert.assertEquals((long)150L, (long)Decimal.multiply((Decimal)decimal1, (Decimal)decimal2, (int)20, (int)0).toBigDecimal().longValue());
        Assert.assertTrue((0.67 == Decimal.divide((Decimal)decimal1, (Decimal)decimal2, (int)20, (int)2).doubleValue() ? 1 : 0) != 0);
        Assert.assertEquals((Object)decimal1, (Object)Decimal.mod((Decimal)decimal1, (Decimal)decimal2, (int)20, (int)0));
        Assert.assertEquals((long)5L, (long)Decimal.divideToIntegralValue((Decimal)decimal1, (Decimal)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(2), (int)20, (int)0), (int)20, (int)0).toBigDecimal().longValue());
        Assert.assertEquals((long)10L, (long)Decimal.castToIntegral((Decimal)decimal1));
        Assert.assertEquals((Object)true, (Object)Decimal.castToBoolean((Decimal)decimal1));
        Assert.assertTrue((Decimal.compare((Decimal)decimal1, (long)10L) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Decimal.compare((Decimal)decimal1, (long)5L) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((Decimal.compare((Decimal)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(10.5), (int)20, (int)2), (long)10L) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)Decimal.castFrom((double)1.0, (int)20, (int)5), (Object)Decimal.sign((Decimal)Decimal.castFrom((double)5.556, (int)20, (int)5)));
        Assert.assertNull((Object)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(Long.MAX_VALUE), (int)5, (int)0));
        Assert.assertEquals((long)0L, (long)Decimal.zero((int)20, (int)2).toBigDecimal().intValue());
        Assert.assertEquals((long)0L, (long)Decimal.zero((int)20, (int)2).toBigDecimal().intValue());
    }

    @Test
    public void testToString() {
        String val = "0.0000000000000000001";
        Assert.assertEquals((Object)val, (Object)Decimal.castFrom((String)val, (int)39, (int)(val.length() - 2)).toString());
        val = "123456789012345678901234567890123456789";
        Assert.assertEquals((Object)val, (Object)Decimal.castFrom((String)val, (int)39, (int)0).toString());
    }
}

