/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LocalDateSerializer;
import org.apache.flink.api.common.typeutils.base.LocalDateTimeSerializer;
import org.apache.flink.api.common.typeutils.base.LocalTimeSerializer;
import org.apache.flink.api.common.typeutils.base.SqlDateSerializer;
import org.apache.flink.api.common.typeutils.base.SqlTimeSerializer;
import org.apache.flink.api.common.typeutils.base.SqlTimestampSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.io.disk.RandomAccessOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryArrayWriter;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.DataFormatTestUtil;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.GenericArray;
import org.apache.flink.table.dataformat.GenericMap;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.SqlTimestamp;
import org.apache.flink.table.runtime.typeutils.BaseArraySerializer;
import org.apache.flink.table.runtime.typeutils.BaseMapSerializer;
import org.apache.flink.table.runtime.typeutils.BaseRowSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryGenericSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryRowSerializer;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.BinaryGenericAsserter;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class BinaryRowTest {
    @Test
    public void testBasic() {
        Assert.assertEquals((long)8L, (long)new BinaryRow(0).getFixedLengthPartSize());
        Assert.assertEquals((long)16L, (long)new BinaryRow(1).getFixedLengthPartSize());
        Assert.assertEquals((long)536L, (long)new BinaryRow(65).getFixedLengthPartSize());
        Assert.assertEquals((long)1048L, (long)new BinaryRow(128).getFixedLengthPartSize());
        MemorySegment segment = MemorySegmentFactory.wrap((byte[])new byte[100]);
        BinaryRow row = new BinaryRow(2);
        row.pointTo(segment, 10, 48);
        Assert.assertSame((Object)row.getSegments()[0], (Object)segment);
        row.setInt(0, 5);
        row.setDouble(1, 5.8);
    }

    @Test
    public void testSetAndGet() {
        MemorySegment segment = MemorySegmentFactory.wrap((byte[])new byte[80]);
        BinaryRow row = new BinaryRow(9);
        row.pointTo(segment, 0, 80);
        row.setNullAt(0);
        row.setInt(1, 11);
        row.setLong(2, 22L);
        row.setDouble(3, 33.0);
        row.setBoolean(4, true);
        row.setShort(5, (short)55);
        row.setByte(6, (byte)66);
        row.setFloat(7, 77.0f);
        Assert.assertEquals((double)33.0, (double)((long)row.getDouble(3)), (double)0.0);
        Assert.assertEquals((long)11L, (long)row.getInt(1));
        Assert.assertTrue((boolean)row.isNullAt(0));
        Assert.assertEquals((long)55L, (long)row.getShort(5));
        Assert.assertEquals((long)22L, (long)row.getLong(2));
        Assert.assertTrue((boolean)row.getBoolean(4));
        Assert.assertEquals((long)66L, (long)row.getByte(6));
        Assert.assertEquals((float)77.0f, (float)row.getFloat(7), (float)0.0f);
    }

    @Test
    public void testWriter() {
        int arity = 13;
        BinaryRow row = new BinaryRow(arity);
        BinaryRowWriter writer = new BinaryRowWriter(row, 20);
        writer.writeString(0, BinaryString.fromString((String)"1"));
        writer.writeString(3, BinaryString.fromString((String)"1234567"));
        writer.writeString(5, BinaryString.fromString((String)"12345678"));
        writer.writeString(9, BinaryString.fromString((String)"\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320"));
        writer.writeBoolean(1, true);
        writer.writeByte(2, (byte)99);
        writer.writeDouble(6, 87.1);
        writer.writeFloat(7, 26.1f);
        writer.writeInt(8, 88);
        writer.writeLong(10, 284L);
        writer.writeShort(11, (short)292);
        writer.setNullAt(12);
        writer.complete();
        this.assertTestWriterRow(row);
        this.assertTestWriterRow(row.copy());
        int subSize = row.getFixedLengthPartSize() + 10;
        MemorySegment subMs1 = MemorySegmentFactory.wrap((byte[])new byte[subSize]);
        MemorySegment subMs2 = MemorySegmentFactory.wrap((byte[])new byte[subSize]);
        row.getSegments()[0].copyTo(0, subMs1, 0, subSize);
        row.getSegments()[0].copyTo(subSize, subMs2, 0, row.getSizeInBytes() - subSize);
        BinaryRow toCopy = new BinaryRow(arity);
        toCopy.pointTo(new MemorySegment[]{subMs1, subMs2}, 0, row.getSizeInBytes());
        Assert.assertEquals((Object)row, (Object)toCopy);
        this.assertTestWriterRow(toCopy);
        this.assertTestWriterRow(toCopy.copy(new BinaryRow(arity)));
    }

    @Test
    public void testWriteString() {
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        char[] chars = new char[]{'\uffff', '\u0000'};
        writer.writeString(0, BinaryString.fromString((String)new String(chars)));
        writer.complete();
        String str = row.getString(0).toString();
        Assert.assertEquals((long)chars[0], (long)str.charAt(0));
        Assert.assertEquals((long)chars[1], (long)str.charAt(1));
        String str2 = "\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320";
        BinaryRow row2 = new BinaryRow(2);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        writer2.writeString(0, BinaryString.fromString((String)str2));
        writer2.writeString(1, BinaryString.fromBytes((byte[])str2.getBytes(StandardCharsets.UTF_8)));
        writer2.complete();
        Assert.assertEquals((Object)str2, (Object)row2.getString(0).toString());
        Assert.assertEquals((Object)str2, (Object)row2.getString(1).toString());
    }

    @Test
    public void testPagesSer() throws IOException {
        MemorySegment[] memorySegments = new MemorySegment[5];
        ArrayList<MemorySegment> memorySegmentList = new ArrayList<MemorySegment>();
        for (int i = 0; i < 5; ++i) {
            memorySegments[i] = MemorySegmentFactory.wrap((byte[])new byte[64]);
            memorySegmentList.add(memorySegments[i]);
        }
        String str = "\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320\uff0c\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320\uff0c\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320\u3002";
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, BinaryString.fromString((String)str));
        writer.complete();
        RandomAccessOutputView out = new RandomAccessOutputView(memorySegments, 64);
        BinaryRowSerializer serializer = new BinaryRowSerializer(1);
        serializer.serializeToPages(row, (AbstractPagedOutputView)out);
        BinaryRow mapRow = serializer.mapFromPages((AbstractPagedInputView)new RandomAccessInputView(memorySegmentList, 64));
        writer.reset();
        writer.writeString(0, mapRow.getString(0));
        writer.complete();
        Assert.assertEquals((Object)str, (Object)row.getString(0).toString());
        BinaryRow deserRow = serializer.deserializeFromPages((AbstractPagedInputView)new RandomAccessInputView(memorySegmentList, 64));
        writer.reset();
        writer.writeString(0, deserRow.getString(0));
        writer.complete();
        Assert.assertEquals((Object)str, (Object)row.getString(0).toString());
        String str1 = "\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320\uff0c\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320\uff0c\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320\u3002";
        String str2 = "\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320\u3002";
        BinaryRow row2 = new BinaryRow(2);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        writer2.writeString(0, BinaryString.fromString((String)str1));
        writer2.writeString(1, BinaryString.fromString((String)str2));
        writer2.complete();
        RandomAccessOutputView out2 = new RandomAccessOutputView(memorySegments, 64);
        out2.skipBytesToWrite(40);
        BinaryRowSerializer serializer2 = new BinaryRowSerializer(2);
        serializer2.serializeToPages(row2, (AbstractPagedOutputView)out2);
        RandomAccessInputView in = new RandomAccessInputView(memorySegmentList, 64);
        in.skipBytesToRead(40);
        BinaryRow mapRow2 = serializer2.mapFromPages((AbstractPagedInputView)in);
        writer2.reset();
        writer2.writeString(0, mapRow2.getString(0));
        writer2.writeString(1, mapRow2.getString(1));
        writer2.complete();
        Assert.assertEquals((Object)str1, (Object)row2.getString(0).toString());
        Assert.assertEquals((Object)str2, (Object)row2.getString(1).toString());
        in = new RandomAccessInputView(memorySegmentList, 64);
        in.skipBytesToRead(40);
        BinaryRow deserRow2 = serializer2.deserializeFromPages((AbstractPagedInputView)in);
        writer2.reset();
        writer2.writeString(0, deserRow2.getString(0));
        writer2.writeString(1, deserRow2.getString(1));
        writer2.complete();
        Assert.assertEquals((Object)str1, (Object)row2.getString(0).toString());
        Assert.assertEquals((Object)str2, (Object)row2.getString(1).toString());
    }

    private void assertTestWriterRow(BinaryRow row) {
        Assert.assertEquals((Object)"1", (Object)row.getString(0).toString());
        Assert.assertEquals((long)88L, (long)row.getInt(8));
        Assert.assertEquals((long)292L, (long)row.getShort(11));
        Assert.assertEquals((long)284L, (long)row.getLong(10));
        Assert.assertEquals((long)99L, (long)row.getByte(2));
        Assert.assertEquals((double)87.1, (double)row.getDouble(6), (double)0.0);
        Assert.assertEquals((float)26.1f, (float)row.getFloat(7), (float)0.0f);
        Assert.assertTrue((boolean)row.getBoolean(1));
        Assert.assertEquals((Object)"1234567", (Object)row.getString(3).toString());
        Assert.assertEquals((Object)"12345678", (Object)row.getString(5).toString());
        Assert.assertEquals((Object)"\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320", (Object)row.getString(9).toString());
        Assert.assertEquals((long)BinaryString.fromString((String)"\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320").hashCode(), (long)row.getString(9).hashCode());
        Assert.assertTrue((boolean)row.isNullAt(12));
    }

    @Test
    public void testReuseWriter() {
        BinaryRow row = new BinaryRow(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, BinaryString.fromString((String)"01234567"));
        writer.writeString(1, BinaryString.fromString((String)"012345678"));
        writer.complete();
        Assert.assertEquals((Object)"01234567", (Object)row.getString(0).toString());
        Assert.assertEquals((Object)"012345678", (Object)row.getString(1).toString());
        writer.reset();
        writer.writeString(0, BinaryString.fromString((String)"1"));
        writer.writeString(1, BinaryString.fromString((String)"0123456789"));
        writer.complete();
        Assert.assertEquals((Object)"1", (Object)row.getString(0).toString());
        Assert.assertEquals((Object)"0123456789", (Object)row.getString(1).toString());
    }

    @Test
    public void anyNullTest() {
        BinaryRow row = new BinaryRow(3);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        Assert.assertFalse((boolean)row.anyNull());
        row.setHeader((byte)1);
        Assert.assertFalse((boolean)row.anyNull());
        writer.setNullAt(2);
        Assert.assertTrue((boolean)row.anyNull());
        writer.setNullAt(0);
        Assert.assertTrue((boolean)row.anyNull(new int[]{0, 1, 2}));
        Assert.assertFalse((boolean)row.anyNull(new int[]{1}));
        writer.setNullAt(1);
        Assert.assertTrue((boolean)row.anyNull());
        int numFields = 80;
        for (int i = 0; i < numFields; ++i) {
            BinaryRow row2 = new BinaryRow(numFields);
            BinaryRowWriter writer2 = new BinaryRowWriter(row2);
            row2.setHeader((byte)17);
            Assert.assertFalse((boolean)row2.anyNull());
            writer2.setNullAt(i);
            Assert.assertTrue((boolean)row2.anyNull());
        }
    }

    @Test
    public void testSingleSegmentBinaryRowHashCode() {
        int i;
        Random rnd = new Random(System.currentTimeMillis());
        BinaryRow row = new BinaryRow(13);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        for (int i2 = 0; i2 < 99; ++i2) {
            writer.reset();
            writer.writeString(0, BinaryString.fromString((String)("" + rnd.nextInt())));
            writer.writeString(3, BinaryString.fromString((String)"01234567"));
            writer.writeString(5, BinaryString.fromString((String)"012345678"));
            writer.writeString(9, BinaryString.fromString((String)"\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320"));
            writer.writeBoolean(1, true);
            writer.writeByte(2, (byte)99);
            writer.writeDouble(6, 87.1);
            writer.writeFloat(7, 26.1f);
            writer.writeInt(8, 88);
            writer.writeLong(10, 284L);
            writer.writeShort(11, (short)292);
            writer.setNullAt(12);
            writer.complete();
            BinaryRow copy = row.copy();
            Assert.assertEquals((long)row.hashCode(), (long)copy.hashCode());
        }
        int count = 999999;
        HashSet<Integer> hashCodes = new HashSet<Integer>(count);
        for (i = 0; i < count; ++i) {
            row.setInt(8, i);
            hashCodes.add(row.hashCode());
        }
        Assert.assertEquals((long)count, (long)hashCodes.size());
        hashCodes.clear();
        row = new BinaryRow(1);
        writer = new BinaryRowWriter(row);
        for (i = 0; i < count; ++i) {
            writer.reset();
            writer.writeString(0, BinaryString.fromString((String)("\u5566\u5566\u5566\u5566\u5566\u6211\u662f\u5feb\u4e50\u7684\u7c89\u5237\u5320" + i)));
            writer.complete();
            hashCodes.add(row.hashCode());
        }
        Assert.assertTrue(((double)hashCodes.size() > (double)count * 0.997 ? 1 : 0) != 0);
    }

    @Test
    public void testHeaderSize() {
        Assert.assertEquals((long)8L, (long)BinaryRow.calculateBitSetWidthInBytes((int)56));
        Assert.assertEquals((long)16L, (long)BinaryRow.calculateBitSetWidthInBytes((int)57));
        Assert.assertEquals((long)16L, (long)BinaryRow.calculateBitSetWidthInBytes((int)120));
        Assert.assertEquals((long)24L, (long)BinaryRow.calculateBitSetWidthInBytes((int)121));
    }

    @Test
    public void testHeader() {
        BinaryRow row = new BinaryRow(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeInt(0, 10);
        writer.setNullAt(1);
        writer.writeHeader((byte)29);
        writer.complete();
        BinaryRow newRow = row.copy();
        Assert.assertEquals((Object)row, (Object)newRow);
        Assert.assertEquals((long)29L, (long)newRow.getHeader());
        newRow.setHeader((byte)19);
        Assert.assertEquals((long)19L, (long)newRow.getHeader());
    }

    @Test
    public void testDecimal() {
        int precision = 4;
        int scale = 2;
        BinaryRow row = new BinaryRow(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeDecimal(0, Decimal.fromLong((long)5L, (int)precision, (int)scale), precision);
        writer.setNullAt(1);
        writer.complete();
        Assert.assertEquals((Object)"0.05", (Object)row.getDecimal(0, precision, scale).toString());
        Assert.assertTrue((boolean)row.isNullAt(1));
        row.setDecimal(0, Decimal.fromLong((long)6L, (int)precision, (int)scale), precision);
        Assert.assertEquals((Object)"0.06", (Object)row.getDecimal(0, precision, scale).toString());
        precision = 25;
        scale = 5;
        Decimal decimal1 = Decimal.fromBigDecimal((BigDecimal)BigDecimal.valueOf(5.55), (int)precision, (int)scale);
        Decimal decimal2 = Decimal.fromBigDecimal((BigDecimal)BigDecimal.valueOf(6.55), (int)precision, (int)scale);
        BinaryRow row2 = new BinaryRow(2);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        writer2.writeDecimal(0, decimal1, precision);
        writer2.writeDecimal(1, null, precision);
        writer2.complete();
        Assert.assertEquals((Object)"5.55000", (Object)row2.getDecimal(0, precision, scale).toString());
        Assert.assertTrue((boolean)row2.isNullAt(1));
        row2.setDecimal(0, decimal2, precision);
        Assert.assertEquals((Object)"6.55000", (Object)row2.getDecimal(0, precision, scale).toString());
    }

    @Test
    public void testGeneric() {
        BinaryRow row = new BinaryRow(3);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        BinaryGenericSerializer binarySerializer = new BinaryGenericSerializer((TypeSerializer)StringSerializer.INSTANCE);
        BinaryGeneric hahah = new BinaryGeneric((Object)"hahah");
        writer.writeGeneric(0, hahah, binarySerializer);
        writer.setNullAt(1);
        writer.writeGeneric(2, hahah, binarySerializer);
        writer.complete();
        BinaryGeneric generic0 = row.getGeneric(0);
        Assert.assertThat((Object)generic0, (Matcher)BinaryGenericAsserter.equivalent(hahah, binarySerializer));
        Assert.assertTrue((boolean)row.isNullAt(1));
        BinaryGeneric generic2 = row.getGeneric(2);
        Assert.assertThat((Object)generic2, (Matcher)BinaryGenericAsserter.equivalent(hahah, binarySerializer));
    }

    @Test
    public void testNested() {
        BinaryRow row = new BinaryRow(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeRow(0, (BaseRow)GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)"1"), 1}), new BaseRowSerializer(null, RowType.of((LogicalType[])new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new IntType()})));
        writer.setNullAt(1);
        writer.complete();
        BaseRow nestedRow = row.getRow(0, 2);
        Assert.assertEquals((Object)"1", (Object)nestedRow.getString(0).toString());
        Assert.assertEquals((long)1L, (long)nestedRow.getInt(1));
        Assert.assertTrue((boolean)row.isNullAt(1));
    }

    @Test
    public void testBinary() {
        BinaryRow row = new BinaryRow(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        byte[] bytes1 = new byte[]{1, -1, 5};
        byte[] bytes2 = new byte[]{1, -1, 5, 5, 1, 5, 1, 5};
        writer.writeBinary(0, bytes1);
        writer.writeBinary(1, bytes2);
        writer.complete();
        Assert.assertArrayEquals((byte[])bytes1, (byte[])row.getBinary(0));
        Assert.assertArrayEquals((byte[])bytes2, (byte[])row.getBinary(1));
    }

    @Test
    public void testBinaryArray() {
        BinaryArray array = new BinaryArray();
        BinaryArrayWriter arrayWriter = new BinaryArrayWriter(array, 3, BinaryArray.calculateFixLengthPartSize((LogicalType)DataTypes.INT().getLogicalType()));
        arrayWriter.writeInt(0, 6);
        arrayWriter.setNullInt(1);
        arrayWriter.writeInt(2, 666);
        arrayWriter.complete();
        Assert.assertEquals((long)array.getInt(0), (long)6L);
        Assert.assertTrue((boolean)array.isNullAt(1));
        Assert.assertEquals((long)array.getInt(2), (long)666L);
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter rowWriter = new BinaryRowWriter(row);
        BaseArraySerializer serializer = new BaseArraySerializer(DataTypes.INT().getLogicalType(), new ExecutionConfig());
        rowWriter.writeArray(0, (BaseArray)array, serializer);
        rowWriter.complete();
        BinaryArray array2 = (BinaryArray)row.getArray(0);
        Assert.assertEquals((Object)array, (Object)array2);
        Assert.assertEquals((long)6L, (long)array2.getInt(0));
        Assert.assertTrue((boolean)array2.isNullAt(1));
        Assert.assertEquals((long)666L, (long)array2.getInt(2));
    }

    @Test
    public void testGenericArray() {
        Integer[] javaArray = new Integer[]{6, null, 666};
        GenericArray array = new GenericArray((Object)javaArray, 3, false);
        Assert.assertEquals((long)array.getInt(0), (long)6L);
        Assert.assertTrue((boolean)array.isNullAt(1));
        Assert.assertEquals((long)array.getInt(2), (long)666L);
        BinaryRow row2 = new BinaryRow(1);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        BaseArraySerializer serializer = new BaseArraySerializer(DataTypes.INT().getLogicalType(), new ExecutionConfig());
        writer2.writeArray(0, (BaseArray)array, serializer);
        writer2.complete();
        BaseArray array2 = row2.getArray(0);
        Assert.assertEquals((long)6L, (long)array2.getInt(0));
        Assert.assertTrue((boolean)array2.isNullAt(1));
        Assert.assertEquals((long)666L, (long)array2.getInt(2));
    }

    @Test
    public void testBinaryMap() {
        BinaryArray array1 = new BinaryArray();
        BinaryArrayWriter writer1 = new BinaryArrayWriter(array1, 4, BinaryArray.calculateFixLengthPartSize((LogicalType)DataTypes.INT().getLogicalType()));
        writer1.writeInt(0, 6);
        writer1.writeInt(1, 5);
        writer1.writeInt(2, 666);
        writer1.writeInt(3, 0);
        writer1.complete();
        BinaryArray array2 = new BinaryArray();
        BinaryArrayWriter writer2 = new BinaryArrayWriter(array2, 4, BinaryArray.calculateFixLengthPartSize((LogicalType)DataTypes.STRING().getLogicalType()));
        writer2.writeString(0, BinaryString.fromString((String)"6"));
        writer2.writeString(1, BinaryString.fromString((String)"5"));
        writer2.writeString(2, BinaryString.fromString((String)"666"));
        writer2.setNullAt(3, DataTypes.STRING().getLogicalType());
        writer2.complete();
        BinaryMap binaryMap = BinaryMap.valueOf((BinaryArray)array1, (BinaryArray)array2);
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter rowWriter = new BinaryRowWriter(row);
        BaseMapSerializer serializer = new BaseMapSerializer(DataTypes.STRING().getLogicalType(), DataTypes.INT().getLogicalType(), new ExecutionConfig());
        rowWriter.writeMap(0, (BaseMap)binaryMap, serializer);
        rowWriter.complete();
        BinaryMap map = (BinaryMap)row.getMap(0);
        BinaryArray key = map.keyArray();
        BinaryArray value = map.valueArray();
        Assert.assertEquals((Object)binaryMap, (Object)map);
        Assert.assertEquals((Object)array1, (Object)key);
        Assert.assertEquals((Object)array2, (Object)value);
        Assert.assertEquals((long)5L, (long)key.getInt(1));
        Assert.assertEquals((Object)BinaryString.fromString((String)"5"), (Object)value.getString(1));
        Assert.assertEquals((long)0L, (long)key.getInt(3));
        Assert.assertTrue((boolean)value.isNullAt(3));
    }

    @Test
    public void testGenericMap() {
        HashMap<Integer, BinaryString> javaMap = new HashMap<Integer, BinaryString>();
        javaMap.put(6, BinaryString.fromString((String)"6"));
        javaMap.put(5, BinaryString.fromString((String)"5"));
        javaMap.put(666, BinaryString.fromString((String)"666"));
        javaMap.put(0, null);
        GenericMap genericMap = new GenericMap(javaMap);
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter rowWriter = new BinaryRowWriter(row);
        BaseMapSerializer serializer = new BaseMapSerializer(DataTypes.INT().getLogicalType(), DataTypes.STRING().getLogicalType(), new ExecutionConfig());
        rowWriter.writeMap(0, (BaseMap)genericMap, serializer);
        rowWriter.complete();
        Map map = row.getMap(0).toJavaMap(DataTypes.INT().getLogicalType(), DataTypes.STRING().getLogicalType());
        Assert.assertEquals((Object)BinaryString.fromString((String)"6"), map.get(6));
        Assert.assertEquals((Object)BinaryString.fromString((String)"5"), map.get(5));
        Assert.assertEquals((Object)BinaryString.fromString((String)"666"), map.get(666));
        Assert.assertTrue((boolean)map.containsKey(0));
        Assert.assertNull(map.get(0));
    }

    @Test
    public void testGenericObject() throws Exception {
        GenericTypeInfo info = new GenericTypeInfo(DataFormatTestUtil.MyObj.class);
        TypeSerializer genericSerializer = info.createSerializer(new ExecutionConfig());
        BinaryGenericSerializer binarySerializer = new BinaryGenericSerializer(genericSerializer);
        BinaryRow row = new BinaryRow(4);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeInt(0, 0);
        BinaryGeneric myObj1 = new BinaryGeneric((Object)new DataFormatTestUtil.MyObj(0, 1.0));
        writer.writeGeneric(1, myObj1, binarySerializer);
        BinaryGeneric myObj2 = new BinaryGeneric((Object)new DataFormatTestUtil.MyObj(123, 5.0));
        writer.writeGeneric(2, myObj2, binarySerializer);
        BinaryGeneric myObj3 = new BinaryGeneric((Object)new DataFormatTestUtil.MyObj(1, 1.0));
        writer.writeGeneric(3, myObj3, binarySerializer);
        writer.complete();
        this.assertTestGenericObjectRow(row, (TypeSerializer<DataFormatTestUtil.MyObj>)genericSerializer);
        BinaryRowSerializer serializer = new BinaryRowSerializer(4);
        MemorySegment[] memorySegments = new MemorySegment[3];
        ArrayList<MemorySegment> memorySegmentList = new ArrayList<MemorySegment>();
        for (int i = 0; i < 3; ++i) {
            memorySegments[i] = MemorySegmentFactory.wrap((byte[])new byte[64]);
            memorySegmentList.add(memorySegments[i]);
        }
        RandomAccessOutputView out = new RandomAccessOutputView(memorySegments, 64);
        serializer.serializeToPages(row, (AbstractPagedOutputView)out);
        BinaryRow mapRow = serializer.mapFromPages((AbstractPagedInputView)new RandomAccessInputView(memorySegmentList, 64));
        this.assertTestGenericObjectRow(mapRow, (TypeSerializer<DataFormatTestUtil.MyObj>)genericSerializer);
    }

    private void assertTestGenericObjectRow(BinaryRow row, TypeSerializer<DataFormatTestUtil.MyObj> serializer) {
        Assert.assertEquals((long)0L, (long)row.getInt(0));
        BinaryGeneric binaryGeneric1 = row.getGeneric(1);
        BinaryGeneric binaryGeneric2 = row.getGeneric(2);
        BinaryGeneric binaryGeneric3 = row.getGeneric(3);
        Assert.assertEquals((Object)new DataFormatTestUtil.MyObj(0, 1.0), (Object)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)binaryGeneric1, serializer));
        Assert.assertEquals((Object)new DataFormatTestUtil.MyObj(123, 5.0), (Object)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)binaryGeneric2, serializer));
        Assert.assertEquals((Object)new DataFormatTestUtil.MyObj(1, 1.0), (Object)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)binaryGeneric3, serializer));
    }

    @Test
    public void testDateAndTimeAsGenericObject() {
        BinaryRow row = new BinaryRow(7);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        LocalDate localDate = LocalDate.of(2019, 7, 16);
        LocalTime localTime = LocalTime.of(17, 31);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        writer.writeInt(0, 0);
        writer.writeGeneric(1, new BinaryGeneric((Object)new Date(123L)), new BinaryGenericSerializer((TypeSerializer)SqlDateSerializer.INSTANCE));
        writer.writeGeneric(2, new BinaryGeneric((Object)new Time(456L)), new BinaryGenericSerializer((TypeSerializer)SqlTimeSerializer.INSTANCE));
        writer.writeGeneric(3, new BinaryGeneric((Object)new Timestamp(789L)), new BinaryGenericSerializer((TypeSerializer)SqlTimestampSerializer.INSTANCE));
        writer.writeGeneric(4, new BinaryGeneric((Object)localDate), new BinaryGenericSerializer((TypeSerializer)LocalDateSerializer.INSTANCE));
        writer.writeGeneric(5, new BinaryGeneric((Object)localTime), new BinaryGenericSerializer((TypeSerializer)LocalTimeSerializer.INSTANCE));
        writer.writeGeneric(6, new BinaryGeneric((Object)localDateTime), new BinaryGenericSerializer((TypeSerializer)LocalDateTimeSerializer.INSTANCE));
        writer.complete();
        Assert.assertEquals((Object)new Date(123L), (Object)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)row.getGeneric(1), (TypeSerializer)SqlDateSerializer.INSTANCE));
        Assert.assertEquals((Object)new Time(456L), (Object)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)row.getGeneric(2), (TypeSerializer)SqlTimeSerializer.INSTANCE));
        Assert.assertEquals((Object)new Timestamp(789L), (Object)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)row.getGeneric(3), (TypeSerializer)SqlTimestampSerializer.INSTANCE));
        Assert.assertEquals((Object)localDate, (Object)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)row.getGeneric(4), (TypeSerializer)LocalDateSerializer.INSTANCE));
        Assert.assertEquals((Object)localTime, (Object)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)row.getGeneric(5), (TypeSerializer)LocalTimeSerializer.INSTANCE));
        Assert.assertEquals((Object)localDateTime, (Object)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)row.getGeneric(6), (TypeSerializer)LocalDateTimeSerializer.INSTANCE));
    }

    @Test
    public void testSerializeVariousSize() throws IOException {
        int segSize = 64;
        int segTotalNumber = 3;
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        Random random = new Random();
        byte[] bytes = new byte[1024];
        random.nextBytes(bytes);
        writer.writeBinary(0, bytes);
        writer.complete();
        MemorySegment[] memorySegments = new MemorySegment[segTotalNumber];
        HashMap<MemorySegment, Integer> msIndex = new HashMap<MemorySegment, Integer>();
        for (int i = 0; i < segTotalNumber; ++i) {
            memorySegments[i] = MemorySegmentFactory.wrap((byte[])new byte[segSize]);
            msIndex.put(memorySegments[i], i);
        }
        BinaryRowSerializer serializer = new BinaryRowSerializer(1);
        int rowSizeInt = 4;
        int rowFixLength = 16;
        for (int i = 0; i < segSize; ++i) {
            int maxRowSize = segSize * segTotalNumber - i - rowSizeInt;
            if (segSize - i < rowFixLength + rowSizeInt) {
                maxRowSize -= segSize - i;
            }
            for (int j = rowFixLength; j < maxRowSize; ++j) {
                this.testSerialize(row, memorySegments, msIndex, serializer, i, j);
            }
        }
    }

    private void testSerialize(BinaryRow row, MemorySegment[] memorySegments, Map<MemorySegment, Integer> msIndex, BinaryRowSerializer serializer, int position, int rowSize) throws IOException {
        RandomAccessOutputView out = new RandomAccessOutputView(memorySegments, 64);
        out.skipBytesToWrite(position);
        row.setTotalSize(rowSize);
        serializer.serializeToPages(row, (AbstractPagedOutputView)out);
        int segNumber = msIndex.get(out.getCurrentSegment()) + 1;
        int lastSegSize = out.getCurrentPositionInSegment();
        ArrayList<MemorySegment> segments = new ArrayList<MemorySegment>(Arrays.asList(memorySegments).subList(0, segNumber));
        RandomAccessInputView input = new RandomAccessInputView(segments, 64, lastSegSize);
        input.skipBytesToRead(position);
        BinaryRow mapRow = serializer.mapFromPages((AbstractPagedInputView)input);
        Assert.assertEquals((Object)row, (Object)mapRow);
    }

    @Test
    public void testZeroOutPaddingGeneric() {
        GenericTypeInfo info = new GenericTypeInfo(DataFormatTestUtil.MyObj.class);
        TypeSerializer genericSerializer = info.createSerializer(new ExecutionConfig());
        Random random = new Random();
        byte[] bytes = new byte[1024];
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.reset();
        random.nextBytes(bytes);
        writer.writeBinary(0, bytes);
        writer.reset();
        writer.writeGeneric(0, new BinaryGeneric((Object)new DataFormatTestUtil.MyObj(0, 1.0)), new BinaryGenericSerializer(genericSerializer));
        writer.complete();
        int hash1 = row.hashCode();
        writer.reset();
        random.nextBytes(bytes);
        writer.writeBinary(0, bytes);
        writer.reset();
        writer.writeGeneric(0, new BinaryGeneric((Object)new DataFormatTestUtil.MyObj(0, 1.0)), new BinaryGenericSerializer(genericSerializer));
        writer.complete();
        int hash2 = row.hashCode();
        Assert.assertEquals((long)hash1, (long)hash2);
    }

    @Test
    public void testZeroOutPaddingString() {
        Random random = new Random();
        byte[] bytes = new byte[1024];
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.reset();
        random.nextBytes(bytes);
        writer.writeBinary(0, bytes);
        writer.reset();
        writer.writeString(0, BinaryString.fromString((String)"wahahah"));
        writer.complete();
        int hash1 = row.hashCode();
        writer.reset();
        random.nextBytes(bytes);
        writer.writeBinary(0, bytes);
        writer.reset();
        writer.writeString(0, BinaryString.fromString((String)"wahahah"));
        writer.complete();
        int hash2 = row.hashCode();
        Assert.assertEquals((long)hash1, (long)hash2);
    }

    @Test
    public void testHashAndCopy() throws IOException {
        MemorySegment[] segments = new MemorySegment[3];
        for (int i = 0; i < 3; ++i) {
            segments[i] = MemorySegmentFactory.wrap((byte[])new byte[64]);
        }
        RandomAccessOutputView out = new RandomAccessOutputView(segments, 64);
        BinaryRowSerializer serializer = new BinaryRowSerializer(2);
        BinaryRow row = new BinaryRow(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, BinaryString.fromString((String)"hahahahahahahahahahahahahahahahahahahhahahahahahahahahah"));
        writer.writeString(1, BinaryString.fromString((String)"hahahahahahahahahahahahahahahahahahahhahahahahahahahahaa"));
        writer.complete();
        serializer.serializeToPages(row, (AbstractPagedOutputView)out);
        ArrayList<MemorySegment> segmentList = new ArrayList<MemorySegment>(Arrays.asList(segments));
        RandomAccessInputView input = new RandomAccessInputView(segmentList, 64, 64);
        BinaryRow mapRow = serializer.mapFromPages((AbstractPagedInputView)input);
        Assert.assertEquals((Object)row, (Object)mapRow);
        Assert.assertEquals((Object)row.getString(0), (Object)mapRow.getString(0));
        Assert.assertEquals((Object)row.getString(1), (Object)mapRow.getString(1));
        Assert.assertNotEquals((Object)row.getString(0), (Object)mapRow.getString(1));
        Assert.assertEquals((long)row.hashCode(), (long)mapRow.hashCode());
        Assert.assertEquals((long)row.getString(0).hashCode(), (long)mapRow.getString(0).hashCode());
        Assert.assertEquals((long)row.getString(1).hashCode(), (long)mapRow.getString(1).hashCode());
        Assert.assertEquals((Object)row.copy(), (Object)mapRow.copy());
        Assert.assertEquals((Object)row.getString(0).copy(), (Object)mapRow.getString(0).copy());
        Assert.assertEquals((Object)row.getString(1).copy(), (Object)mapRow.getString(1).copy());
    }

    @Test
    public void testSerStringToKryo() throws IOException {
        KryoSerializer serializer = new KryoSerializer(BinaryString.class, new ExecutionConfig());
        BinaryString string = BinaryString.fromString((String)"hahahahaha");
        RandomAccessOutputView out = new RandomAccessOutputView(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[1024])}, 64);
        serializer.serialize((Object)string, (DataOutputView)out);
        RandomAccessInputView input = new RandomAccessInputView(new ArrayList<MemorySegment>(Collections.singletonList(out.getCurrentSegment())), 64, 64);
        BinaryString newStr = (BinaryString)serializer.deserialize((DataInputView)input);
        Assert.assertEquals((Object)string, (Object)newStr);
    }

    @Test
    public void testSerializerPages() throws IOException {
        BinaryRow row24 = DataFormatTestUtil.get24BytesBinaryRow();
        BinaryRow row160 = DataFormatTestUtil.get160BytesBinaryRow();
        this.testSerializerPagesInternal(row24, row160);
        this.testSerializerPagesInternal(row24, DataFormatTestUtil.getMultiSeg160BytesBinaryRow(row160));
    }

    private void testSerializerPagesInternal(BinaryRow row24, BinaryRow row160) throws IOException {
        BinaryRowSerializer serializer = new BinaryRowSerializer(2);
        MemorySegment[] segments = new MemorySegment[4];
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = MemorySegmentFactory.wrap((byte[])new byte[64]);
        }
        RandomAccessOutputView out = new RandomAccessOutputView(segments, segments[0].size());
        serializer.serializeToPages(row24, (AbstractPagedOutputView)out);
        serializer.serializeToPages(row160, (AbstractPagedOutputView)out);
        serializer.serializeToPages(row24, (AbstractPagedOutputView)out);
        RandomAccessInputView in = new RandomAccessInputView(new ArrayList<MemorySegment>(Arrays.asList(segments)), segments[0].size(), out.getCurrentPositionInSegment());
        BinaryRow retRow = new BinaryRow(2);
        ArrayList<BinaryRow> rets = new ArrayList<BinaryRow>();
        while (true) {
            try {
                retRow = serializer.mapFromPages(retRow, (AbstractPagedInputView)in);
            }
            catch (EOFException e) {
                break;
            }
            rets.add(retRow.copy());
        }
        Assert.assertEquals((Object)row24, rets.get(0));
        Assert.assertEquals((Object)row160, rets.get(1));
        Assert.assertEquals((Object)row24, rets.get(2));
        segments = new MemorySegment[7];
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = MemorySegmentFactory.wrap((byte[])new byte[64]);
        }
        out = new RandomAccessOutputView(segments, segments[0].size());
        serializer.serializeToPages(row24, (AbstractPagedOutputView)out);
        serializer.serializeToPages(row160, (AbstractPagedOutputView)out);
        serializer.serializeToPages(row160, (AbstractPagedOutputView)out);
        in = new RandomAccessInputView(new ArrayList<MemorySegment>(Arrays.asList(segments)), segments[0].size(), out.getCurrentPositionInSegment());
        retRow = new BinaryRow(2);
        rets = new ArrayList();
        while (true) {
            try {
                retRow = serializer.mapFromPages(retRow, (AbstractPagedInputView)in);
            }
            catch (EOFException e) {
                break;
            }
            rets.add(retRow.copy());
        }
        Assert.assertEquals((Object)row24, rets.get(0));
        Assert.assertEquals((Object)row160, rets.get(1));
        Assert.assertEquals((Object)row160, rets.get(2));
        segments = new MemorySegment[3];
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = MemorySegmentFactory.wrap((byte[])new byte[64]);
        }
        out = new RandomAccessOutputView(segments, segments[0].size());
        serializer.serializeToPages(row24, (AbstractPagedOutputView)out);
        serializer.serializeToPages(row160, (AbstractPagedOutputView)out);
        in = new RandomAccessInputView(new ArrayList<MemorySegment>(Arrays.asList(segments)), segments[0].size(), out.getCurrentPositionInSegment());
        retRow = new BinaryRow(2);
        rets = new ArrayList();
        while (true) {
            try {
                retRow = serializer.mapFromPages(retRow, (AbstractPagedInputView)in);
            }
            catch (EOFException e) {
                break;
            }
            rets.add(retRow.copy());
        }
        Assert.assertEquals((Object)row24, rets.get(0));
        Assert.assertEquals((Object)row160, rets.get(1));
    }

    @Test
    public void testSqlTimestamp() {
        int precision = 3;
        BinaryRow row = new BinaryRow(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeTimestamp(0, SqlTimestamp.fromEpochMillis((long)123L), 3);
        writer.setNullAt(1);
        writer.complete();
        Assert.assertEquals((Object)"1970-01-01T00:00:00.123", (Object)row.getTimestamp(0, 3).toString());
        Assert.assertTrue((boolean)row.isNullAt(1));
        row.setTimestamp(0, SqlTimestamp.fromEpochMillis((long)-123L), 3);
        Assert.assertEquals((Object)"1969-12-31T23:59:59.877", (Object)row.getTimestamp(0, 3).toString());
        precision = 9;
        SqlTimestamp sqlTimestamp1 = SqlTimestamp.fromLocalDateTime((LocalDateTime)LocalDateTime.of(1969, 1, 1, 0, 0, 0, 123456789));
        SqlTimestamp sqlTimestamp2 = SqlTimestamp.fromTimestamp((Timestamp)Timestamp.valueOf("1970-01-01 00:00:00.123456789"));
        BinaryRow row2 = new BinaryRow(2);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        writer2.writeTimestamp(0, sqlTimestamp1, 9);
        writer2.writeTimestamp(1, null, 9);
        writer2.complete();
        Assert.assertEquals((long)40L, (long)row2.getSizeInBytes());
        Assert.assertEquals((Object)"1969-01-01T00:00:00.123456789", (Object)row2.getTimestamp(0, 9).toString());
        Assert.assertTrue((boolean)row2.isNullAt(1));
        row2.setTimestamp(0, sqlTimestamp2, 9);
        Assert.assertEquals((Object)"1970-01-01T00:00:00.123456789", (Object)row2.getTimestamp(0, 9).toString());
    }
}

