/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.runtime.typeutils.BaseRowSerializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class BaseRowTypeInfo
extends TupleTypeInfoBase<BaseRow> {
    private static final long serialVersionUID = 1L;
    private static final String REGEX_INT_FIELD = "[0-9]+";
    private static final String REGEX_STR_FIELD = "[\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*";
    private static final String REGEX_FIELD = "[\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*|[0-9]+";
    private static final String REGEX_NESTED_FIELDS = "([\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*|[0-9]+)(\\.(.+))?";
    private static final Pattern PATTERN_NESTED_FIELDS = Pattern.compile("([\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*|[0-9]+)(\\.(.+))?");
    private static final Pattern PATTERN_INT_FIELD = Pattern.compile("[0-9]+");
    private final String[] fieldNames;
    private final LogicalType[] logicalTypes;

    public BaseRowTypeInfo(LogicalType ... logicalTypes) {
        this(logicalTypes, BaseRowTypeInfo.generateDefaultFieldNames(logicalTypes.length));
    }

    public BaseRowTypeInfo(LogicalType[] logicalTypes, String[] fieldNames) {
        super(BaseRow.class, (TypeInformation[])Arrays.stream(logicalTypes).map(TypeInfoLogicalTypeConverter::fromLogicalTypeToTypeInfo).toArray(TypeInformation[]::new));
        this.logicalTypes = logicalTypes;
        Preconditions.checkNotNull((Object)fieldNames, (String)"FieldNames should not be null.");
        Preconditions.checkArgument((logicalTypes.length == fieldNames.length ? 1 : 0) != 0, (Object)"Number of field types and names is different.");
        Preconditions.checkArgument((!this.hasDuplicateFieldNames(fieldNames) ? 1 : 0) != 0, (Object)"Field names are not unique.");
        this.fieldNames = Arrays.copyOf(fieldNames, fieldNames.length);
    }

    public static String[] generateDefaultFieldNames(int length) {
        String[] fieldNames = new String[length];
        for (int i = 0; i < length; ++i) {
            fieldNames[i] = "f" + i;
        }
        return fieldNames;
    }

    public <X> TypeInformation<X> getTypeAt(String fieldExpression) {
        Matcher matcher = PATTERN_NESTED_FIELDS.matcher(fieldExpression);
        if (!matcher.matches()) {
            if (fieldExpression.equals("*") || fieldExpression.equals("_")) {
                throw new CompositeType.InvalidFieldReferenceException("Wildcard expressions are not allowed here.");
            }
            throw new CompositeType.InvalidFieldReferenceException("Invalid format of Row field expression \"" + fieldExpression + "\".");
        }
        String field = matcher.group(1);
        Matcher intFieldMatcher = PATTERN_INT_FIELD.matcher(field);
        int fieldIndex = intFieldMatcher.matches() ? Integer.valueOf(field).intValue() : this.getFieldIndex(field);
        TypeInformation fieldType = this.getTypeAt(fieldIndex);
        String tail = matcher.group(3);
        if (tail == null) {
            return fieldType;
        }
        if (fieldType instanceof CompositeType) {
            return ((CompositeType)fieldType).getTypeAt(tail);
        }
        throw new CompositeType.InvalidFieldReferenceException("Nested field expression \"" + tail + "\" not possible on atomic type " + fieldType + ".");
    }

    public TypeComparator<BaseRow> createComparator(int[] logicalKeyFields, boolean[] orders, int logicalFieldOffset, ExecutionConfig config) {
        throw new UnsupportedOperationException("Not support yet!");
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public int getFieldIndex(String fieldName) {
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!this.fieldNames[i].equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof BaseRowTypeInfo;
    }

    public int hashCode() {
        return 31 * super.hashCode() + Arrays.hashCode(this.fieldNames);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder("BaseRow");
        if (this.logicalTypes.length > 0) {
            bld.append('(').append(this.fieldNames[0]).append(": ").append(this.logicalTypes[0]);
            for (int i = 1; i < this.logicalTypes.length; ++i) {
                bld.append(", ").append(this.fieldNames[i]).append(": ").append(this.logicalTypes[i]);
            }
            bld.append(')');
        }
        return bld.toString();
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.types;
    }

    private boolean hasDuplicateFieldNames(String[] fieldNames) {
        HashSet<String> names = new HashSet<String>();
        for (String field : fieldNames) {
            if (names.add(field)) continue;
            return true;
        }
        return false;
    }

    public CompositeType.TypeComparatorBuilder<BaseRow> createTypeComparatorBuilder() {
        throw new UnsupportedOperationException("Not support!");
    }

    public BaseRowSerializer createSerializer(ExecutionConfig config) {
        return new BaseRowSerializer(config, this.logicalTypes);
    }

    public LogicalType[] getLogicalTypes() {
        return this.logicalTypes;
    }

    public RowType toRowType() {
        return RowType.of((LogicalType[])this.logicalTypes, (String[])this.fieldNames);
    }

    public static BaseRowTypeInfo of(RowType rowType) {
        return new BaseRowTypeInfo(rowType.getChildren().toArray(new LogicalType[0]), rowType.getFieldNames().toArray(new String[0]));
    }
}

