/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.types;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.BooleanSerializer;
import org.apache.flink.api.common.typeutils.base.ByteSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.FloatSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.ShortSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.table.runtime.typeutils.BaseArraySerializer;
import org.apache.flink.table.runtime.typeutils.BaseMapSerializer;
import org.apache.flink.table.runtime.typeutils.BaseRowSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryGenericSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryStringSerializer;
import org.apache.flink.table.runtime.typeutils.DecimalSerializer;
import org.apache.flink.table.runtime.typeutils.SqlTimestampSerializer;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TypeInformationRawType;

public class InternalSerializers {
    public static TypeSerializer create(LogicalType type, ExecutionConfig config) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return BooleanSerializer.INSTANCE;
            }
            case TINYINT: {
                return ByteSerializer.INSTANCE;
            }
            case SMALLINT: {
                return ShortSerializer.INSTANCE;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                return IntSerializer.INSTANCE;
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return LongSerializer.INSTANCE;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)type;
                return new SqlTimestampSerializer(timestampType.getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType lzTs = (LocalZonedTimestampType)type;
                return new SqlTimestampSerializer(lzTs.getPrecision());
            }
            case FLOAT: {
                return FloatSerializer.INSTANCE;
            }
            case DOUBLE: {
                return DoubleSerializer.INSTANCE;
            }
            case CHAR: 
            case VARCHAR: {
                return BinaryStringSerializer.INSTANCE;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                return new DecimalSerializer(decimalType.getPrecision(), decimalType.getScale());
            }
            case ARRAY: {
                return new BaseArraySerializer(((ArrayType)type).getElementType(), config);
            }
            case MAP: {
                MapType mapType = (MapType)type;
                return new BaseMapSerializer(mapType.getKeyType(), mapType.getValueType(), config);
            }
            case MULTISET: {
                return new BaseMapSerializer(((MultisetType)type).getElementType(), (LogicalType)new IntType(), config);
            }
            case ROW: {
                RowType rowType = (RowType)type;
                return new BaseRowSerializer(config, rowType);
            }
            case BINARY: 
            case VARBINARY: {
                return BytePrimitiveArraySerializer.INSTANCE;
            }
            case RAW: {
                return new BinaryGenericSerializer(((TypeInformationRawType)type).getTypeInformation().createSerializer(config));
            }
        }
        throw new RuntimeException("Not support type: " + type);
    }
}

