/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.collector.TableFunctionCollector;
import org.apache.flink.table.runtime.generated.GeneratedCollector;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.operators.join.lookup.LookupJoinRunner;
import org.apache.flink.util.Collector;

public class LookupJoinWithCalcRunner
extends LookupJoinRunner {
    private static final long serialVersionUID = 5277183384939603386L;
    private final GeneratedFunction<FlatMapFunction<BaseRow, BaseRow>> generatedCalc;
    private transient FlatMapFunction<BaseRow, BaseRow> calc;
    private transient Collector<BaseRow> calcCollector;

    public LookupJoinWithCalcRunner(GeneratedFunction<FlatMapFunction<BaseRow, BaseRow>> generatedFetcher, GeneratedFunction<FlatMapFunction<BaseRow, BaseRow>> generatedCalc, GeneratedCollector<TableFunctionCollector<BaseRow>> generatedCollector, boolean isLeftOuterJoin, int tableFieldsCount) {
        super(generatedFetcher, generatedCollector, isLeftOuterJoin, tableFieldsCount);
        this.generatedCalc = generatedCalc;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.calc = (FlatMapFunction)this.generatedCalc.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        FunctionUtils.setFunctionRuntimeContext(this.calc, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.calc, (Configuration)parameters);
        this.calcCollector = new CalcCollector(this.collector);
    }

    @Override
    public void close() throws Exception {
        super.close();
        FunctionUtils.closeFunction(this.calc);
    }

    @Override
    public Collector<BaseRow> getFetcherCollector() {
        return this.calcCollector;
    }

    private class CalcCollector
    implements Collector<BaseRow> {
        private final Collector<BaseRow> delegate;

        private CalcCollector(Collector<BaseRow> delegate) {
            this.delegate = delegate;
        }

        public void collect(BaseRow record) {
            try {
                LookupJoinWithCalcRunner.this.calc.flatMap((Object)record, this.delegate);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            this.delegate.close();
        }
    }
}

