/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.Arrays;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.runtime.typeutils.BinaryGenericSerializer;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class BinaryGenericAsserter
extends TypeSafeMatcher<BinaryGeneric> {
    private final BinaryGeneric expected;
    private final BinaryGenericSerializer serializer;

    private BinaryGenericAsserter(BinaryGeneric expected, BinaryGenericSerializer serializer) {
        this.expected = expected;
        this.serializer = serializer;
    }

    public static BinaryGenericAsserter equivalent(BinaryGeneric expected, BinaryGenericSerializer serializer) {
        expected.ensureMaterialized(serializer.getInnerSerializer());
        return new BinaryGenericAsserter(expected, serializer);
    }

    protected boolean matchesSafely(BinaryGeneric item) {
        item.ensureMaterialized(this.serializer.getInnerSerializer());
        this.expected.ensureMaterialized(this.serializer.getInnerSerializer());
        return item.getSizeInBytes() == this.expected.getSizeInBytes() && SegmentsUtil.equals((MemorySegment[])item.getSegments(), (int)item.getOffset(), (MemorySegment[])this.expected.getSegments(), (int)this.expected.getOffset(), (int)item.getSizeInBytes());
    }

    public void describeTo(Description description) {
        byte[] bytes = SegmentsUtil.getBytes((MemorySegment[])this.expected.getSegments(), (int)this.expected.getOffset(), (int)this.expected.getSizeInBytes());
        description.appendText(Arrays.toString(bytes));
    }
}

