/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.runtime.typeutils.AbstractRowSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryRowSerializer;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ResettableExternalBufferTest {
    private static final int MEMORY_SIZE = 0x2000000;
    private MemoryManager memManager;
    private IOManager ioManager;
    private Random random;
    private BinaryRowSerializer serializer;
    private BinaryRowSerializer multiColumnFixedLengthSerializer;
    private BinaryRowSerializer multiColumnVariableLengthSerializer;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void before() {
        this.memManager = new MemoryManager(0x2000000L, 1);
        this.ioManager = new IOManagerAsync();
        this.random = new Random();
        this.serializer = new BinaryRowSerializer(1);
        this.multiColumnFixedLengthSerializer = new BinaryRowSerializer(3);
        this.multiColumnVariableLengthSerializer = new BinaryRowSerializer(5);
    }

    private ResettableExternalBuffer newBuffer(long memorySize) throws MemoryAllocationException {
        return this.newBuffer(memorySize, this.serializer, true);
    }

    private ResettableExternalBuffer newBuffer(long memorySize, BinaryRowSerializer serializer, boolean isRowAllInFixedPart) throws MemoryAllocationException {
        return new ResettableExternalBuffer(this.memManager, this.ioManager, this.memManager.allocatePages((Object)this, (int)(memorySize / (long)this.memManager.getPageSize())), (AbstractRowSerializer)serializer, isRowAllInFixedPart);
    }

    @Test
    public void testLess() throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 100;
        List<Long> expected = this.insertMulti(buffer, number);
        Assert.assertEquals((long)buffer.size(), (long)number);
        this.assertBuffer(expected, buffer);
        Assert.assertEquals((long)buffer.getSpillChannels().size(), (long)0L);
        this.assertBuffer(expected, buffer);
        buffer.newIterator();
        this.assertBuffer(expected, buffer);
        buffer.close();
    }

    @Test
    public void testSpill() throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 5000;
        List<Long> expected = this.insertMulti(buffer, number);
        Assert.assertEquals((long)buffer.size(), (long)number);
        this.assertBuffer(expected, buffer);
        Assert.assertTrue((buffer.getSpillChannels().size() > 0 ? 1 : 0) != 0);
        this.assertBuffer(expected, buffer);
        buffer.newIterator();
        this.assertBuffer(expected, buffer);
        buffer.close();
    }

    @Test
    public void testBufferReset() throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        this.insertMulti(buffer, 10);
        buffer.reset();
        Assert.assertEquals((long)buffer.size(), (long)0L);
        List<Long> expected = this.insertMulti(buffer, 100);
        Assert.assertEquals((long)buffer.size(), (long)100L);
        this.assertBuffer(expected, buffer);
        buffer.reset();
        expected = this.insertMulti(buffer, 2500);
        Assert.assertEquals((long)buffer.size(), (long)2500L);
        this.assertBuffer(expected, buffer);
        buffer.close();
    }

    @Test
    public void testBufferResetWithSpill() throws Exception {
        int inMemoryThreshold = 20;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        List<Long> expected = this.insertMulti(buffer, 2500);
        Assert.assertEquals((long)buffer.size(), (long)2500L);
        this.assertBuffer(expected, buffer);
        buffer.reset();
        this.insertMulti(buffer, 2500);
        buffer.newIterator();
        Assert.assertEquals((long)buffer.size(), (long)2500L);
        buffer.reset();
        expected = this.insertMulti(buffer, inMemoryThreshold / 2);
        this.assertBuffer(expected, buffer);
        buffer.reset();
        Assert.assertEquals((long)buffer.size(), (long)0L);
        expected = this.insertMulti(buffer, 100);
        Assert.assertEquals((long)buffer.size(), (long)100L);
        this.assertBuffer(expected, buffer);
        buffer.reset();
        buffer.close();
    }

    @Test
    public void testHugeRecord() throws Exception {
        this.thrown.expect(IOException.class);
        try (ResettableExternalBuffer buffer = new ResettableExternalBuffer(this.memManager, this.ioManager, this.memManager.allocatePages((Object)this, 98304 / this.memManager.getPageSize()), (AbstractRowSerializer)new BinaryRowSerializer(1), false);){
            this.writeHuge(buffer, 10);
            this.writeHuge(buffer, 50000);
        }
    }

    @Test
    public void testRandomAccessLess() throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 100;
        List<Long> expected = this.insertMulti(buffer, number);
        Assert.assertEquals((long)buffer.size(), (long)number);
        this.assertBuffer(expected, buffer);
        Assert.assertEquals((long)buffer.getSpillChannels().size(), (long)0L);
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            this.assertRandomAccess(expected, buffer, (int)((Integer)beginPos.get(i)));
        }
        buffer.close();
    }

    @Test
    public void testRandomAccessSpill() throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 5000;
        List<Long> expected = this.insertMulti(buffer, number);
        Assert.assertEquals((long)buffer.size(), (long)number);
        this.assertBuffer(expected, buffer);
        Assert.assertTrue((buffer.getSpillChannels().size() > 0 ? 1 : 0) != 0);
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            this.assertRandomAccess(expected, buffer, (int)((Integer)beginPos.get(i)));
        }
        buffer.close();
    }

    @Test
    public void testBufferResetWithSpillAndRandomAccess() throws Exception {
        List<Long> expected;
        int i;
        int tries = 100;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        for (i = 0; i < 2; ++i) {
            expected = this.insertMulti(buffer, 2500);
            Assert.assertEquals((long)buffer.size(), (long)2500L);
            for (int j = 0; j < 100; ++j) {
                this.assertRandomAccess(expected, buffer);
            }
            buffer.reset();
        }
        this.insertMulti(buffer, 2500);
        buffer.newIterator();
        Assert.assertEquals((long)buffer.size(), (long)2500L);
        buffer.reset();
        expected = this.insertMulti(buffer, 10);
        for (i = 0; i < 100; ++i) {
            this.assertRandomAccess(expected, buffer);
        }
        buffer.reset();
        Assert.assertEquals((long)buffer.size(), (long)0L);
        expected = this.insertMulti(buffer, 100);
        Assert.assertEquals((long)buffer.size(), (long)100L);
        for (i = 0; i < 100; ++i) {
            this.assertRandomAccess(expected, buffer);
        }
        buffer.reset();
        buffer.close();
    }

    @Test
    public void testMultiColumnFixedLengthRandomAccessLess() throws Exception {
        this.testMultiColumnRandomAccessLess(this.multiColumnFixedLengthSerializer, FixedLengthRowData.class, true);
    }

    @Test
    public void testMultiColumnFixedLengthRandomAccessSpill() throws Exception {
        this.testMultiColumnRandomAccessSpill(this.multiColumnFixedLengthSerializer, FixedLengthRowData.class, true);
    }

    @Test
    public void testBufferResetWithSpillAndMultiColumnFixedLengthRandomAccess() throws Exception {
        this.testBufferResetWithSpillAndMultiColumnRandomAccess(this.multiColumnFixedLengthSerializer, FixedLengthRowData.class, true);
    }

    @Test
    public void testMultiColumnVariableLengthRandomAccessLess() throws Exception {
        this.testMultiColumnRandomAccessLess(this.multiColumnVariableLengthSerializer, VariableLengthRowData.class, false);
    }

    @Test
    public void testMultiColumnVariableLengthRandomAccessSpill() throws Exception {
        this.testMultiColumnRandomAccessSpill(this.multiColumnVariableLengthSerializer, VariableLengthRowData.class, false);
    }

    @Test
    public void testBufferResetWithSpillAndMultiColumnVariableLengthRandomAccess() throws Exception {
        this.testBufferResetWithSpillAndMultiColumnRandomAccess(this.multiColumnVariableLengthSerializer, VariableLengthRowData.class, false);
    }

    @Test
    public void testIteratorOnFixedLengthEmptyBuffer() throws Exception {
        this.testIteratorOnMultiColumnEmptyBuffer(this.multiColumnFixedLengthSerializer, true);
    }

    @Test
    public void testFixedLengthRandomAccessOutOfRange() throws Exception {
        this.testRandomAccessOutOfRange(this.multiColumnFixedLengthSerializer, FixedLengthRowData.class, true);
    }

    @Test
    public void testIteratorOnVariableLengthEmptyBuffer() throws Exception {
        this.testIteratorOnMultiColumnEmptyBuffer(this.multiColumnVariableLengthSerializer, false);
    }

    @Test
    public void testVariableLengthRandomAccessOutOfRange() throws Exception {
        this.testRandomAccessOutOfRange(this.multiColumnVariableLengthSerializer, VariableLengthRowData.class, false);
    }

    @Test
    public void testIteratorReset() throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 100;
        List<Long> expected = this.insertMulti(buffer, number);
        Assert.assertEquals((long)buffer.size(), (long)number);
        this.assertBuffer(expected, buffer);
        Assert.assertEquals((long)buffer.getSpillChannels().size(), (long)0L);
        ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator();
        this.assertBuffer(expected, iterator);
        iterator.reset();
        this.assertBuffer(expected, iterator);
        iterator.close();
        buffer.close();
    }

    @Test
    public void testIteratorResetWithSpill() throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 5000;
        List<Long> expected = this.insertMulti(buffer, number);
        Assert.assertEquals((long)buffer.size(), (long)number);
        this.assertBuffer(expected, buffer);
        Assert.assertTrue((buffer.getSpillChannels().size() > 0 ? 1 : 0) != 0);
        ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator();
        this.assertBuffer(expected, iterator);
        iterator.reset();
        this.assertBuffer(expected, iterator);
        iterator.close();
        buffer.close();
    }

    @Test
    public void testIteratorResetWithRandomAccess() throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 100;
        List<Long> expected = this.insertMulti(buffer, number);
        Assert.assertEquals((long)buffer.size(), (long)number);
        this.assertBuffer(expected, buffer);
        Assert.assertEquals((long)buffer.getSpillChannels().size(), (long)0L);
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            int begin = (Integer)beginPos.get(i);
            ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(begin);
            this.assertRandomAccess(expected, iterator, begin);
            iterator.reset();
            this.assertRandomAccess(expected, iterator, begin);
            iterator.close();
        }
        buffer.close();
    }

    @Test
    public void testIteratorResetWithRandomAccessSpill() throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 5000;
        List<Long> expected = this.insertMulti(buffer, number);
        Assert.assertEquals((long)buffer.size(), (long)number);
        this.assertBuffer(expected, buffer);
        Assert.assertTrue((buffer.getSpillChannels().size() > 0 ? 1 : 0) != 0);
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            int begin = (Integer)beginPos.get(i);
            ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(begin);
            this.assertRandomAccess(expected, iterator, begin);
            iterator.reset();
            this.assertRandomAccess(expected, iterator, begin);
            iterator.close();
        }
        buffer.close();
    }

    @Test
    public void testMultipleIteratorsLess() throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 100;
        List<Long> expected = this.insertMulti(buffer, number);
        Assert.assertEquals((long)buffer.size(), (long)number);
        this.assertBuffer(expected, buffer);
        Assert.assertEquals((long)buffer.getSpillChannels().size(), (long)0L);
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            int beginIdx = (Integer)beginPos.get(i);
            ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(beginIdx);
            this.assertRandomAccess(expected, iterator, beginIdx);
            if (i % 3 != 0) continue;
            iterator.close();
        }
        buffer.close();
    }

    @Test
    public void testMultipleIteratorsSpill() throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 5000;
        List<Long> expected = this.insertMulti(buffer, number);
        Assert.assertEquals((long)buffer.size(), (long)number);
        this.assertBuffer(expected, buffer);
        Assert.assertTrue((buffer.getSpillChannels().size() > 0 ? 1 : 0) != 0);
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            int beginIdx = (Integer)beginPos.get(i);
            ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(beginIdx);
            this.assertRandomAccess(expected, iterator, beginIdx);
            if (i % 3 != 0) continue;
            iterator.close();
        }
        buffer.close();
    }

    @Test
    public void testMultipleIteratorsWithIteratorReset() throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 5000;
        List<Long> expected = this.insertMulti(buffer, number);
        Assert.assertEquals((long)buffer.size(), (long)number);
        this.assertBuffer(expected, buffer);
        Assert.assertTrue((buffer.getSpillChannels().size() > 0 ? 1 : 0) != 0);
        ResettableExternalBuffer.BufferIterator iterator1 = buffer.newIterator();
        this.assertBuffer(expected, iterator1);
        iterator1.reset();
        this.assertBuffer(expected, iterator1);
        ResettableExternalBuffer.BufferIterator iterator2 = buffer.newIterator();
        this.assertBuffer(expected, iterator2);
        iterator2.reset();
        this.assertBuffer(expected, iterator2);
        iterator1.reset();
        this.assertBuffer(expected, iterator1);
        iterator2.reset();
        this.assertBuffer(expected, iterator2);
        iterator1.close();
        iterator2.reset();
        this.assertBuffer(expected, iterator2);
        iterator2.close();
        buffer.close();
    }

    @Test(expected=IllegalStateException.class)
    public void testUpdateIteratorFixedLengthLess() throws Exception {
        this.testUpdateIteratorLess(this.multiColumnFixedLengthSerializer, FixedLengthRowData.class, true);
    }

    @Test(expected=IllegalStateException.class)
    public void testUpdateIteratorFixedLengthSpill() throws Exception {
        this.testUpdateIteratorSpill(this.multiColumnFixedLengthSerializer, FixedLengthRowData.class, true);
    }

    @Test(expected=IllegalStateException.class)
    public void testUpdateIteratorVariableLengthLess() throws Exception {
        this.testUpdateIteratorLess(this.multiColumnVariableLengthSerializer, VariableLengthRowData.class, false);
    }

    @Test(expected=IllegalStateException.class)
    public void testUpdateIteratorVariableLengthSpill() throws Exception {
        this.testUpdateIteratorSpill(this.multiColumnVariableLengthSerializer, VariableLengthRowData.class, false);
    }

    private <T extends RowData> void testMultiColumnRandomAccessLess(BinaryRowSerializer serializer, Class<T> clazz, boolean isRowAllInFixedPart) throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L, serializer, isRowAllInFixedPart);
        int number = 30;
        List<RowData> expected = this.insertMultiColumn(buffer, number, clazz);
        Assert.assertEquals((long)buffer.size(), (long)number);
        Assert.assertEquals((long)buffer.getSpillChannels().size(), (long)0L);
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            this.assertMultiColumnRandomAccess(expected, buffer, (Integer)beginPos.get(i));
        }
        buffer.close();
    }

    private <T extends RowData> void testMultiColumnRandomAccessSpill(BinaryRowSerializer serializer, Class<T> clazz, boolean isRowAllInFixedPart) throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L, serializer, isRowAllInFixedPart);
        int number = 4000;
        List<RowData> expected = this.insertMultiColumn(buffer, number, clazz);
        Assert.assertEquals((long)buffer.size(), (long)number);
        Assert.assertTrue((buffer.getSpillChannels().size() > 0 ? 1 : 0) != 0);
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            this.assertMultiColumnRandomAccess(expected, buffer, (Integer)beginPos.get(i));
        }
        buffer.close();
    }

    private <T extends RowData> void testBufferResetWithSpillAndMultiColumnRandomAccess(BinaryRowSerializer serializer, Class<T> clazz, boolean isRowAllInFixedPart) throws Exception {
        List<RowData> expected;
        int i;
        int tries = 100;
        ResettableExternalBuffer buffer = this.newBuffer(65536L, serializer, isRowAllInFixedPart);
        for (i = 0; i < 2; ++i) {
            expected = this.insertMultiColumn(buffer, 1500, clazz);
            Assert.assertEquals((long)buffer.size(), (long)1500L);
            for (int j = 0; j < 100; ++j) {
                this.assertMultiColumnRandomAccess(expected, buffer);
            }
            buffer.reset();
        }
        this.insertMultiColumn(buffer, 1500, clazz);
        buffer.newIterator();
        Assert.assertEquals((long)buffer.size(), (long)1500L);
        buffer.reset();
        expected = this.insertMultiColumn(buffer, 10, clazz);
        for (i = 0; i < 100; ++i) {
            this.assertMultiColumnRandomAccess(expected, buffer);
        }
        buffer.reset();
        Assert.assertEquals((long)buffer.size(), (long)0L);
        expected = this.insertMultiColumn(buffer, 30, clazz);
        Assert.assertEquals((long)buffer.size(), (long)30L);
        for (i = 0; i < 100; ++i) {
            this.assertMultiColumnRandomAccess(expected, buffer);
        }
        buffer.reset();
        buffer.close();
    }

    private void testIteratorOnMultiColumnEmptyBuffer(BinaryRowSerializer serializer, boolean isRowAllInFixedPart) throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L, serializer, isRowAllInFixedPart);
        buffer.complete();
        ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(0);
        Assert.assertFalse((boolean)iterator.advanceNext());
        iterator = buffer.newIterator(this.random.nextInt(Integer.MAX_VALUE));
        Assert.assertFalse((boolean)iterator.advanceNext());
        buffer.close();
    }

    private <T extends RowData> void testRandomAccessOutOfRange(BinaryRowSerializer serializer, Class<T> clazz, boolean isRowAllInFixedPart) throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L, serializer, isRowAllInFixedPart);
        int number = 100;
        List<RowData> expected = this.insertMultiColumn(buffer, number, clazz);
        Assert.assertEquals((long)buffer.size(), (long)number);
        this.assertMultiColumnRandomAccess(expected, buffer, 0);
        ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(number);
        Assert.assertFalse((boolean)iterator.advanceNext());
        iterator = buffer.newIterator(number + this.random.nextInt(Integer.MAX_VALUE));
        Assert.assertFalse((boolean)iterator.advanceNext());
        iterator = buffer.newIterator(this.random.nextInt(number));
        Assert.assertTrue((boolean)iterator.advanceNext());
        buffer.close();
    }

    private <T extends RowData> void testUpdateIteratorLess(BinaryRowSerializer serializer, Class<T> clazz, boolean isRowAllInFixedPart) throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L, serializer, isRowAllInFixedPart);
        int number = 20;
        int iters = 3;
        ArrayList<RowData> expected = new ArrayList<RowData>();
        ArrayList<ResettableExternalBuffer.BufferIterator> iterators = new ArrayList<ResettableExternalBuffer.BufferIterator>();
        for (i = 0; i < iters; ++i) {
            iterators.add(buffer.newIterator());
        }
        for (i = 0; i < number; ++i) {
            RowData rowData = (RowData)clazz.newInstance();
            rowData.insertIntoBuffer(buffer);
            expected.add(rowData);
            for (ResettableExternalBuffer.BufferIterator iterator : iterators) {
                Assert.assertTrue((boolean)iterator.advanceNext());
                BinaryRow row = iterator.getRow();
                rowData.checkSame(row);
                Assert.assertFalse((boolean)iterator.advanceNext());
            }
        }
        for (ResettableExternalBuffer.BufferIterator bufferIterator : iterators) {
            bufferIterator.reset();
        }
        for (int i2 = 0; i2 < number; ++i2) {
            for (ResettableExternalBuffer.BufferIterator iterator : iterators) {
                Assert.assertTrue((boolean)iterator.advanceNext());
                BinaryRow row = iterator.getRow();
                ((RowData)expected.get(i2)).checkSame(row);
            }
        }
        for (ResettableExternalBuffer.BufferIterator bufferIterator : iterators) {
            bufferIterator.close();
        }
        this.assertMultiColumnRandomAccess(expected, buffer);
        buffer.close();
    }

    /*
     * WARNING - void declaration
     */
    private <T extends RowData> void testUpdateIteratorSpill(BinaryRowSerializer serializer, Class<T> clazz, boolean isRowAllInFixedPart) throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L, serializer, isRowAllInFixedPart);
        int number = 100;
        int step = 20;
        int iters = 3;
        ArrayList<RowData> expected = new ArrayList<RowData>();
        ArrayList<Object> smallExpected = new ArrayList<Object>();
        ArrayList<ResettableExternalBuffer.BufferIterator> iterators = new ArrayList<ResettableExternalBuffer.BufferIterator>();
        for (i = 0; i < iters; ++i) {
            iterators.add(buffer.newIterator());
        }
        for (i = 0; i < number; ++i) {
            void var12_19;
            void var12_17;
            smallExpected.clear();
            boolean bl = false;
            while (var12_17 < step) {
                RowData data = (RowData)clazz.newInstance();
                data.insertIntoBuffer(buffer);
                expected.add(data);
                smallExpected.add(data);
                ++var12_17;
            }
            boolean bl2 = false;
            while (var12_19 < step) {
                for (ResettableExternalBuffer.BufferIterator iterator : iterators) {
                    Assert.assertTrue((boolean)iterator.advanceNext());
                    BinaryRow row = iterator.getRow();
                    ((RowData)smallExpected.get((int)var12_19)).checkSame(row);
                }
                ++var12_19;
            }
            for (ResettableExternalBuffer.BufferIterator iterator : iterators) {
                Assert.assertFalse((boolean)iterator.advanceNext());
            }
        }
        for (ResettableExternalBuffer.BufferIterator bufferIterator : iterators) {
            bufferIterator.reset();
        }
        for (int i2 = 0; i2 < number * step; ++i2) {
            for (ResettableExternalBuffer.BufferIterator iterator : iterators) {
                Assert.assertTrue((boolean)iterator.advanceNext());
                BinaryRow row = iterator.getRow();
                ((RowData)expected.get(i2)).checkSame(row);
            }
        }
        for (ResettableExternalBuffer.BufferIterator bufferIterator : iterators) {
            bufferIterator.close();
        }
        this.assertMultiColumnRandomAccess(expected, buffer);
        buffer.close();
    }

    private void writeHuge(ResettableExternalBuffer buffer, int size) throws IOException {
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.reset();
        writer.writeString(0, BinaryString.fromString((String)RandomStringUtils.random((int)size)));
        writer.complete();
        buffer.add((BaseRow)row);
    }

    private void assertBuffer(List<Long> expected, ResettableExternalBuffer buffer) {
        ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator();
        this.assertBuffer(expected, iterator);
        iterator.close();
    }

    private void assertBuffer(List<Long> expected, ResettableExternalBuffer.BufferIterator iterator) {
        ArrayList<Long> values = new ArrayList<Long>();
        while (iterator.advanceNext()) {
            values.add(iterator.getRow().getLong(0));
        }
        Assert.assertEquals(expected, values);
    }

    private List<Long> insertMulti(ResettableExternalBuffer buffer, int cnt) throws IOException {
        ArrayList<Long> expected = new ArrayList<Long>(cnt);
        this.insertMulti(buffer, cnt, expected);
        buffer.complete();
        return expected;
    }

    private void insertMulti(ResettableExternalBuffer buffer, int cnt, List<Long> expected) throws IOException {
        for (int i = 0; i < cnt; ++i) {
            expected.add(this.randomInsert(buffer));
        }
    }

    private long randomInsert(ResettableExternalBuffer buffer) throws IOException {
        long l = this.random.nextLong();
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.reset();
        writer.writeLong(0, l);
        writer.complete();
        buffer.add((BaseRow)row);
        return l;
    }

    private void assertRandomAccess(List<Long> expected, ResettableExternalBuffer buffer) {
        int begin = this.random.nextInt(buffer.size());
        this.assertRandomAccess(expected, buffer, begin);
    }

    private void assertRandomAccess(List<Long> expected, ResettableExternalBuffer buffer, int begin) {
        ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(begin);
        this.assertRandomAccess(expected, iterator, begin);
        iterator.close();
    }

    private void assertRandomAccess(List<Long> expected, ResettableExternalBuffer.BufferIterator iterator, int begin) {
        ArrayList<Long> values = new ArrayList<Long>();
        while (iterator.advanceNext()) {
            values.add(iterator.getRow().getLong(0));
        }
        Assert.assertEquals(expected.subList(begin, expected.size()), values);
    }

    private <T extends RowData> List<RowData> insertMultiColumn(ResettableExternalBuffer buffer, int cnt, Class<T> clazz) throws IOException, IllegalAccessException, InstantiationException {
        ArrayList<RowData> expected = new ArrayList<RowData>(cnt);
        this.insertMultiColumn(buffer, cnt, expected, clazz);
        buffer.complete();
        return expected;
    }

    private <T extends RowData> void insertMultiColumn(ResettableExternalBuffer buffer, int cnt, List<RowData> expected, Class<T> clazz) throws IOException, IllegalAccessException, InstantiationException {
        for (int i = 0; i < cnt; ++i) {
            RowData data = (RowData)clazz.newInstance();
            data.insertIntoBuffer(buffer);
            expected.add(data);
        }
        buffer.complete();
    }

    private void assertMultiColumnRandomAccess(List<RowData> expected, ResettableExternalBuffer buffer) {
        int begin = this.random.nextInt(buffer.size());
        this.assertMultiColumnRandomAccess(expected, buffer, begin);
    }

    private void assertMultiColumnRandomAccess(List<RowData> expected, ResettableExternalBuffer buffer, int begin) {
        ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(begin);
        for (int i = begin; i < buffer.size(); ++i) {
            Assert.assertTrue((boolean)iterator.advanceNext());
            expected.get(i).checkSame(iterator.getRow());
        }
    }

    private static class VariableLengthRowData
    implements RowData {
        private boolean col0;
        private long col1;
        private BinaryString col2;
        private int col3;
        private BinaryString col4;
        private Random random = new Random();

        public VariableLengthRowData() {
            this.col0 = this.random.nextBoolean();
            this.col1 = this.random.nextLong();
            this.col2 = BinaryString.fromString((String)RandomStringUtils.random((int)(this.random.nextInt(50) + 1)));
            this.col3 = this.random.nextInt();
            this.col4 = BinaryString.fromString((String)RandomStringUtils.random((int)(this.random.nextInt(50) + 1)));
        }

        @Override
        public void insertIntoBuffer(ResettableExternalBuffer buffer) throws IOException {
            BinaryRow row = new BinaryRow(5);
            BinaryRowWriter writer = new BinaryRowWriter(row);
            writer.reset();
            writer.writeBoolean(0, this.col0);
            writer.writeLong(1, this.col1);
            writer.writeString(2, this.col2);
            writer.writeInt(3, this.col3);
            writer.writeString(4, this.col4);
            writer.complete();
            buffer.add((BaseRow)row);
        }

        @Override
        public void checkSame(BinaryRow row) {
            Assert.assertEquals((Object)this.col0, (Object)row.getBoolean(0));
            Assert.assertEquals((long)this.col1, (long)row.getLong(1));
            Assert.assertEquals((Object)this.col2, (Object)row.getString(2));
            Assert.assertEquals((long)this.col3, (long)row.getInt(3));
            Assert.assertEquals((Object)this.col4, (Object)row.getString(4));
        }
    }

    private static class FixedLengthRowData
    implements RowData {
        private boolean col0;
        private long col1;
        private int col2;
        private Random random = new Random();

        FixedLengthRowData() {
            this.col0 = this.random.nextBoolean();
            this.col1 = this.random.nextLong();
            this.col2 = this.random.nextInt();
        }

        @Override
        public void insertIntoBuffer(ResettableExternalBuffer buffer) throws IOException {
            BinaryRow row = new BinaryRow(3);
            BinaryRowWriter writer = new BinaryRowWriter(row);
            writer.reset();
            writer.writeBoolean(0, this.col0);
            writer.writeLong(1, this.col1);
            writer.writeInt(2, this.col2);
            writer.complete();
            buffer.add((BaseRow)row);
        }

        @Override
        public void checkSame(BinaryRow row) {
            Assert.assertEquals((Object)this.col0, (Object)row.getBoolean(0));
            Assert.assertEquals((long)this.col1, (long)row.getLong(1));
            Assert.assertEquals((long)this.col2, (long)row.getInt(2));
        }
    }

    private static interface RowData {
        public void insertIntoBuffer(ResettableExternalBuffer var1) throws IOException;

        public void checkSame(BinaryRow var1);
    }
}

