/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.types.logical.LogicalType;

public class GenericRowRecordSortComparator
implements Comparator<GenericRow>,
Serializable {
    private static final long serialVersionUID = -4988371592272863772L;
    private final int sortKeyIdx;
    private final LogicalType sortKeyType;

    public GenericRowRecordSortComparator(int sortKeyIdx, LogicalType sortKeyType) {
        this.sortKeyIdx = sortKeyIdx;
        this.sortKeyType = sortKeyType;
    }

    @Override
    public int compare(GenericRow row1, GenericRow row2) {
        byte header2;
        byte header1 = row1.getHeader();
        if (header1 != (header2 = row2.getHeader())) {
            return header1 - header2;
        }
        Object key1 = TypeGetterSetters.get((TypeGetterSetters)row1, (int)this.sortKeyIdx, (LogicalType)this.sortKeyType);
        Object key2 = TypeGetterSetters.get((TypeGetterSetters)row2, (int)this.sortKeyIdx, (LogicalType)this.sortKeyType);
        if (key1 instanceof Comparable) {
            return ((Comparable)key1).compareTo(key2);
        }
        throw new UnsupportedOperationException();
    }
}

