/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.dataformat.BinaryWriter;
import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.runtime.keyselector.BaseRowKeySelector;
import org.apache.flink.table.runtime.types.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;

public class BinaryRowKeySelector
implements BaseRowKeySelector {
    private static final long serialVersionUID = -2327761762415377059L;
    private final int[] keyFields;
    private final LogicalType[] inputFieldTypes;
    private final LogicalType[] keyFieldTypes;
    private final TypeSerializer[] keySers;

    public BinaryRowKeySelector(int[] keyFields, LogicalType[] inputFieldTypes) {
        this.keyFields = keyFields;
        this.inputFieldTypes = inputFieldTypes;
        this.keyFieldTypes = new LogicalType[keyFields.length];
        this.keySers = new TypeSerializer[keyFields.length];
        ExecutionConfig conf = new ExecutionConfig();
        for (int i = 0; i < keyFields.length; ++i) {
            this.keyFieldTypes[i] = inputFieldTypes[keyFields[i]];
            this.keySers[i] = InternalSerializers.create((LogicalType)this.keyFieldTypes[i], (ExecutionConfig)conf);
        }
    }

    public BaseRow getKey(BaseRow value) throws Exception {
        BinaryRow ret = new BinaryRow(this.keyFields.length);
        BinaryRowWriter writer = new BinaryRowWriter(ret);
        for (int i = 0; i < this.keyFields.length; ++i) {
            if (value.isNullAt(i)) {
                writer.setNullAt(i);
                continue;
            }
            BinaryWriter.write((BinaryWriter)writer, (int)i, (Object)TypeGetterSetters.get((TypeGetterSetters)value, (int)this.keyFields[i], (LogicalType)this.inputFieldTypes[this.keyFields[i]]), (LogicalType)this.inputFieldTypes[this.keyFields[i]], (TypeSerializer)this.keySers[i]);
        }
        writer.complete();
        return ret;
    }

    public BaseRowTypeInfo getProducedType() {
        return new BaseRowTypeInfo(this.keyFieldTypes);
    }
}

