/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;

public class BaseRowHarnessAssertor {
    private final TypeInformation[] typeInfos;
    private final Comparator<GenericRow> comparator;

    public BaseRowHarnessAssertor(TypeInformation[] typeInfos, Comparator<GenericRow> comparator) {
        this.typeInfos = typeInfos;
        this.comparator = comparator;
    }

    public BaseRowHarnessAssertor(TypeInformation[] typeInfos) {
        this(typeInfos, new StringComparator());
    }

    public void assertOutputEquals(String message, Collection<Object> expected, Collection<Object> actual) {
        this.assertOutputEquals(message, expected, actual, false);
    }

    public void assertOutputEqualsSorted(String message, Collection<Object> expected, Collection<Object> actual) {
        this.assertOutputEquals(message, expected, actual, true);
    }

    private void assertOutputEquals(String message, Collection<Object> expected, Collection<Object> actual, boolean needSort) {
        if (needSort) {
            Preconditions.checkArgument((this.comparator != null ? 1 : 0) != 0, (Object)"Comparator should not be null!");
        }
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Iterator<Object> exIt = expected.iterator();
        Iterator<Object> actIt = actual.iterator();
        while (exIt.hasNext()) {
            Object nextEx = exIt.next();
            Object nextAct = actIt.next();
            if (!(nextEx instanceof Watermark)) continue;
            Assert.assertEquals((Object)nextEx, (Object)nextAct);
        }
        ArrayList<GenericRow> expectedRecords = new ArrayList<GenericRow>();
        ArrayList<GenericRow> actualRecords = new ArrayList<GenericRow>();
        for (Object ex : expected) {
            if (!(ex instanceof StreamRecord)) continue;
            BaseRow row = (BaseRow)((StreamRecord)ex).getValue();
            if (row instanceof GenericRow) {
                expectedRecords.add((GenericRow)row);
                continue;
            }
            GenericRow genericRow = BaseRowUtil.toGenericRow((BaseRow)row, (LogicalType[])((LogicalType[])Arrays.stream(this.typeInfos).map(TypeInfoLogicalTypeConverter::fromTypeInfoToLogicalType).toArray(LogicalType[]::new)));
            expectedRecords.add(genericRow);
        }
        for (Object act : actual) {
            if (!(act instanceof StreamRecord)) continue;
            BaseRow actualOutput = (BaseRow)((StreamRecord)act).getValue();
            GenericRow actualRow = BaseRowUtil.toGenericRow((BaseRow)actualOutput, (LogicalType[])((LogicalType[])Arrays.stream(this.typeInfos).map(TypeInfoLogicalTypeConverter::fromTypeInfoToLogicalType).toArray(LogicalType[]::new)));
            actualRecords.add(actualRow);
        }
        Object[] sortedExpected = expectedRecords.toArray(new GenericRow[expectedRecords.size()]);
        Object[] sortedActual = actualRecords.toArray(new GenericRow[actualRecords.size()]);
        if (needSort) {
            Arrays.sort(sortedExpected, this.comparator);
            Arrays.sort(sortedActual, this.comparator);
        }
        Assert.assertArrayEquals((String)message, (Object[])sortedExpected, (Object[])sortedActual);
    }

    private static class StringComparator
    implements Comparator<GenericRow> {
        private StringComparator() {
        }

        @Override
        public int compare(GenericRow o1, GenericRow o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

