/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.assigners;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.WindowTestUtils;
import org.apache.flink.table.runtime.operators.window.assigners.MergingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.SessionWindowAssigner;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SessionWindowAssignerTest {
    private static final BaseRow ELEMENT = GenericRow.of((Object[])new Object[]{"String"});

    @Test
    public void testWindowAssignment() {
        int sessionGap = 5000;
        SessionWindowAssigner assigner = SessionWindowAssigner.withGap((Duration)Duration.ofMillis(5000L));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 0L), (Matcher)org.hamcrest.Matchers.contains(WindowTestUtils.timeWindow(0L, 5000L)));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 4999L), (Matcher)org.hamcrest.Matchers.contains(WindowTestUtils.timeWindow(4999L, 9999L)));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 5000L), (Matcher)org.hamcrest.Matchers.contains(WindowTestUtils.timeWindow(5000L, 10000L)));
    }

    @Test
    public void testMergeEmptyWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        SessionWindowAssigner assigner = SessionWindowAssigner.withGap((Duration)Duration.ofMillis(5000L));
        assigner.mergeWindows(TimeWindow.of((long)0L, (long)1L), new TreeSet(), callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).merge(Matchers.anyObject(), Matchers.anyCollection());
    }

    @Test
    public void testMergeSingleWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        SessionWindowAssigner assigner = SessionWindowAssigner.withGap((Duration)Duration.ofMillis(5000L));
        TreeSet<TimeWindow> sortedWindows = new TreeSet<TimeWindow>();
        sortedWindows.add(TimeWindow.of((long)6000L, (long)6001L));
        assigner.mergeWindows(TimeWindow.of((long)0L, (long)1L), sortedWindows, callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).merge(Matchers.anyObject(), Matchers.anyCollection());
    }

    @Test
    public void testMergeConsecutiveWindows() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        SessionWindowAssigner assigner = SessionWindowAssigner.withGap((Duration)Duration.ofMillis(5000L));
        TreeSet<TimeWindow> sortedWindows = new TreeSet<TimeWindow>();
        sortedWindows.addAll(Arrays.asList(new TimeWindow(0L, 1L), new TimeWindow(2L, 3L), new TimeWindow(4L, 5L), new TimeWindow(7L, 8L)));
        assigner.mergeWindows(new TimeWindow(1L, 2L), sortedWindows, callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge(Matchers.eq((Object)new TimeWindow(0L, 3L)), (Collection)Matchers.argThat(timeWindows -> org.hamcrest.Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 1L), new TimeWindow(1L, 2L), new TimeWindow(2L, 3L)}).matches(timeWindows)));
    }

    @Test
    public void testMergeCoveringWindow() {
        MergingWindowAssigner.MergeCallback callback = (MergingWindowAssigner.MergeCallback)Mockito.mock(MergingWindowAssigner.MergeCallback.class);
        SessionWindowAssigner assigner = SessionWindowAssigner.withGap((Duration)Duration.ofMillis(5000L));
        TreeSet<TimeWindow> sortedWindows = new TreeSet<TimeWindow>();
        sortedWindows.addAll(Arrays.asList(new TimeWindow(1L, 4L), new TimeWindow(5L, 7L), new TimeWindow(9L, 10L)));
        assigner.mergeWindows(new TimeWindow(3L, 6L), sortedWindows, callback);
        ((MergingWindowAssigner.MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge(Matchers.eq((Object)new TimeWindow(1L, 7L)), (Collection)Matchers.argThat(timeWindows -> org.hamcrest.Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(1L, 4L), new TimeWindow(5L, 7L), new TimeWindow(3L, 6L)}).matches(timeWindows)));
    }

    @Test
    public void testProperties() {
        SessionWindowAssigner assigner = SessionWindowAssigner.withGap((Duration)Duration.ofMillis(5000L));
        Assert.assertTrue((boolean)assigner.isEventTime());
        Assert.assertEquals((Object)new TimeWindow.Serializer(), (Object)assigner.getWindowSerializer(new ExecutionConfig()));
        Assert.assertTrue((boolean)assigner.withEventTime().isEventTime());
        Assert.assertFalse((boolean)assigner.withProcessingTime().isEventTime());
    }
}

