/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.runtime.operators.sort.SortUtil;
import org.junit.Assert;
import org.junit.Test;

public class SortUtilTest {
    @Test
    public void testNormalizedKey() {
        int i;
        int i2;
        int len = 10;
        Random random = new Random();
        MemorySegment[] segments = new MemorySegment[len];
        MemorySegment[] compareSegs = new MemorySegment[len];
        for (i2 = 0; i2 < len; ++i2) {
            segments[i2] = MemorySegmentFactory.allocateUnpooledSegment((int)20);
            compareSegs[i2] = MemorySegmentFactory.allocateUnpooledSegment((int)20);
        }
        SortUtil.minNormalizedKey((MemorySegment)segments[0], (int)0, (int)20);
        SortUtil.maxNormalizedKey((MemorySegment)segments[1], (int)0, (int)20);
        for (i2 = 0; i2 < len; ++i2) {
            byte[] rndBytes = new byte[20];
            random.nextBytes(rndBytes);
            segments[2].put(0, rndBytes);
            Assert.assertTrue((segments[0].compare(segments[2], 0, 0, 20) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((segments[1].compare(segments[2], 0, 0, 20) >= 0 ? 1 : 0) != 0);
        }
        Object[] arr = new Decimal[len];
        for (i = 0; i < len; ++i) {
            arr[i] = Decimal.fromBigDecimal((BigDecimal)new BigDecimal(random.nextInt()), (int)18, (int)0);
            SortUtil.putDecimalNormalizedKey((Decimal)arr[i], (MemorySegment)segments[i], (int)0, (int)8);
        }
        Arrays.sort(arr, Decimal::compareTo);
        for (i = 0; i < len; ++i) {
            SortUtil.putDecimalNormalizedKey((Decimal)arr[i], (MemorySegment)compareSegs[i], (int)0, (int)8);
        }
        Arrays.sort(segments, (o1, o2) -> o1.compare(o2, 0, 0, 8));
        for (i = 0; i < len; ++i) {
            Assert.assertTrue((boolean)compareSegs[i].equalTo(segments[i], 0, 0, 8));
        }
        arr = new Float[len];
        for (i = 0; i < len; ++i) {
            arr[i] = Float.valueOf(random.nextFloat());
            SortUtil.putFloatNormalizedKey((float)arr[i].floatValue(), (MemorySegment)segments[i], (int)0, (int)4);
        }
        Arrays.sort(arr, Float::compareTo);
        for (i = 0; i < len; ++i) {
            SortUtil.putFloatNormalizedKey((float)arr[i].floatValue(), (MemorySegment)compareSegs[i], (int)0, (int)4);
        }
        Arrays.sort(segments, (o1, o2) -> o1.compare(o2, 0, 0, 4));
        for (i = 0; i < len; ++i) {
            Assert.assertTrue((boolean)compareSegs[i].equalTo(segments[i], 0, 0, 4));
        }
        arr = new Double[len];
        for (i = 0; i < len; ++i) {
            arr[i] = Double.valueOf(random.nextDouble());
            SortUtil.putDoubleNormalizedKey((double)arr[i].doubleValue(), (MemorySegment)segments[i], (int)0, (int)8);
        }
        Arrays.sort(arr, Double::compareTo);
        for (i = 0; i < len; ++i) {
            SortUtil.putDoubleNormalizedKey((double)arr[i].doubleValue(), (MemorySegment)compareSegs[i], (int)0, (int)8);
        }
        Arrays.sort(segments, (o1, o2) -> o1.compare(o2, 0, 0, 8));
        for (i = 0; i < len; ++i) {
            Assert.assertTrue((boolean)compareSegs[i].equalTo(segments[i], 0, 0, 8));
        }
        arr = new BinaryString[len];
        for (i = 0; i < len; ++i) {
            arr[i] = BinaryString.fromString((String)String.valueOf(random.nextLong()));
            SortUtil.putStringNormalizedKey((BinaryString)arr[i], (MemorySegment)segments[i], (int)0, (int)8);
        }
        Arrays.sort(arr, BinaryString::compareTo);
        for (i = 0; i < len; ++i) {
            SortUtil.putStringNormalizedKey((BinaryString)arr[i], (MemorySegment)compareSegs[i], (int)0, (int)8);
        }
        Arrays.sort(segments, (o1, o2) -> o1.compare(o2, 0, 0, 8));
        for (i = 0; i < len; ++i) {
            Assert.assertTrue((boolean)compareSegs[i].equalTo(segments[i], 0, 0, 8));
        }
    }
}

