/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.util.ArrayList;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.keyselector.BaseRowKeySelector;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.TopNFunctionTestBase;
import org.apache.flink.table.runtime.operators.rank.UpdatableTopNFunction;
import org.apache.flink.table.runtime.operators.rank.VariableRankRange;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.junit.Test;

public class UpdatableTopNFunctionTest
extends TopNFunctionTestBase {
    @Override
    protected AbstractTopNFunction createFunction(RankType rankType, RankRange rankRange, boolean generateRetraction, boolean outputRankNumber) {
        return new UpdatableTopNFunction(this.minTime.toMilliseconds(), this.maxTime.toMilliseconds(), this.inputRowType, (BaseRowKeySelector)this.rowKeySelector, sortKeyComparator, (BaseRowKeySelector)this.sortKeySelector, rankType, rankRange, generateRetraction, outputRankNumber, this.cacheSize);
    }

    @Test
    public void testVariableRankRange() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new VariableRankRange(1), true, false);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 18));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 18));
        expectedOutput.add(StreamRecordUtils.record("fruit", 1L, 44));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 1L, 44));
        expectedOutput.add(StreamRecordUtils.record("fruit", 1L, 33));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 1L, 33));
        expectedOutput.add(StreamRecordUtils.record("fruit", 1L, 22));
        this.assertorWithoutRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Override
    @Test
    public void testOutputRankNumberWithVariableRankRange() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new VariableRankRange(1), true, true);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 1L, 44, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 1L, 44, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 1L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 1L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.record("fruit", 1L, 22, 1L));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testSortKeyChangesWhenOutputRankNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, true);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 3L, 16));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.record("book", 3L, 15));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 2));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 1));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 3L, 16, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 3L, 16, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 3L, 16, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 3L, 16, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 3L, 15, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 3L, 15, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 2, 1L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 11, 2L));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 4L, 2, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 1, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 2, 2L));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testSortKeyChangesWhenOutputRankNumberAndNotGenerateRetraction() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), false, true);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 3L, 16));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.record("book", 3L, 15));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 2));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 1));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 3L, 16, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 3L, 16, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 3L, 15, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11, 2L));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 2, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 1, 1L));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 2, 2L));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testSortKeyChangesWhenNotOutputRankNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, false);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 3L, 16));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.record("book", 3L, 15));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 2));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 1));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.record("book", 3L, 16));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 3L, 16));
        expectedOutput.add(StreamRecordUtils.record("book", 3L, 15));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 2));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 3L, 15));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 1));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 11));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testSortKeyChangesWhenNotOutputRankNumberAndNotGenerateRetraction() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), false, false);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 3L, 16));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.record("book", 3L, 15));
        testHarness.processElement(StreamRecordUtils.record("book", 4L, 2));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 1));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.record("book", 3L, 16));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.record("book", 3L, 15));
        expectedOutput.add(StreamRecordUtils.record("book", 4L, 2));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 3L, 15));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 1));
        this.assertorWithRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }
}

