/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.util.ArrayList;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.keyselector.BaseRowKeySelector;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.AppendOnlyTopNFunction;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.TopNFunctionTestBase;
import org.apache.flink.table.runtime.operators.rank.VariableRankRange;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.junit.Test;

public class AppendOnlyTopNFunctionTest
extends TopNFunctionTestBase {
    @Override
    protected AbstractTopNFunction createFunction(RankType rankType, RankRange rankRange, boolean generateRetraction, boolean outputRankNumber) {
        return new AppendOnlyTopNFunction(this.minTime.toMilliseconds(), this.maxTime.toMilliseconds(), this.inputRowType, sortKeyComparator, (BaseRowKeySelector)this.sortKeySelector, rankType, rankRange, generateRetraction, outputRankNumber, this.cacheSize);
    }

    @Test
    public void testVariableRankRange() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new VariableRankRange(1), true, false);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 33));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 44));
        testHarness.processElement(StreamRecordUtils.record("fruit", 1L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 12));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.record("fruit", 1L, 33));
        expectedOutput.add(StreamRecordUtils.retractRecord("fruit", 1L, 33));
        expectedOutput.add(StreamRecordUtils.record("fruit", 1L, 22));
        this.assertorWithoutRowNumber.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }
}

