/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.join.Int2HashJoinOperatorTest;
import org.apache.flink.table.runtime.operators.join.SortMergeFullOuterJoinIterator;
import org.apache.flink.table.runtime.operators.join.SortMergeInnerJoinIterator;
import org.apache.flink.table.runtime.operators.join.SortMergeOneSideOuterJoinIterator;
import org.apache.flink.table.runtime.operators.sort.IntRecordComparator;
import org.apache.flink.table.runtime.typeutils.AbstractRowSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryRowSerializer;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SortMergeJoinIteratorTest {
    private static final int MEMORY_SIZE = 0x140000;
    private static final int BUFFER_MEMORY = 20;
    private final boolean leftIsSmall;
    private MemoryManager memManager;
    private IOManager ioManager;
    private BinaryRowSerializer serializer;

    public SortMergeJoinIteratorTest(boolean leftIsSmall) throws Exception {
        this.leftIsSmall = leftIsSmall;
    }

    @Parameterized.Parameters
    public static Collection<Boolean> parameters() {
        return Arrays.asList(true, false);
    }

    @Before
    public void before() throws MemoryAllocationException {
        this.memManager = new MemoryManager(0x140000L, 1);
        this.ioManager = new IOManagerAsync();
        this.serializer = new BinaryRowSerializer(1);
    }

    @Test
    public void testInner() throws Exception {
        this.inner(this.oneEmpty(), Collections.emptyList());
        this.inner(this.haveNull(), Collections.emptyList());
        this.inner(this.noJoin(), Collections.emptyList());
        this.inner(this.oneAndTwo(), this.newExpect1(2));
        this.inner(this.nmJoin(), this.newExpect1(6));
        this.inner(this.nmMultiJoin(), this.newExpect1(6));
    }

    @Test
    public void testOneSideOuter() throws Exception {
        List<Tuple2<BinaryRow, BinaryRow>> compare6;
        List<Tuple2<BinaryRow, BinaryRow>> compare5;
        List<Tuple2<BinaryRow, BinaryRow>> compare3;
        List<Tuple2<BinaryRow, BinaryRow>> compare2;
        List<Tuple2<BinaryRow, BinaryRow>> compare1;
        List<Tuple2<BinaryRow, BinaryRow>> compare4 = this.newExpect1(2);
        if (!this.leftIsSmall) {
            compare1 = Arrays.asList(this.newTuple(this.newRow(1), null), this.newTuple(this.newRow(2), null));
            compare2 = Collections.singletonList(this.newTuple(this.newRow(null), null));
            compare3 = Collections.singletonList(this.newTuple(this.newRow(1), null));
            compare5 = this.newExpect1(6);
            compare6 = this.newExpect1(6);
            compare6.addAll(Arrays.asList(this.newTuple(this.newRow(3), null), this.newTuple(this.newRow(5), null)));
        } else {
            compare1 = Collections.emptyList();
            compare2 = Arrays.asList(this.newTuple(null, this.newRow(null)), this.newTuple(null, this.newRow(null)));
            compare3 = Collections.emptyList();
            compare5 = this.newExpect1(6);
            compare5.add(this.newTuple(null, this.newRow(null)));
            compare6 = this.newExpect1(6);
            compare6.addAll(Arrays.asList(this.newTuple(null, this.newRow(2)), this.newTuple(null, this.newRow(4))));
        }
        this.oneSideOuter(this.oneEmpty(), compare1);
        this.oneSideOuter(this.haveNull(), compare2);
        this.oneSideOuter(this.noJoin(), compare3);
        this.oneSideOuter(this.oneAndTwo(), compare4);
        this.oneSideOuter(this.nmJoin(), compare5);
        this.oneSideOuter(this.nmMultiJoin(), compare6);
    }

    @Test
    public void testFullOuter() throws Exception {
        this.fullOuter(this.oneEmpty(), Arrays.asList(this.newTuple(this.newRow(1), null), this.newTuple(this.newRow(2), null)));
        this.fullOuter(this.haveNull(), Arrays.asList(this.newTuple(this.newRow(null), null), this.newTuple(null, this.newRow(null)), this.newTuple(null, this.newRow(null))));
        this.fullOuter(this.noJoin(), Collections.singletonList(this.newTuple(this.newRow(1), null)));
        this.fullOuter(this.oneAndTwo(), this.newExpect1(2));
        List<Tuple2<BinaryRow, BinaryRow>> compare5 = this.newExpect1(6);
        compare5.add(this.newTuple(null, this.newRow(null)));
        this.fullOuter(this.nmJoin(), compare5);
        List<Tuple2<BinaryRow, BinaryRow>> compare6 = this.newExpect1(6);
        compare6.addAll(Arrays.asList(this.newTuple(null, this.newRow(2)), this.newTuple(this.newRow(3), null), this.newTuple(null, this.newRow(4)), this.newTuple(this.newRow(5), null)));
        this.fullOuter(this.nmMultiJoin(), compare6);
    }

    private List<Tuple2<BinaryRow, BinaryRow>> newExpect1(int number) {
        ArrayList<Tuple2<BinaryRow, BinaryRow>> list = new ArrayList<Tuple2<BinaryRow, BinaryRow>>();
        for (int i = 0; i < number; ++i) {
            list.add(this.newTuple(this.newRow(1), this.newRow(1)));
        }
        return list;
    }

    public void inner(Tuple2<MutableObjectIterator<BinaryRow>, MutableObjectIterator<BinaryRow>> data, List<Tuple2<BinaryRow, BinaryRow>> compare) throws Exception {
        MutableObjectIterator input1 = (MutableObjectIterator)data.f0;
        MutableObjectIterator input2 = (MutableObjectIterator)data.f1;
        if (this.leftIsSmall) {
            input1 = (MutableObjectIterator)data.f1;
            input2 = (MutableObjectIterator)data.f0;
        }
        try (SortMergeInnerJoinIterator iterator = new SortMergeInnerJoinIterator(new BinaryRowSerializer(1), new BinaryRowSerializer(1), (Projection)new Int2HashJoinOperatorTest.MyProjection(), (Projection)new Int2HashJoinOperatorTest.MyProjection(), (RecordComparator)new IntRecordComparator(), input1, input2, new ResettableExternalBuffer(this.memManager, this.ioManager, this.memManager.allocatePages((Object)this, 20), (AbstractRowSerializer)this.serializer, false), new boolean[]{true});){
            int id = 0;
            while (iterator.nextInnerJoin()) {
                BaseRow probe = iterator.getProbeRow();
                ResettableExternalBuffer.BufferIterator iter = iterator.getMatchBuffer().newIterator();
                while (iter.advanceNext()) {
                    BinaryRow row = iter.getRow();
                    Tuple2<BinaryRow, BinaryRow> expected = compare.get(id++);
                    if (this.leftIsSmall) {
                        Assert.assertEquals(expected, (Object)new Tuple2((Object)row, (Object)probe));
                        continue;
                    }
                    Assert.assertEquals(expected, (Object)new Tuple2((Object)probe, (Object)row));
                }
            }
            Assert.assertEquals((long)compare.size(), (long)id);
        }
    }

    public void oneSideOuter(Tuple2<MutableObjectIterator<BinaryRow>, MutableObjectIterator<BinaryRow>> data, List<Tuple2<BinaryRow, BinaryRow>> compare) throws Exception {
        MutableObjectIterator input1 = (MutableObjectIterator)data.f0;
        MutableObjectIterator input2 = (MutableObjectIterator)data.f1;
        if (this.leftIsSmall) {
            input1 = (MutableObjectIterator)data.f1;
            input2 = (MutableObjectIterator)data.f0;
        }
        try (SortMergeOneSideOuterJoinIterator iterator = new SortMergeOneSideOuterJoinIterator(new BinaryRowSerializer(1), new BinaryRowSerializer(1), (Projection)new Int2HashJoinOperatorTest.MyProjection(), (Projection)new Int2HashJoinOperatorTest.MyProjection(), (RecordComparator)new IntRecordComparator(), input1, input2, new ResettableExternalBuffer(this.memManager, this.ioManager, this.memManager.allocatePages((Object)this, 20), (AbstractRowSerializer)this.serializer, false), new boolean[]{true});){
            int id = 0;
            while (iterator.nextOuterJoin()) {
                BaseRow probe = iterator.getProbeRow();
                if (iterator.matchKey == null) {
                    Tuple2<BinaryRow, BinaryRow> expected = compare.get(id++);
                    if (this.leftIsSmall) {
                        Assert.assertEquals(expected, (Object)new Tuple2(null, (Object)probe));
                        continue;
                    }
                    Assert.assertEquals(expected, (Object)new Tuple2((Object)probe, null));
                    continue;
                }
                ResettableExternalBuffer.BufferIterator iter = iterator.getMatchBuffer().newIterator();
                while (iter.advanceNext()) {
                    BinaryRow row = iter.getRow();
                    Tuple2<BinaryRow, BinaryRow> expected = compare.get(id++);
                    Assert.assertEquals(expected, (Object)new Tuple2((Object)row, (Object)probe));
                }
            }
            Assert.assertEquals((long)compare.size(), (long)id);
        }
    }

    public void fullOuter(Tuple2<MutableObjectIterator<BinaryRow>, MutableObjectIterator<BinaryRow>> data, List<Tuple2<BinaryRow, BinaryRow>> compare) throws Exception {
        MutableObjectIterator input1 = (MutableObjectIterator)data.f0;
        MutableObjectIterator input2 = (MutableObjectIterator)data.f1;
        try (SortMergeFullOuterJoinIterator iterator = new SortMergeFullOuterJoinIterator(new BinaryRowSerializer(1), new BinaryRowSerializer(1), (Projection)new Int2HashJoinOperatorTest.MyProjection(), (Projection)new Int2HashJoinOperatorTest.MyProjection(), (RecordComparator)new IntRecordComparator(), input1, input2, new ResettableExternalBuffer(this.memManager, this.ioManager, this.memManager.allocatePages((Object)this, 20), (AbstractRowSerializer)this.serializer, false), new ResettableExternalBuffer(this.memManager, this.ioManager, this.memManager.allocatePages((Object)this, 20), (AbstractRowSerializer)this.serializer, false), new boolean[]{true});){
            int id = 0;
            while (iterator.nextOuterJoin()) {
                Tuple2<BinaryRow, BinaryRow> expected;
                BinaryRow row;
                ResettableExternalBuffer.BufferIterator iter;
                BinaryRow matchKey = iterator.getMatchKey();
                ResettableExternalBuffer buffer1 = iterator.getBuffer1();
                ResettableExternalBuffer buffer2 = iterator.getBuffer2();
                if (matchKey == null && buffer1.size() > 0) {
                    iter = buffer1.newIterator();
                    while (iter.advanceNext()) {
                        row = iter.getRow();
                        expected = compare.get(id++);
                        Assert.assertEquals(expected, (Object)new Tuple2((Object)row, null));
                    }
                    continue;
                }
                if (matchKey == null && buffer2.size() > 0) {
                    iter = buffer2.newIterator();
                    while (iter.advanceNext()) {
                        row = iter.getRow();
                        expected = compare.get(id++);
                        Assert.assertEquals(expected, (Object)new Tuple2(null, (Object)row));
                    }
                    continue;
                }
                if (matchKey != null) {
                    ResettableExternalBuffer.BufferIterator iter1 = buffer1.newIterator();
                    while (iter1.advanceNext()) {
                        BinaryRow row1 = iter1.getRow();
                        ResettableExternalBuffer.BufferIterator iter2 = buffer2.newIterator();
                        while (iter2.advanceNext()) {
                            BinaryRow row2 = iter2.getRow();
                            Tuple2<BinaryRow, BinaryRow> expected2 = compare.get(id++);
                            Assert.assertEquals(expected2, (Object)new Tuple2((Object)row1, (Object)row2));
                        }
                    }
                    continue;
                }
                throw new RuntimeException("There is a bug.");
            }
            Assert.assertEquals((long)compare.size(), (long)id);
        }
    }

    private Tuple2<MutableObjectIterator<BinaryRow>, MutableObjectIterator<BinaryRow>> oneEmpty() {
        return new Tuple2((Object)new ListIterator(Arrays.asList(this.newRow(1), this.newRow(2))), (Object)new ListIterator(Collections.emptyList()));
    }

    private Tuple2<MutableObjectIterator<BinaryRow>, MutableObjectIterator<BinaryRow>> oneAndTwo() {
        return new Tuple2((Object)new ListIterator(Collections.singletonList(this.newRow(1))), (Object)new ListIterator(Arrays.asList(this.newRow(1), this.newRow(1))));
    }

    private Tuple2<MutableObjectIterator<BinaryRow>, MutableObjectIterator<BinaryRow>> haveNull() {
        return new Tuple2((Object)new ListIterator(Collections.singletonList(this.newRow(null))), (Object)new ListIterator(Arrays.asList(this.newRow(null), this.newRow(null))));
    }

    private Tuple2<MutableObjectIterator<BinaryRow>, MutableObjectIterator<BinaryRow>> noJoin() {
        return new Tuple2((Object)new ListIterator(Collections.singletonList(this.newRow(1))), (Object)new ListIterator(Collections.emptyList()));
    }

    private Tuple2<MutableObjectIterator<BinaryRow>, MutableObjectIterator<BinaryRow>> nmJoin() {
        return new Tuple2((Object)new ListIterator(Arrays.asList(this.newRow(1), this.newRow(1))), (Object)new ListIterator(Arrays.asList(this.newRow(1), this.newRow(1), this.newRow(1), this.newRow(null))));
    }

    private Tuple2<MutableObjectIterator<BinaryRow>, MutableObjectIterator<BinaryRow>> nmMultiJoin() {
        return new Tuple2((Object)new ListIterator(Arrays.asList(this.newRow(1), this.newRow(1), this.newRow(3), this.newRow(5))), (Object)new ListIterator(Arrays.asList(this.newRow(1), this.newRow(1), this.newRow(1), this.newRow(2), this.newRow(4))));
    }

    public BinaryRow newRow(Integer i) {
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        if (i != null) {
            writer.writeInt(0, i.intValue());
        } else {
            writer.setNullAt(0);
        }
        writer.complete();
        return row;
    }

    public Tuple2<BinaryRow, BinaryRow> newTuple(BinaryRow i, BinaryRow j) {
        return new Tuple2((Object)i, (Object)j);
    }

    public static class ListIterator
    implements MutableObjectIterator<BinaryRow> {
        private List<BinaryRow> list;
        private int index = 0;

        public ListIterator(List<BinaryRow> list) {
            this.list = list;
        }

        public BinaryRow next(BinaryRow binaryRow) throws IOException {
            return this.next();
        }

        public BinaryRow next() throws IOException {
            if (this.index < this.list.size()) {
                return this.list.get(this.index++);
            }
            return null;
        }
    }
}

