/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.GeneratedNormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.Int2HashJoinOperatorTest;
import org.apache.flink.table.runtime.operators.join.SortMergeJoinOperator;
import org.apache.flink.table.runtime.operators.sort.IntNormalizedKeyComputer;
import org.apache.flink.table.runtime.operators.sort.IntRecordComparator;
import org.apache.flink.table.runtime.util.UniformBinaryRowGenerator;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Int2SortMergeJoinOperatorTest {
    private boolean leftIsSmaller;
    private MemoryManager memManager;
    private IOManager ioManager;

    public Int2SortMergeJoinOperatorTest(boolean leftIsSmaller) {
        this.leftIsSmaller = leftIsSmaller;
    }

    @Parameterized.Parameters
    public static Collection<Boolean> parameters() {
        return Arrays.asList(true, false);
    }

    @Before
    public void setup() {
        this.memManager = new MemoryManager(0x2400000L, 1);
        this.ioManager = new IOManagerAsync();
    }

    @After
    public void tearDown() throws Exception {
        this.ioManager.close();
        if (!this.memManager.verifyEmpty()) {
            Assert.fail((String)"Not all memory was properly released to the memory manager --> Memory Leak.");
        }
    }

    @Test
    public void testInnerJoin() throws Exception {
        int numKeys = 100;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys, buildValsPerKey, false);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, FlinkJoinType.INNER, numKeys * buildValsPerKey * probeValsPerKey, numKeys, 165);
    }

    @Test
    public void testLeftOutJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, FlinkJoinType.LEFT, numKeys1 * buildValsPerKey * probeValsPerKey, numKeys1, 165);
    }

    @Test
    public void testRightOutJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, FlinkJoinType.RIGHT, 280, numKeys2, -1);
    }

    @Test
    public void testFullOutJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, FlinkJoinType.FULL, 280, numKeys2, -1);
    }

    @Test
    public void testSemiJoin() throws Exception {
        int numKeys1 = 10;
        int numKeys2 = 9;
        int buildValsPerKey = 10;
        int probeValsPerKey = 3;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        StreamOperator operator = Int2SortMergeJoinOperatorTest.newOperator(FlinkJoinType.SEMI, false);
        Int2HashJoinOperatorTest.joinAndAssert(operator, buildInput, probeInput, 90, 9, 45, true);
    }

    @Test
    public void testAntiJoin() throws Exception {
        int numKeys1 = 10;
        int numKeys2 = 9;
        int buildValsPerKey = 10;
        int probeValsPerKey = 3;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        StreamOperator operator = Int2SortMergeJoinOperatorTest.newOperator(FlinkJoinType.ANTI, false);
        Int2HashJoinOperatorTest.joinAndAssert(operator, buildInput, probeInput, 10, 1, 45, true);
    }

    private void buildJoin(MutableObjectIterator<BinaryRow> input1, MutableObjectIterator<BinaryRow> input2, FlinkJoinType type, int expertOutSize, int expertOutKeySize, int expertOutVal) throws Exception {
        Int2HashJoinOperatorTest.joinAndAssert(this.getOperator(type), input1, input2, expertOutSize, expertOutKeySize, expertOutVal, false);
    }

    private StreamOperator getOperator(FlinkJoinType type) {
        return Int2SortMergeJoinOperatorTest.newOperator(type, this.leftIsSmaller);
    }

    static StreamOperator newOperator(FlinkJoinType type, boolean leftIsSmaller) {
        return new SortMergeJoinOperator(0x100000L, 0x100000L, type, leftIsSmaller, new GeneratedJoinCondition("", "", new Object[0]){

            public JoinCondition newInstance(ClassLoader classLoader) {
                return new Int2HashJoinOperatorTest.TrueCondition();
            }
        }, new GeneratedProjection("", "", new Object[0]){

            public Projection newInstance(ClassLoader classLoader) {
                return new Int2HashJoinOperatorTest.MyProjection();
            }
        }, new GeneratedProjection("", "", new Object[0]){

            public Projection newInstance(ClassLoader classLoader) {
                return new Int2HashJoinOperatorTest.MyProjection();
            }
        }, new GeneratedNormalizedKeyComputer("", ""){

            public NormalizedKeyComputer newInstance(ClassLoader classLoader) {
                return new IntNormalizedKeyComputer();
            }
        }, new GeneratedRecordComparator("", "", new Object[0]){

            public RecordComparator newInstance(ClassLoader classLoader) {
                return new IntRecordComparator();
            }
        }, new GeneratedNormalizedKeyComputer("", ""){

            public NormalizedKeyComputer newInstance(ClassLoader classLoader) {
                return new IntNormalizedKeyComputer();
            }
        }, new GeneratedRecordComparator("", "", new Object[0]){

            public RecordComparator newInstance(ClassLoader classLoader) {
                return new IntRecordComparator();
            }
        }, new GeneratedRecordComparator("", "", new Object[0]){

            public RecordComparator newInstance(ClassLoader classLoader) {
                return new IntRecordComparator();
            }
        }, new boolean[]{true});
    }
}

