/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.util.ArrayList;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.operators.bundle.KeyedMapBundleOperator;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.operators.bundle.trigger.BundleTrigger;
import org.apache.flink.table.runtime.operators.bundle.trigger.CountBundleTrigger;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionTestBase;
import org.apache.flink.table.runtime.operators.deduplicate.MiniBatchDeduplicateKeepFirstRowFunction;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.junit.Assert;
import org.junit.Test;

public class MiniBatchDeduplicateKeepFirstRowFunctionTest
extends DeduplicateFunctionTestBase {
    private TypeSerializer<BaseRow> typeSerializer;

    public MiniBatchDeduplicateKeepFirstRowFunctionTest() {
        this.typeSerializer = this.inputRowType.createSerializer(new ExecutionConfig());
    }

    private OneInputStreamOperatorTestHarness<BaseRow, BaseRow> createTestHarness(MiniBatchDeduplicateKeepFirstRowFunction func) throws Exception {
        CountBundleTrigger trigger = new CountBundleTrigger(3L);
        KeyedMapBundleOperator op = new KeyedMapBundleOperator((MapBundleFunction)func, (BundleTrigger)trigger);
        return new KeyedOneInputStreamOperatorTestHarness((OneInputStreamOperator)op, (KeySelector)this.rowKeySelector, (TypeInformation)this.rowKeySelector.getProducedType());
    }

    @Test
    public void testKeepFirstRowWithGenerateRetraction() throws Exception {
        MiniBatchDeduplicateKeepFirstRowFunction func = new MiniBatchDeduplicateKeepFirstRowFunction(this.typeSerializer);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 11));
        Assert.assertTrue((boolean)testHarness.getOutput().isEmpty());
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 13));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }
}

