/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.util.ArrayList;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionTestBase;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateKeepLastRowFunction;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.junit.Test;

public class DeduplicateKeepLastRowFunctionTest
extends DeduplicateFunctionTestBase {
    private DeduplicateKeepLastRowFunction createFunction(boolean generateRetraction) {
        return new DeduplicateKeepLastRowFunction(this.minTime.toMilliseconds(), this.maxTime.toMilliseconds(), this.inputRowType, generateRetraction);
    }

    private OneInputStreamOperatorTestHarness<BaseRow, BaseRow> createTestHarness(DeduplicateKeepLastRowFunction func) throws Exception {
        KeyedProcessOperator operator = new KeyedProcessOperator((KeyedProcessFunction)func);
        return new KeyedOneInputStreamOperatorTestHarness((OneInputStreamOperator)operator, (KeySelector)this.rowKeySelector, (TypeInformation)this.rowKeySelector.getProducedType());
    }

    @Test
    public void testWithoutGenerateRetraction() throws Exception {
        DeduplicateKeepLastRowFunction func = this.createFunction(false);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 13));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 13));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testWithGenerateRetraction() throws Exception {
        DeduplicateKeepLastRowFunction func = this.createFunction(true);
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 13));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.retractRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 13));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }
}

