/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.util.ArrayList;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionTestBase;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateKeepFirstRowFunction;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.junit.Test;

public class DeduplicateKeepFirstRowFunctionTest
extends DeduplicateFunctionTestBase {
    private OneInputStreamOperatorTestHarness<BaseRow, BaseRow> createTestHarness(DeduplicateKeepFirstRowFunction func) throws Exception {
        KeyedProcessOperator operator = new KeyedProcessOperator((KeyedProcessFunction)func);
        return new KeyedOneInputStreamOperatorTestHarness((OneInputStreamOperator)operator, (KeySelector)this.rowKeySelector, (TypeInformation)this.rowKeySelector.getProducedType());
    }

    @Test
    public void test() throws Exception {
        DeduplicateKeepFirstRowFunction func = new DeduplicateKeepFirstRowFunction(this.minTime.toMilliseconds(), this.maxTime.toMilliseconds());
        OneInputStreamOperatorTestHarness<BaseRow, BaseRow> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.record("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.record("book", 1L, 13));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.record("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.record("book", 2L, 11));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }
}

