/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.runtime.operators.aggregate.BytesHashMap;
import org.apache.flink.table.runtime.typeutils.BinaryRowSerializer;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Assert;
import org.junit.Test;

public class BytesHashMapTest {
    private static final long RANDOM_SEED = 76518743207143L;
    private static final int PAGE_SIZE = 32768;
    private static final int NUM_ENTRIES = 10000;
    private static final int NUM_REWRITES = 10;
    private final LogicalType[] keyTypes = new LogicalType[]{new IntType(), new VarCharType(Integer.MAX_VALUE), new DoubleType(), new BigIntType(), new BooleanType(), new FloatType(), new SmallIntType()};
    private final LogicalType[] valueTypes = new LogicalType[]{new DoubleType(), new BigIntType(), new BooleanType(), new FloatType(), new SmallIntType()};
    private final BinaryRow defaultValue;
    private final BinaryRowSerializer keySerializer = new BinaryRowSerializer(this.keyTypes.length);
    private final BinaryRowSerializer valueSerializer = new BinaryRowSerializer(this.valueTypes.length);

    public BytesHashMapTest() {
        this.defaultValue = this.valueSerializer.createInstance();
        int valueSize = this.defaultValue.getFixedLengthPartSize();
        this.defaultValue.pointTo(MemorySegmentFactory.wrap((byte[])new byte[valueSize]), 0, valueSize);
    }

    @Test
    public void testHashSetMode() throws IOException {
        int numMemSegments = this.needNumMemSegments(10000, this.rowLength(RowType.of((LogicalType[])this.valueTypes)), this.rowLength(RowType.of((LogicalType[])this.keyTypes)), 32768);
        int memorySize = numMemSegments * 32768;
        MemoryManager memoryManager = new MemoryManager((long)(numMemSegments * 32768), 32);
        BytesHashMap table = new BytesHashMap((Object)this, memoryManager, (long)memorySize, this.keyTypes, new LogicalType[0]);
        Assert.assertTrue((boolean)table.isHashSetMode());
        Random rnd = new Random(76518743207143L);
        BinaryRow[] keys = this.getRandomizedInput(10000, rnd, true);
        this.verifyKeyInsert(keys, table);
        this.verifyKeyPresent(keys, table);
        table.free();
    }

    @Test
    public void testBuildAndRetrieve() throws Exception {
        int numMemSegments = this.needNumMemSegments(10000, this.rowLength(RowType.of((LogicalType[])this.valueTypes)), this.rowLength(RowType.of((LogicalType[])this.keyTypes)), 32768);
        int memorySize = numMemSegments * 32768;
        MemoryManager memoryManager = new MemoryManager((long)memorySize, 32);
        BytesHashMap table = new BytesHashMap((Object)this, memoryManager, (long)memorySize, this.keyTypes, this.valueTypes);
        Random rnd = new Random(76518743207143L);
        BinaryRow[] rows = this.getRandomizedInput(10000, rnd, true);
        ArrayList<BinaryRow> expected = new ArrayList<BinaryRow>(10000);
        this.verifyInsert(rows, expected, table);
        this.verifyRetrieve(table, rows, expected);
        table.free();
    }

    @Test
    public void testBuildAndUpdate() throws Exception {
        Random rnd = new Random(76518743207143L);
        BinaryRow[] rows = this.getRandomizedInput(10000, rnd, true);
        int numMemSegments = this.needNumMemSegments(10000, this.rowLength(RowType.of((LogicalType[])this.valueTypes)), this.rowLength(RowType.of((LogicalType[])this.keyTypes)), 32768);
        int memorySize = numMemSegments * 32768;
        MemoryManager memoryManager = new MemoryManager((long)memorySize, 32);
        BytesHashMap table = new BytesHashMap((Object)this, memoryManager, (long)memorySize, this.keyTypes, this.valueTypes);
        ArrayList<BinaryRow> expected = new ArrayList<BinaryRow>(10000);
        this.verifyInsertAndUpdate(rnd, rows, expected, table);
        this.verifyRetrieve(table, rows, expected);
        table.free();
    }

    @Test
    public void testRest() throws Exception {
        Random rnd = new Random(76518743207143L);
        BinaryRow[] rows = this.getRandomizedInput(10000, rnd, true);
        int numMemSegments = this.needNumMemSegments(10000, this.rowLength(RowType.of((LogicalType[])this.valueTypes)), this.rowLength(RowType.of((LogicalType[])this.keyTypes)), 32768);
        int memorySize = numMemSegments * 32768;
        MemoryManager memoryManager = new MemoryManager((long)memorySize, 32);
        BytesHashMap table = new BytesHashMap((Object)this, memoryManager, (long)memorySize, this.keyTypes, this.valueTypes);
        ArrayList<BinaryRow> expected = new ArrayList<BinaryRow>(10000);
        this.verifyInsertAndUpdate(rnd, rows, expected, table);
        this.verifyRetrieve(table, rows, expected);
        table.reset();
        Assert.assertEquals((long)0L, (long)table.getNumElements());
        Assert.assertTrue((table.getRecordAreaMemorySegments().size() == 1 ? 1 : 0) != 0);
        expected.clear();
        this.verifyInsertAndUpdate(rnd, rows, expected, table);
        this.verifyRetrieve(table, rows, expected);
        table.free();
    }

    @Test
    public void testResetAndOutput() throws Exception {
        Random rnd = new Random(76518743207143L);
        int reservedMemSegments = 32;
        int minMemorySize = 0x100000;
        MemoryManager memoryManager = new MemoryManager((long)minMemorySize, 32, 32768, MemoryType.HEAP, true);
        BytesHashMap table = new BytesHashMap((Object)this, memoryManager, (long)minMemorySize, this.keyTypes, this.valueTypes, true);
        BinaryRow[] rows = this.getRandomizedInput(10000, rnd, true);
        ArrayList<BinaryRow> expected = new ArrayList<BinaryRow>(10000);
        ArrayList<BinaryRow> actualValues = new ArrayList<BinaryRow>(10000);
        ArrayList<BinaryRow> actualKeys = new ArrayList<BinaryRow>(10000);
        for (int i = 0; i < 10000; ++i) {
            BinaryRow groupKey = rows[i];
            BytesHashMap.LookupInfo info = table.lookup(groupKey);
            Assert.assertFalse((boolean)info.isFound());
            try {
                BinaryRow entry = table.append(info, this.defaultValue);
                Assert.assertNotNull((Object)entry);
                for (int j = 0; j < 10; ++j) {
                    this.updateOutputBuffer(entry, rnd);
                }
                expected.add(entry.copy());
                continue;
            }
            catch (Exception e) {
                ArrayList segments = table.getRecordAreaMemorySegments();
                RandomAccessInputView inView = new RandomAccessInputView(segments, ((MemorySegment)segments.get(0)).size());
                BinaryRow reuseKey = this.keySerializer.createInstance();
                BinaryRow reuseValue = this.valueSerializer.createInstance();
                BytesHashMap.Entry reuse = new BytesHashMap.Entry(reuseKey, reuseValue);
                int index = 0;
                while ((long)index < table.getNumElements()) {
                    reuseKey = this.keySerializer.mapFromPages(reuseKey, (AbstractPagedInputView)inView);
                    reuseValue = this.valueSerializer.mapFromPages(reuseValue, (AbstractPagedInputView)inView);
                    actualKeys.add(reuse.getKey().copy());
                    actualValues.add(reuse.getValue().copy());
                    ++index;
                }
                table.reset();
                info = table.lookup(groupKey);
                BinaryRow entry = table.append(info, this.defaultValue);
                Assert.assertNotNull((Object)entry);
                for (int j = 0; j < 10; ++j) {
                    this.updateOutputBuffer(entry, rnd);
                }
                expected.add(entry.copy());
            }
        }
        MutableObjectIterator iter = table.getEntryIterator();
        BinaryRow reuseKey = this.keySerializer.createInstance();
        BinaryRow reuseValue = this.valueSerializer.createInstance();
        BytesHashMap.Entry reuse = new BytesHashMap.Entry(reuseKey, reuseValue);
        while ((reuse = (BytesHashMap.Entry)iter.next((Object)reuse)) != null) {
            actualKeys.add(reuse.getKey().copy());
            actualValues.add(reuse.getValue().copy());
        }
        Assert.assertEquals((long)10000L, (long)expected.size());
        Assert.assertEquals((long)10000L, (long)actualKeys.size());
        Assert.assertEquals((long)10000L, (long)actualValues.size());
        Assert.assertEquals(expected, actualValues);
        table.free();
    }

    @Test
    public void testSingleKeyMultipleOps() throws Exception {
        BytesHashMap.LookupInfo info;
        int i;
        int numMemSegments = this.needNumMemSegments(10000, this.rowLength(RowType.of((LogicalType[])this.valueTypes)), this.rowLength(RowType.of((LogicalType[])this.keyTypes)), 32768);
        int memorySize = numMemSegments * 32768;
        MemoryManager memoryManager = new MemoryManager((long)memorySize, 32);
        BytesHashMap table = new BytesHashMap((Object)this, memoryManager, (long)memorySize, this.keyTypes, this.valueTypes);
        Random rnd = new Random(76518743207143L);
        BinaryRow row = this.getNullableGroupkeyInput(rnd);
        for (i = 0; i < 3; ++i) {
            info = table.lookup(row);
            Assert.assertFalse((boolean)info.isFound());
        }
        for (i = 0; i < 3; ++i) {
            info = table.lookup(row);
            BinaryRow entry = info.getValue();
            if (i == 0) {
                Assert.assertFalse((boolean)info.isFound());
                entry = table.append(info, this.defaultValue);
            } else {
                Assert.assertTrue((boolean)info.isFound());
            }
            Assert.assertNotNull((Object)entry);
        }
        table.free();
    }

    private void updateOutputBuffer(BinaryRow reuse, Random rnd) {
        long longVal = rnd.nextLong();
        double doubleVal = rnd.nextDouble();
        boolean boolVal = longVal % 2L == 0L;
        reuse.setDouble(2, doubleVal);
        reuse.setLong(3, longVal);
        reuse.setBoolean(4, boolVal);
    }

    private void verifyRetrieve(BytesHashMap table, BinaryRow[] keys, List<BinaryRow> expected) throws IOException {
        Assert.assertEquals((long)10000L, (long)table.getNumElements());
        for (int i = 0; i < 10000; ++i) {
            BinaryRow groupKey = keys[i];
            BytesHashMap.LookupInfo info = table.lookup(groupKey);
            Assert.assertTrue((boolean)info.isFound());
            Assert.assertNotNull((Object)info.getValue());
            Assert.assertEquals((Object)expected.get(i), (Object)info.getValue());
        }
    }

    private void verifyInsert(BinaryRow[] keys, List<BinaryRow> inserted, BytesHashMap table) throws IOException {
        for (int i = 0; i < 10000; ++i) {
            BinaryRow groupKey = keys[i];
            BytesHashMap.LookupInfo info = table.lookup(groupKey);
            Assert.assertFalse((boolean)info.isFound());
            BinaryRow entry = table.append(info, this.defaultValue);
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((Object)entry, (Object)this.defaultValue);
            inserted.add(entry.copy());
        }
        Assert.assertEquals((long)10000L, (long)table.getNumElements());
    }

    private void verifyInsertAndUpdate(Random rnd, BinaryRow[] keys, List<BinaryRow> inserted, BytesHashMap table) throws IOException {
        for (int i = 0; i < 10000; ++i) {
            BinaryRow groupKey = keys[i];
            BytesHashMap.LookupInfo info = table.lookup(groupKey);
            Assert.assertFalse((boolean)info.isFound());
            BinaryRow entry = table.append(info, this.defaultValue);
            Assert.assertNotNull((Object)entry);
            for (int j = 0; j < 10; ++j) {
                this.updateOutputBuffer(entry, rnd);
            }
            inserted.add(entry.copy());
        }
        Assert.assertEquals((long)10000L, (long)table.getNumElements());
    }

    private void verifyKeyPresent(BinaryRow[] keys, BytesHashMap table) throws IOException {
        Assert.assertEquals((long)10000L, (long)table.getNumElements());
        BinaryRow present = new BinaryRow(0);
        present.pointTo(MemorySegmentFactory.wrap((byte[])new byte[8]), 0, 8);
        for (int i = 0; i < 10000; ++i) {
            BinaryRow groupKey = keys[i];
            BytesHashMap.LookupInfo info = table.lookup(groupKey);
            Assert.assertTrue((boolean)info.isFound());
            Assert.assertNotNull((Object)info.getValue());
            Assert.assertEquals((Object)present, (Object)info.getValue());
        }
    }

    private void verifyKeyInsert(BinaryRow[] keys, BytesHashMap table) throws IOException {
        BinaryRow present = new BinaryRow(0);
        present.pointTo(MemorySegmentFactory.wrap((byte[])new byte[8]), 0, 8);
        for (int i = 0; i < 10000; ++i) {
            BinaryRow groupKey = keys[i];
            BytesHashMap.LookupInfo info = table.lookup(groupKey);
            Assert.assertFalse((boolean)info.isFound());
            BinaryRow entry = table.append(info, this.defaultValue);
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((Object)entry, (Object)present);
        }
        Assert.assertEquals((long)10000L, (long)table.getNumElements());
    }

    private List<MemorySegment> getMemory(int numSegments, int segmentSize) {
        ArrayList<MemorySegment> list = new ArrayList<MemorySegment>(numSegments);
        for (int i = 0; i < numSegments; ++i) {
            list.add(MemorySegmentFactory.allocateUnpooledSegment((int)segmentSize));
        }
        return list;
    }

    private int needNumMemSegments(int numEntries, int valLen, int keyLen, int pageSize) {
        return 2 * (valLen + keyLen + 3072 + 4 + 8 + 8) * numEntries / pageSize;
    }

    private BinaryRow[] getRandomizedInput(int num, Random rnd, boolean nullable) {
        BinaryRow[] lists = new BinaryRow[num];
        for (int i = 0; i < num; ++i) {
            Integer intVal = rnd.nextInt(Integer.MAX_VALUE);
            Long longVal = -rnd.nextLong();
            Boolean boolVal = longVal % 2L == 0L;
            String strVal = nullable && boolVal != false ? null : this.getString(intVal, intVal % 1024) + i;
            Double doubleVal = rnd.nextDouble();
            Short shotVal = intVal.shortValue();
            Float floatVal = nullable && boolVal != false ? null : Float.valueOf(rnd.nextFloat());
            lists[i] = this.createRow(intVal, strVal, doubleVal, longVal, boolVal, floatVal, shotVal);
        }
        return lists;
    }

    private BinaryRow getNullableGroupkeyInput(Random rnd) {
        Integer intVal = -rnd.nextInt(Integer.MAX_VALUE);
        Long longVal = rnd.nextLong();
        Boolean boolVal = intVal % 2 == 0;
        Double doubleVal = rnd.nextDouble();
        Short shotVal = intVal.shortValue();
        Float floatVal = Float.valueOf(rnd.nextFloat());
        return this.createRow(intVal, null, doubleVal, longVal, boolVal, floatVal, shotVal);
    }

    private BinaryRow createRow(Integer f0, String f1, Double f2, Long f3, Boolean f4, Float f5, Short f6) {
        BinaryRow row = new BinaryRow(7);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        if (f0 == null) {
            writer.setNullAt(0);
        } else {
            writer.writeInt(0, f0.intValue());
        }
        if (f1 == null) {
            writer.setNullAt(1);
        } else {
            writer.writeString(1, BinaryString.fromString((String)f1));
        }
        if (f2 == null) {
            writer.setNullAt(2);
        } else {
            writer.writeDouble(2, f2.doubleValue());
        }
        if (f3 == null) {
            writer.setNullAt(3);
        } else {
            writer.writeLong(3, f3.longValue());
        }
        if (f4 == null) {
            writer.setNullAt(4);
        } else {
            writer.writeBoolean(4, f4.booleanValue());
        }
        if (f5 == null) {
            writer.setNullAt(5);
        } else {
            writer.writeFloat(5, f5.floatValue());
        }
        if (f6 == null) {
            writer.setNullAt(6);
        } else {
            writer.writeShort(6, f6.shortValue());
        }
        writer.complete();
        return row;
    }

    private String getString(int count, int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(count);
        }
        return builder.toString();
    }

    private int rowLength(RowType tpe) {
        return BinaryRow.calculateFixPartSizeInBytes((int)tpe.getFieldCount()) + BytesHashMap.getVariableLength((LogicalType[])tpe.getChildren().toArray(new LogicalType[0]));
    }
}

