/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.generated;

import java.net.URL;
import java.net.URLClassLoader;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.table.runtime.generated.CompileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CompileUtilsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void before() {
        CompileUtils.COMPILED_CACHE.invalidateAll();
    }

    @Test
    public void testCacheReuse() {
        String code = "public class Main {\n  int i;\n  int j;\n}";
        Class class1 = CompileUtils.compile((ClassLoader)this.getClass().getClassLoader(), (String)"Main", (String)code);
        Class class2 = CompileUtils.compile((ClassLoader)this.getClass().getClassLoader(), (String)"Main", (String)code);
        Class class3 = CompileUtils.compile((ClassLoader)new TestClassLoader(), (String)"Main", (String)code);
        Assert.assertSame((Object)class1, (Object)class2);
        Assert.assertNotSame((Object)class1, (Object)class3);
    }

    @Test
    public void testWrongCode() {
        String code = "public class111 Main {\n  int i;\n  int j;\n}";
        this.thrown.expect(InvalidProgramException.class);
        this.thrown.expectMessage("Table program cannot be compiled. This is a bug. Please file an issue.");
        CompileUtils.compile((ClassLoader)this.getClass().getClassLoader(), (String)"Main", (String)code);
    }

    private static class TestClassLoader
    extends URLClassLoader {
        TestClassLoader() {
            super(new URL[0], Thread.currentThread().getContextClassLoader());
        }
    }
}

