/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.vector;

import java.nio.charset.StandardCharsets;
import org.apache.flink.table.dataformat.ColumnarRow;
import org.apache.flink.table.dataformat.vector.ColumnVector;
import org.apache.flink.table.dataformat.vector.Dictionary;
import org.apache.flink.table.dataformat.vector.VectorizedColumnBatch;
import org.apache.flink.table.dataformat.vector.heap.HeapBooleanVector;
import org.apache.flink.table.dataformat.vector.heap.HeapByteVector;
import org.apache.flink.table.dataformat.vector.heap.HeapBytesVector;
import org.apache.flink.table.dataformat.vector.heap.HeapDoubleVector;
import org.apache.flink.table.dataformat.vector.heap.HeapFloatVector;
import org.apache.flink.table.dataformat.vector.heap.HeapIntVector;
import org.apache.flink.table.dataformat.vector.heap.HeapLongVector;
import org.apache.flink.table.dataformat.vector.heap.HeapShortVector;
import org.junit.Assert;
import org.junit.Test;

public class VectorizedColumnBatchTest {
    private static final int VECTOR_SIZE = 1024;

    @Test
    public void testTyped() {
        HeapBooleanVector col0 = new HeapBooleanVector(1024);
        for (int i = 0; i < 1024; ++i) {
            col0.vector[i] = i % 2 == 0;
        }
        HeapBytesVector col1 = new HeapBytesVector(1024);
        for (int i = 0; i < 1024; ++i) {
            byte[] bytes = String.valueOf(i).getBytes(StandardCharsets.UTF_8);
            col1.setVal(i, bytes, 0, bytes.length);
        }
        HeapByteVector col2 = new HeapByteVector(1024);
        for (int i = 0; i < 1024; ++i) {
            col2.vector[i] = (byte)i;
        }
        HeapDoubleVector col3 = new HeapDoubleVector(1024);
        for (int i = 0; i < 1024; ++i) {
            col3.vector[i] = i;
        }
        HeapFloatVector col4 = new HeapFloatVector(1024);
        for (int i = 0; i < 1024; ++i) {
            col4.vector[i] = i;
        }
        HeapIntVector col5 = new HeapIntVector(1024);
        for (int i = 0; i < 1024; ++i) {
            col5.vector[i] = i;
        }
        HeapLongVector col6 = new HeapLongVector(1024);
        for (int i = 0; i < 1024; ++i) {
            col6.vector[i] = i;
        }
        HeapShortVector col7 = new HeapShortVector(1024);
        for (int i = 0; i < 1024; ++i) {
            col7.vector[i] = (short)i;
        }
        VectorizedColumnBatch batch = new VectorizedColumnBatch(new ColumnVector[]{col0, col1, col2, col3, col4, col5, col6, col7});
        for (int i = 0; i < 1024; ++i) {
            ColumnarRow row = new ColumnarRow(batch, i);
            Assert.assertEquals((Object)row.getBoolean(0), (Object)(i % 2 == 0 ? 1 : 0));
            Assert.assertEquals((Object)row.getString(1).toString(), (Object)String.valueOf(i));
            Assert.assertEquals((long)row.getByte(2), (long)((byte)i));
            Assert.assertEquals((double)row.getDouble(3), (double)i, (double)0.0);
            Assert.assertEquals((float)row.getFloat(4), (float)i, (float)0.0f);
            Assert.assertEquals((long)row.getInt(5), (long)i);
            Assert.assertEquals((long)row.getLong(6), (long)i);
            Assert.assertEquals((long)row.getShort(7), (long)((short)i));
        }
    }

    @Test
    public void testNull() {
        HeapIntVector col0 = new HeapIntVector(1024);
        for (int i = 0; i < 1024; ++i) {
            col0.setNullAt(i);
        }
        HeapIntVector col1 = new HeapIntVector(1024);
        for (int i = 0; i < 1024; ++i) {
            if (i % 2 == 0) {
                col1.setNullAt(i);
                continue;
            }
            col1.vector[i] = i;
        }
        VectorizedColumnBatch batch = new VectorizedColumnBatch(new ColumnVector[]{col0, col1});
        for (int i = 0; i < 1024; ++i) {
            ColumnarRow row = new ColumnarRow(batch, i);
            Assert.assertTrue((boolean)row.isNullAt(0));
            if (i % 2 == 0) {
                Assert.assertTrue((boolean)row.isNullAt(1));
                continue;
            }
            Assert.assertEquals((long)row.getInt(1), (long)i);
        }
    }

    @Test
    public void testDictionary() {
        HeapIntVector col = new HeapIntVector(1024);
        int[] dict = new int[]{1998, 9998};
        col.setDictionary((Dictionary)new TestDictionary(dict));
        HeapIntVector heapIntVector = col.reserveDictionaryIds(1024);
        for (int i = 0; i < 1024; ++i) {
            heapIntVector.vector[i] = i % 2 == 0 ? 0 : 1;
        }
        VectorizedColumnBatch batch = new VectorizedColumnBatch(new ColumnVector[]{col});
        for (int i = 0; i < 1024; ++i) {
            ColumnarRow row = new ColumnarRow(batch, i);
            if (i % 2 == 0) {
                Assert.assertEquals((long)row.getInt(0), (long)1998L);
                continue;
            }
            Assert.assertEquals((long)row.getInt(0), (long)9998L);
        }
    }

    private final class TestDictionary
    implements Dictionary {
        private int[] intDictionary;

        public TestDictionary(int[] dictionary) {
            this.intDictionary = dictionary;
        }

        public int decodeToInt(int id) {
            return this.intDictionary[id];
        }

        public long decodeToLong(int id) {
            throw new UnsupportedOperationException("Dictionary encoding does not support float");
        }

        public float decodeToFloat(int id) {
            throw new UnsupportedOperationException("Dictionary encoding does not support float");
        }

        public double decodeToDouble(int id) {
            throw new UnsupportedOperationException("Dictionary encoding does not support double");
        }

        public byte[] decodeToBinary(int id) {
            throw new UnsupportedOperationException("Dictionary encoding does not support String");
        }
    }
}

