/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.DataFormatTestUtil;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.NestedRow;
import org.apache.flink.table.runtime.typeutils.BaseRowSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryGenericSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryStringSerializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.junit.Assert;
import org.junit.Test;

public class NestedRowTest {
    @Test
    public void testNestedRowWithOneSegment() {
        BinaryRow row = this.getBinaryRow();
        GenericTypeInfo info = new GenericTypeInfo(DataFormatTestUtil.MyObj.class);
        TypeSerializer genericSerializer = info.createSerializer(new ExecutionConfig());
        BaseRow nestedRow = row.getRow(0, 5);
        Assert.assertEquals((long)nestedRow.getInt(0), (long)1L);
        Assert.assertEquals((long)nestedRow.getLong(1), (long)5L);
        Assert.assertEquals((Object)nestedRow.getString(2), (Object)BinaryString.fromString((String)"12345678"));
        Assert.assertTrue((boolean)nestedRow.isNullAt(3));
        Assert.assertEquals((Object)new DataFormatTestUtil.MyObj(15, 5.0), (Object)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)nestedRow.getGeneric(4), (TypeSerializer)genericSerializer));
    }

    @Test
    public void testNestedRowWithMultipleSegments() {
        BinaryRow row = this.getBinaryRow();
        GenericTypeInfo info = new GenericTypeInfo(DataFormatTestUtil.MyObj.class);
        TypeSerializer genericSerializer = info.createSerializer(new ExecutionConfig());
        MemorySegment[] segments = DataFormatTestUtil.splitBytes(row.getSegments()[0].getHeapMemory(), 3);
        row.pointTo(segments, 3, row.getSizeInBytes());
        BaseRow nestedRow = row.getRow(0, 5);
        Assert.assertEquals((long)nestedRow.getInt(0), (long)1L);
        Assert.assertEquals((long)nestedRow.getLong(1), (long)5L);
        Assert.assertEquals((Object)nestedRow.getString(2), (Object)BinaryString.fromString((String)"12345678"));
        Assert.assertTrue((boolean)nestedRow.isNullAt(3));
        Assert.assertEquals((Object)new DataFormatTestUtil.MyObj(15, 5.0), (Object)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)nestedRow.getGeneric(4), (TypeSerializer)genericSerializer));
    }

    @Test
    public void testNestInNestedRow() {
        GenericRow gRow = new GenericRow(4);
        gRow.setField(0, (Object)1);
        gRow.setField(1, (Object)5L);
        gRow.setField(2, (Object)BinaryString.fromString((String)"12345678"));
        gRow.setField(3, null);
        BaseRowSerializer serializer = new BaseRowSerializer(new LogicalType[]{DataTypes.INT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType()}, new TypeSerializer[]{IntSerializer.INSTANCE, LongSerializer.INSTANCE, StringSerializer.INSTANCE, StringSerializer.INSTANCE});
        BinaryRow row = new BinaryRow(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, BinaryString.fromString((String)"hahahahafff"));
        writer.writeRow(1, (BaseRow)gRow, serializer);
        writer.complete();
        BinaryRow row2 = new BinaryRow(1);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        writer2.writeRow(0, (BaseRow)row, null);
        writer2.complete();
        NestedRow nestedRow = (NestedRow)row2.getRow(0, 2);
        BinaryRow binaryRow = new BinaryRow(2);
        binaryRow.pointTo(nestedRow.getSegments(), nestedRow.getOffset(), nestedRow.getSizeInBytes());
        Assert.assertEquals((Object)binaryRow, (Object)row);
        Assert.assertEquals((Object)row2.getRow(0, 2).getString(0), (Object)BinaryString.fromString((String)"hahahahafff"));
        nestedRow = row2.getRow(0, 2).getRow(1, 4);
        Assert.assertEquals((long)nestedRow.getInt(0), (long)1L);
        Assert.assertEquals((long)nestedRow.getLong(1), (long)5L);
        Assert.assertEquals((Object)nestedRow.getString(2), (Object)BinaryString.fromString((String)"12345678"));
        Assert.assertTrue((boolean)nestedRow.isNullAt(3));
    }

    private BinaryRow getBinaryRow() {
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        GenericTypeInfo info = new GenericTypeInfo(DataFormatTestUtil.MyObj.class);
        TypeSerializer genericSerializer = info.createSerializer(new ExecutionConfig());
        GenericRow gRow = new GenericRow(5);
        gRow.setField(0, (Object)1);
        gRow.setField(1, (Object)5L);
        gRow.setField(2, (Object)BinaryString.fromString((String)"12345678"));
        gRow.setField(3, null);
        gRow.setField(4, (Object)new BinaryGeneric((Object)new DataFormatTestUtil.MyObj(15, 5.0)));
        BaseRowSerializer serializer = new BaseRowSerializer(new LogicalType[]{DataTypes.INT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.ANY((TypeInformation)info).getLogicalType()}, new TypeSerializer[]{IntSerializer.INSTANCE, LongSerializer.INSTANCE, BinaryStringSerializer.INSTANCE, BinaryStringSerializer.INSTANCE, new BinaryGenericSerializer(genericSerializer)});
        writer.writeRow(0, (BaseRow)gRow, serializer);
        writer.complete();
        return row;
    }
}

