/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.dataformat.BinaryString;
import org.junit.Assert;

public class DataFormatTestUtil {
    public static BinaryRow get24BytesBinaryRow() {
        BinaryRow row = new BinaryRow(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, BinaryString.fromString((String)RandomStringUtils.randomNumeric((int)2)));
        writer.writeString(1, BinaryString.fromString((String)RandomStringUtils.randomNumeric((int)2)));
        writer.complete();
        return row;
    }

    public static BinaryRow get160BytesBinaryRow() {
        BinaryRow row = new BinaryRow(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, BinaryString.fromString((String)RandomStringUtils.randomNumeric((int)72)));
        writer.writeString(1, BinaryString.fromString((String)RandomStringUtils.randomNumeric((int)64)));
        writer.complete();
        return row;
    }

    public static BinaryRow getMultiSeg160BytesBinaryRow(BinaryRow row160) {
        int baseOffset;
        BinaryRow multiSegRow160 = new BinaryRow(2);
        MemorySegment[] segments = new MemorySegment[6];
        int posInSeg = baseOffset = 8;
        int remainSize = 160;
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = MemorySegmentFactory.wrap((byte[])new byte[32]);
            int copy = Math.min(32 - posInSeg, remainSize);
            row160.getSegments()[0].copyTo(160 - remainSize, segments[i], posInSeg, copy);
            remainSize -= copy;
            posInSeg = 0;
        }
        multiSegRow160.pointTo(segments, baseOffset, 160);
        Assert.assertEquals((Object)row160, (Object)multiSegRow160);
        return multiSegRow160;
    }

    public static BinaryRow getMultiSeg160BytesInOneSegRow(BinaryRow row160) {
        MemorySegment[] segments = new MemorySegment[]{row160.getSegments()[0], MemorySegmentFactory.wrap((byte[])new byte[row160.getSegments()[0].size()])};
        row160.pointTo(segments, 0, row160.getSizeInBytes());
        return row160;
    }

    static MemorySegment[] splitBytes(byte[] bytes, int baseOffset) {
        int newSize = (bytes.length + 1) / 2 + baseOffset;
        MemorySegment[] ret = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[newSize]), MemorySegmentFactory.wrap((byte[])new byte[newSize])};
        ret[0].put(baseOffset, bytes, 0, newSize - baseOffset);
        ret[1].put(0, bytes, newSize - baseOffset, bytes.length - (newSize - baseOffset));
        return ret;
    }

    static class MyObj {
        public int i;
        public double j;

        MyObj(int i, double j) {
            this.i = i;
            this.j = j;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyObj myObj = (MyObj)o;
            return this.i == myObj.i && Double.compare(myObj.j, this.j) == 0;
        }

        public String toString() {
            return "MyObj{i=" + this.i + ", j=" + this.j + '}';
        }
    }
}

