/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.math.BigDecimal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryArrayWriter;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.runtime.typeutils.BaseArraySerializer;
import org.apache.flink.table.runtime.typeutils.BaseMapSerializer;
import org.apache.flink.table.runtime.typeutils.BaseRowSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryGenericSerializer;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.BinaryGenericAsserter;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class BinaryArrayTest {
    @Test
    public void testArray() {
        BinaryArray array = new BinaryArray();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 3, 4);
        writer.writeInt(0, 6);
        writer.setNullInt(1);
        writer.writeInt(2, 666);
        writer.complete();
        Assert.assertEquals((long)array.getInt(0), (long)6L);
        Assert.assertTrue((boolean)array.isNullAt(1));
        Assert.assertEquals((long)array.getInt(2), (long)666L);
        BinaryRow row2 = new BinaryRow(1);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        writer2.writeArray(0, (BaseArray)array, new BaseArraySerializer(DataTypes.INT().getLogicalType(), null));
        writer2.complete();
        BinaryArray array2 = (BinaryArray)row2.getArray(0);
        Assert.assertEquals((Object)array2, (Object)array);
        Assert.assertEquals((long)array2.getInt(0), (long)6L);
        Assert.assertTrue((boolean)array2.isNullAt(1));
        Assert.assertEquals((long)array2.getInt(2), (long)666L);
        BinaryArray array3 = BinaryArrayTest.splitArray(array);
        BinaryRow row22 = new BinaryRow(1);
        BinaryRowWriter writer22 = new BinaryRowWriter(row22);
        writer22.writeArray(0, (BaseArray)array3, new BaseArraySerializer(DataTypes.INT().getLogicalType(), null));
        writer22.complete();
        BinaryArray array22 = (BinaryArray)row22.getArray(0);
        Assert.assertEquals((Object)array22, (Object)array);
        Assert.assertEquals((long)array22.getInt(0), (long)6L);
        Assert.assertTrue((boolean)array22.isNullAt(1));
        Assert.assertEquals((long)array22.getInt(2), (long)666L);
    }

    @Test
    public void testArrayTypes() {
        BinaryArray array = new BinaryArray();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 1);
        writer.setNullBoolean(0);
        writer.writeBoolean(1, true);
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertEquals((Object)true, (Object)array.getBoolean(1));
        array.setBoolean(0, true);
        Assert.assertEquals((Object)true, (Object)array.getBoolean(0));
        array.setNullBoolean(0);
        Assert.assertTrue((boolean)array.isNullAt(0));
        BinaryArray newArray = BinaryArrayTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertEquals((Object)true, (Object)newArray.getBoolean(1));
        newArray.setBoolean(0, true);
        Assert.assertEquals((Object)true, (Object)newArray.getBoolean(0));
        newArray.setNullBoolean(0);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        newArray.setBoolean(0, true);
        Assert.assertEquals((Object)newArray, (Object)BinaryArray.fromPrimitiveArray((boolean[])newArray.toBooleanArray()));
        array = new BinaryArray();
        writer = new BinaryArrayWriter(array, 2, 1);
        writer.setNullByte(0);
        writer.writeByte(1, (byte)25);
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertEquals((long)25L, (long)array.getByte(1));
        array.setByte(0, (byte)5);
        Assert.assertEquals((long)5L, (long)array.getByte(0));
        array.setNullByte(0);
        Assert.assertTrue((boolean)array.isNullAt(0));
        newArray = BinaryArrayTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertEquals((long)25L, (long)newArray.getByte(1));
        newArray.setByte(0, (byte)5);
        Assert.assertEquals((long)5L, (long)newArray.getByte(0));
        newArray.setNullByte(0);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        newArray.setByte(0, (byte)3);
        Assert.assertEquals((Object)newArray, (Object)BinaryArray.fromPrimitiveArray((byte[])newArray.toByteArray()));
        array = new BinaryArray();
        writer = new BinaryArrayWriter(array, 2, 2);
        writer.setNullShort(0);
        writer.writeShort(1, (short)25);
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertEquals((long)25L, (long)array.getShort(1));
        array.setShort(0, (short)5);
        Assert.assertEquals((long)5L, (long)array.getShort(0));
        array.setNullShort(0);
        Assert.assertTrue((boolean)array.isNullAt(0));
        newArray = BinaryArrayTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertEquals((long)25L, (long)newArray.getShort(1));
        newArray.setShort(0, (short)5);
        Assert.assertEquals((long)5L, (long)newArray.getShort(0));
        newArray.setNullShort(0);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        newArray.setShort(0, (short)3);
        Assert.assertEquals((Object)newArray, (Object)BinaryArray.fromPrimitiveArray((short[])newArray.toShortArray()));
        array = new BinaryArray();
        writer = new BinaryArrayWriter(array, 2, 4);
        writer.setNullInt(0);
        writer.writeInt(1, 25);
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertEquals((long)25L, (long)array.getInt(1));
        array.setInt(0, 5);
        Assert.assertEquals((long)5L, (long)array.getInt(0));
        array.setNullInt(0);
        Assert.assertTrue((boolean)array.isNullAt(0));
        newArray = BinaryArrayTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertEquals((long)25L, (long)newArray.getInt(1));
        newArray.setInt(0, 5);
        Assert.assertEquals((long)5L, (long)newArray.getInt(0));
        newArray.setNullInt(0);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        newArray.setInt(0, 3);
        Assert.assertEquals((Object)newArray, (Object)BinaryArray.fromPrimitiveArray((int[])newArray.toIntArray()));
        array = new BinaryArray();
        writer = new BinaryArrayWriter(array, 2, 8);
        writer.setNullLong(0);
        writer.writeLong(1, 25L);
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertEquals((long)25L, (long)array.getLong(1));
        array.setLong(0, 5L);
        Assert.assertEquals((long)5L, (long)array.getLong(0));
        array.setNullLong(0);
        Assert.assertTrue((boolean)array.isNullAt(0));
        newArray = BinaryArrayTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertEquals((long)25L, (long)newArray.getLong(1));
        newArray.setLong(0, 5L);
        Assert.assertEquals((long)5L, (long)newArray.getLong(0));
        newArray.setNullLong(0);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        newArray.setLong(0, 3L);
        Assert.assertEquals((Object)newArray, (Object)BinaryArray.fromPrimitiveArray((long[])newArray.toLongArray()));
        array = new BinaryArray();
        writer = new BinaryArrayWriter(array, 2, 4);
        writer.setNullFloat(0);
        writer.writeFloat(1, 25.0f);
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertTrue((25.0f == array.getFloat(1) ? 1 : 0) != 0);
        array.setFloat(0, 5.0f);
        Assert.assertTrue((5.0f == array.getFloat(0) ? 1 : 0) != 0);
        array.setNullFloat(0);
        Assert.assertTrue((boolean)array.isNullAt(0));
        newArray = BinaryArrayTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertTrue((25.0f == newArray.getFloat(1) ? 1 : 0) != 0);
        newArray.setFloat(0, 5.0f);
        Assert.assertTrue((5.0f == newArray.getFloat(0) ? 1 : 0) != 0);
        newArray.setNullFloat(0);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        newArray.setFloat(0, 3.0f);
        Assert.assertEquals((Object)newArray, (Object)BinaryArray.fromPrimitiveArray((float[])newArray.toFloatArray()));
        array = new BinaryArray();
        writer = new BinaryArrayWriter(array, 2, 8);
        writer.setNullDouble(0);
        writer.writeDouble(1, 25.0);
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertTrue((25.0 == array.getDouble(1) ? 1 : 0) != 0);
        array.setDouble(0, 5.0);
        Assert.assertTrue((5.0 == array.getDouble(0) ? 1 : 0) != 0);
        array.setNullDouble(0);
        Assert.assertTrue((boolean)array.isNullAt(0));
        newArray = BinaryArrayTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertTrue((25.0 == newArray.getDouble(1) ? 1 : 0) != 0);
        newArray.setDouble(0, 5.0);
        Assert.assertTrue((5.0 == newArray.getDouble(0) ? 1 : 0) != 0);
        newArray.setNullDouble(0);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        newArray.setDouble(0, 3.0);
        Assert.assertEquals((Object)newArray, (Object)BinaryArray.fromPrimitiveArray((double[])newArray.toDoubleArray()));
        array = new BinaryArray();
        writer = new BinaryArrayWriter(array, 2, 8);
        writer.setNullAt(0);
        writer.writeString(1, BinaryString.fromString((String)"jaja"));
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertEquals((Object)BinaryString.fromString((String)"jaja"), (Object)array.getString(1));
        newArray = BinaryArrayTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertEquals((Object)BinaryString.fromString((String)"jaja"), (Object)newArray.getString(1));
        BinaryArray subArray = new BinaryArray();
        BinaryArrayWriter subWriter = new BinaryArrayWriter(subArray, 2, 8);
        subWriter.setNullAt(0);
        subWriter.writeString(1, BinaryString.fromString((String)"hehehe"));
        subWriter.complete();
        BinaryArray array2 = new BinaryArray();
        BinaryArrayWriter writer2 = new BinaryArrayWriter(array2, 2, 8);
        writer2.setNullAt(0);
        writer2.writeArray(1, (BaseArray)subArray, new BaseArraySerializer(DataTypes.INT().getLogicalType(), null));
        writer2.complete();
        Assert.assertTrue((boolean)array2.isNullAt(0));
        Assert.assertEquals((Object)subArray, (Object)array2.getArray(1));
        BinaryArray newArray2 = BinaryArrayTest.splitArray(array2);
        Assert.assertTrue((boolean)newArray2.isNullAt(0));
        Assert.assertEquals((Object)subArray, (Object)newArray2.getArray(1));
        array2 = new BinaryArray();
        writer2 = new BinaryArrayWriter(array2, 2, 8);
        writer2.setNullAt(0);
        writer2.writeMap(1, (BaseMap)BinaryMap.valueOf((BinaryArray)subArray, (BinaryArray)subArray), new BaseMapSerializer(DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType(), null));
        writer2.complete();
        Assert.assertTrue((boolean)array2.isNullAt(0));
        Assert.assertEquals((Object)BinaryMap.valueOf((BinaryArray)subArray, (BinaryArray)subArray), (Object)array2.getMap(1));
        newArray2 = BinaryArrayTest.splitArray(array2);
        Assert.assertTrue((boolean)newArray2.isNullAt(0));
        Assert.assertEquals((Object)BinaryMap.valueOf((BinaryArray)subArray, (BinaryArray)subArray), (Object)newArray2.getMap(1));
    }

    @Test
    public void testMap() {
        BinaryArray array1 = new BinaryArray();
        BinaryArrayWriter writer1 = new BinaryArrayWriter(array1, 3, 4);
        writer1.writeInt(0, 6);
        writer1.writeInt(1, 5);
        writer1.writeInt(2, 666);
        writer1.complete();
        BinaryArray array2 = new BinaryArray();
        BinaryArrayWriter writer2 = new BinaryArrayWriter(array2, 3, 8);
        writer2.writeString(0, BinaryString.fromString((String)"6"));
        writer2.writeString(1, BinaryString.fromString((String)"5"));
        writer2.writeString(2, BinaryString.fromString((String)"666"));
        writer2.complete();
        BinaryMap binaryMap = BinaryMap.valueOf((BinaryArray)array1, (BinaryArray)array2);
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter rowWriter = new BinaryRowWriter(row);
        rowWriter.writeMap(0, (BaseMap)binaryMap, new BaseMapSerializer(DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType(), null));
        rowWriter.complete();
        BinaryMap map = (BinaryMap)row.getMap(0);
        BinaryArray key = map.keyArray();
        BinaryArray value = map.valueArray();
        Assert.assertEquals((Object)binaryMap, (Object)map);
        Assert.assertEquals((Object)array1, (Object)key);
        Assert.assertEquals((Object)array2, (Object)value);
        Assert.assertEquals((long)key.getInt(1), (long)5L);
        Assert.assertEquals((Object)value.getString(1), (Object)BinaryString.fromString((String)"5"));
    }

    private static BinaryArray splitArray(BinaryArray array) {
        BinaryArray ret = new BinaryArray();
        MemorySegment[] segments = BinaryArrayTest.splitBytes(SegmentsUtil.copyToBytes((MemorySegment[])array.segments, (int)0, (int)array.sizeInBytes), 0);
        ret.pointTo(segments, 0, array.sizeInBytes);
        return ret;
    }

    private static MemorySegment[] splitBytes(byte[] bytes, int baseOffset) {
        int newSize = (bytes.length + 1) / 2 + baseOffset;
        MemorySegment[] ret = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[newSize]), MemorySegmentFactory.wrap((byte[])new byte[newSize])};
        ret[0].put(baseOffset, bytes, 0, newSize - baseOffset);
        ret[1].put(0, bytes, newSize - baseOffset, bytes.length - (newSize - baseOffset));
        return ret;
    }

    @Test
    public void testToArray() {
        BinaryArray array = new BinaryArray();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 3, 2);
        writer.writeShort(0, (short)5);
        writer.writeShort(1, (short)10);
        writer.writeShort(2, (short)15);
        writer.complete();
        short[] shorts = array.toShortArray();
        Assert.assertEquals((long)5L, (long)shorts[0]);
        Assert.assertEquals((long)10L, (long)shorts[1]);
        Assert.assertEquals((long)15L, (long)shorts[2]);
        MemorySegment[] segments = BinaryArrayTest.splitBytes(writer.segment.getArray(), 3);
        array.pointTo(segments, 3, array.getSizeInBytes());
        Assert.assertEquals((long)5L, (long)array.getShort(0));
        Assert.assertEquals((long)10L, (long)array.getShort(1));
        Assert.assertEquals((long)15L, (long)array.getShort(2));
        short[] shorts2 = array.toShortArray();
        Assert.assertEquals((long)5L, (long)shorts2[0]);
        Assert.assertEquals((long)10L, (long)shorts2[1]);
        Assert.assertEquals((long)15L, (long)shorts2[2]);
    }

    @Test
    public void testDecimal() {
        BinaryArray array = new BinaryArray();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 8);
        int precision = 4;
        int scale = 2;
        writer.reset();
        writer.writeDecimal(0, Decimal.fromLong((long)5L, (int)precision, (int)scale), precision);
        writer.setNullAt(1);
        writer.complete();
        Assert.assertEquals((Object)"0.05", (Object)array.getDecimal(0, precision, scale).toString());
        Assert.assertTrue((boolean)array.isNullAt(1));
        array.setDecimal(0, Decimal.fromLong((long)6L, (int)precision, (int)scale), precision);
        Assert.assertEquals((Object)"0.06", (Object)array.getDecimal(0, precision, scale).toString());
        precision = 25;
        scale = 5;
        Decimal decimal1 = Decimal.fromBigDecimal((BigDecimal)BigDecimal.valueOf(5.55), (int)precision, (int)scale);
        Decimal decimal2 = Decimal.fromBigDecimal((BigDecimal)BigDecimal.valueOf(6.55), (int)precision, (int)scale);
        writer.reset();
        writer.writeDecimal(0, decimal1, precision);
        writer.writeDecimal(1, null, precision);
        writer.complete();
        Assert.assertEquals((Object)"5.55000", (Object)array.getDecimal(0, precision, scale).toString());
        Assert.assertTrue((boolean)array.isNullAt(1));
        array.setDecimal(0, decimal2, precision);
        Assert.assertEquals((Object)"6.55000", (Object)array.getDecimal(0, precision, scale).toString());
    }

    @Test
    public void testGeneric() {
        BinaryArray array = new BinaryArray();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 8);
        BinaryGeneric generic = new BinaryGeneric((Object)"hahah");
        BinaryGenericSerializer serializer = new BinaryGenericSerializer((TypeSerializer)StringSerializer.INSTANCE);
        writer.writeGeneric(0, generic, serializer);
        writer.setNullAt(1);
        writer.complete();
        BinaryGeneric newGeneric = array.getGeneric(0);
        Assert.assertThat((Object)newGeneric, (Matcher)BinaryGenericAsserter.equivalent(generic, serializer));
        Assert.assertTrue((boolean)array.isNullAt(1));
    }

    @Test
    public void testNested() {
        BinaryArray array = new BinaryArray();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 8);
        writer.writeRow(0, (BaseRow)GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)"1"), 1}), new BaseRowSerializer(null, RowType.of((LogicalType[])new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new IntType()})));
        writer.setNullAt(1);
        writer.complete();
        BaseRow nestedRow = array.getRow(0, 2);
        Assert.assertEquals((Object)"1", (Object)nestedRow.getString(0).toString());
        Assert.assertEquals((long)1L, (long)nestedRow.getInt(1));
        Assert.assertTrue((boolean)array.isNullAt(1));
    }

    @Test
    public void testBinary() {
        BinaryArray array = new BinaryArray();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 8);
        byte[] bytes1 = new byte[]{1, -1, 5};
        byte[] bytes2 = new byte[]{1, -1, 5, 5, 1, 5, 1, 5};
        writer.writeBinary(0, bytes1);
        writer.writeBinary(1, bytes2);
        writer.complete();
        Assert.assertArrayEquals((byte[])bytes1, (byte[])array.getBinary(0));
        Assert.assertArrayEquals((byte[])bytes2, (byte[])array.getBinary(1));
    }
}

