/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.math.BigDecimal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryArrayWriter;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.BoxedWrapperRow;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.typeutils.BaseArraySerializer;
import org.apache.flink.table.runtime.typeutils.BaseMapSerializer;
import org.apache.flink.table.runtime.typeutils.BaseRowSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryGenericSerializer;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.BinaryGenericAsserter;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseRowTest {
    private BinaryString str;
    private BinaryGeneric generic;
    private Decimal decimal1;
    private Decimal decimal2;
    private BinaryArray array;
    private BinaryMap map;
    private BinaryRow underRow;
    private byte[] bytes;
    private BinaryGenericSerializer<String> genericSerializer;

    @Before
    public void before() {
        this.str = BinaryString.fromString((String)"haha");
        this.generic = new BinaryGeneric((Object)"haha");
        this.genericSerializer = new BinaryGenericSerializer((TypeSerializer)StringSerializer.INSTANCE);
        this.decimal1 = Decimal.fromLong((long)10L, (int)5, (int)0);
        this.decimal2 = Decimal.fromBigDecimal((BigDecimal)new BigDecimal(11), (int)20, (int)0);
        this.array = new BinaryArray();
        BinaryArrayWriter arrayWriter = new BinaryArrayWriter(this.array, 2, 4);
        arrayWriter.writeInt(0, 15);
        arrayWriter.writeInt(1, 16);
        arrayWriter.complete();
        this.map = BinaryMap.valueOf((BinaryArray)this.array, (BinaryArray)this.array);
        this.underRow = new BinaryRow(2);
        BinaryRowWriter writer = new BinaryRowWriter(this.underRow);
        writer.writeInt(0, 15);
        writer.writeInt(1, 16);
        writer.complete();
        this.bytes = new byte[]{1, 5, 6};
    }

    @Test
    public void testBinaryRow() {
        this.testAll((BaseRow)this.getBinaryRow());
    }

    @Test
    public void testNestedRow() {
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeRow(0, (BaseRow)this.getBinaryRow(), null);
        writer.complete();
        this.testAll(row.getRow(0, 16));
    }

    private BinaryRow getBinaryRow() {
        BinaryRow row = new BinaryRow(16);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeBoolean(0, true);
        writer.writeByte(1, (byte)1);
        writer.writeShort(2, (short)2);
        writer.writeInt(3, 3);
        writer.writeLong(4, 4L);
        writer.writeFloat(5, 5.0f);
        writer.writeDouble(6, 6.0);
        writer.writeString(8, this.str);
        writer.writeGeneric(9, this.generic, this.genericSerializer);
        writer.writeDecimal(10, this.decimal1, 5);
        writer.writeDecimal(11, this.decimal2, 20);
        writer.writeArray(12, (BaseArray)this.array, new BaseArraySerializer(DataTypes.INT().getLogicalType(), null));
        writer.writeMap(13, (BaseMap)this.map, new BaseMapSerializer(DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType(), null));
        writer.writeRow(14, (BaseRow)this.underRow, new BaseRowSerializer(null, RowType.of((LogicalType[])new LogicalType[]{new IntType(), new IntType()})));
        writer.writeBinary(15, this.bytes);
        return row;
    }

    @Test
    public void testGenericRow() {
        GenericRow row = new GenericRow(16);
        row.setField(0, (Object)true);
        row.setField(1, (Object)1);
        row.setField(2, (Object)2);
        row.setField(3, (Object)3);
        row.setField(4, (Object)4L);
        row.setField(5, (Object)Float.valueOf(5.0f));
        row.setField(6, (Object)6.0);
        row.setField(7, (Object)Character.valueOf('\u0007'));
        row.setField(8, (Object)this.str);
        row.setField(9, (Object)this.generic);
        row.setField(10, (Object)this.decimal1);
        row.setField(11, (Object)this.decimal2);
        row.setField(12, (Object)this.array);
        row.setField(13, (Object)this.map);
        row.setField(14, (Object)this.underRow);
        row.setField(15, (Object)this.bytes);
        this.testAll((BaseRow)row);
    }

    @Test
    public void testBoxedWrapperRow() {
        BoxedWrapperRow row = new BoxedWrapperRow(16);
        row.setBoolean(0, true);
        row.setByte(1, (byte)1);
        row.setShort(2, (short)2);
        row.setInt(3, 3);
        row.setLong(4, 4L);
        row.setFloat(5, 5.0f);
        row.setDouble(6, 6.0);
        row.setNonPrimitiveValue(8, (Object)this.str);
        row.setNonPrimitiveValue(9, (Object)this.generic);
        row.setNonPrimitiveValue(10, (Object)this.decimal1);
        row.setNonPrimitiveValue(11, (Object)this.decimal2);
        row.setNonPrimitiveValue(12, (Object)this.array);
        row.setNonPrimitiveValue(13, (Object)this.map);
        row.setNonPrimitiveValue(14, (Object)this.underRow);
        row.setNonPrimitiveValue(15, (Object)this.bytes);
        this.testAll((BaseRow)row);
    }

    @Test
    public void testJoinedRow() {
        GenericRow row1 = new GenericRow(5);
        row1.setField(0, (Object)true);
        row1.setField(1, (Object)1);
        row1.setField(2, (Object)2);
        row1.setField(3, (Object)3);
        row1.setField(4, (Object)4L);
        GenericRow row2 = new GenericRow(11);
        row2.setField(0, (Object)Float.valueOf(5.0f));
        row2.setField(1, (Object)6.0);
        row2.setField(2, (Object)Character.valueOf('\u0007'));
        row2.setField(3, (Object)this.str);
        row2.setField(4, (Object)this.generic);
        row2.setField(5, (Object)this.decimal1);
        row2.setField(6, (Object)this.decimal2);
        row2.setField(7, (Object)this.array);
        row2.setField(8, (Object)this.map);
        row2.setField(9, (Object)this.underRow);
        row2.setField(10, (Object)this.bytes);
        this.testAll((BaseRow)new JoinedRow((BaseRow)row1, (BaseRow)row2));
    }

    private void testAll(BaseRow row) {
        Assert.assertEquals((long)16L, (long)row.getArity());
        Assert.assertEquals((long)0L, (long)row.getHeader());
        row.setHeader((byte)1);
        Assert.assertEquals((long)1L, (long)row.getHeader());
        Assert.assertTrue((boolean)row.getBoolean(0));
        Assert.assertEquals((long)1L, (long)row.getByte(1));
        Assert.assertEquals((long)2L, (long)row.getShort(2));
        Assert.assertEquals((long)3L, (long)row.getInt(3));
        Assert.assertEquals((long)4L, (long)row.getLong(4));
        Assert.assertEquals((long)5L, (long)((int)row.getFloat(5)));
        Assert.assertEquals((long)6L, (long)((int)row.getDouble(6)));
        Assert.assertEquals((Object)this.str, (Object)row.getString(8));
        Assert.assertThat((Object)row.getGeneric(9), (Matcher)BinaryGenericAsserter.equivalent(this.generic, this.genericSerializer));
        Assert.assertEquals((Object)this.decimal1, (Object)row.getDecimal(10, 5, 0));
        Assert.assertEquals((Object)this.decimal2, (Object)row.getDecimal(11, 20, 0));
        Assert.assertEquals((Object)this.array, (Object)row.getArray(12));
        Assert.assertEquals((Object)this.map, (Object)row.getMap(13));
        Assert.assertEquals((long)15L, (long)row.getRow(14, 2).getInt(0));
        Assert.assertEquals((long)16L, (long)row.getRow(14, 2).getInt(1));
        Assert.assertArrayEquals((byte[])this.bytes, (byte[])row.getBinary(15));
        row.setBoolean(0, false);
        Assert.assertFalse((boolean)row.getBoolean(0));
        row.setByte(1, (byte)2);
        Assert.assertEquals((long)2L, (long)row.getByte(1));
        row.setShort(2, (short)3);
        Assert.assertEquals((long)3L, (long)row.getShort(2));
        row.setInt(3, 4);
        Assert.assertEquals((long)4L, (long)row.getInt(3));
        row.setLong(4, 5L);
        Assert.assertEquals((long)5L, (long)row.getLong(4));
        row.setFloat(5, 6.0f);
        Assert.assertEquals((long)6L, (long)((int)row.getFloat(5)));
        row.setDouble(6, 7.0);
        Assert.assertEquals((long)7L, (long)((int)row.getDouble(6)));
        row.setDecimal(10, Decimal.fromLong((long)11L, (int)5, (int)0), 5);
        Assert.assertEquals((Object)Decimal.fromLong((long)11L, (int)5, (int)0), (Object)row.getDecimal(10, 5, 0));
        row.setDecimal(11, Decimal.fromBigDecimal((BigDecimal)new BigDecimal(12), (int)20, (int)0), 20);
        Assert.assertEquals((Object)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(12), (int)20, (int)0), (Object)row.getDecimal(11, 20, 0));
        Assert.assertFalse((boolean)row.isNullAt(0));
        row.setNullAt(0);
        Assert.assertTrue((boolean)row.isNullAt(0));
    }
}

