/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.HashMap;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.util.MapDataUtil;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.runtime.typeutils.ArrayDataSerializerTest;
import org.apache.flink.table.runtime.typeutils.MapDataSerializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.DeeplyEqualsChecker;

public class MapDataSerializerTest
extends SerializerTestBase<MapData> {
    private static final LogicalType INT = DataTypes.INT().getLogicalType();
    private static final LogicalType STRING = DataTypes.STRING().getLogicalType();

    public MapDataSerializerTest() {
        super(new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof MapData && o2 instanceof MapData, (o1, o2, checker) -> MapDataUtil.convertToJavaMap((MapData)((MapData)o1), (LogicalType)INT, (LogicalType)STRING).equals(MapDataUtil.convertToJavaMap((MapData)((MapData)o2), (LogicalType)INT, (LogicalType)STRING))));
    }

    protected MapDataSerializer createSerializer() {
        return new MapDataSerializer(INT, STRING);
    }

    protected int getLength() {
        return -1;
    }

    protected Class<MapData> getTypeClass() {
        return MapData.class;
    }

    protected MapData[] getTestData() {
        HashMap<Integer, StringData> first = new HashMap<Integer, StringData>();
        first.put(1, StringData.fromString((String)""));
        return new MapData[]{new GenericMapData(first), BinaryMapData.valueOf((BinaryArrayData)MapDataSerializerTest.createArray(1, 2), (BinaryArrayData)ArrayDataSerializerTest.createArray("11", "haa")), BinaryMapData.valueOf((BinaryArrayData)MapDataSerializerTest.createArray(1, 3, 4), (BinaryArrayData)ArrayDataSerializerTest.createArray("11", "haa", "ke")), BinaryMapData.valueOf((BinaryArrayData)MapDataSerializerTest.createArray(1, 4, 2), (BinaryArrayData)ArrayDataSerializerTest.createArray("11", "haa", "ke")), BinaryMapData.valueOf((BinaryArrayData)MapDataSerializerTest.createArray(1, 5, 6, 7), (BinaryArrayData)ArrayDataSerializerTest.createArray("11", "lele", "haa", "ke"))};
    }

    private static BinaryArrayData createArray(int ... vs) {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, vs.length, 4);
        for (int i = 0; i < vs.length; ++i) {
            writer.writeInt(i, vs[i]);
        }
        writer.complete();
        return array;
    }
}

