/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream.compact;

import java.io.IOException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.impl.StreamFormatAdapter;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;

public class TestByteFormat
extends SimpleStreamFormat<Byte> {
    public StreamFormat.Reader<Byte> createReader(Configuration config, final FSDataInputStream stream) {
        return new StreamFormat.Reader<Byte>(){

            public Byte read() throws IOException {
                byte b = (byte)stream.read();
                if (b == -1) {
                    return null;
                }
                return b;
            }

            public void close() throws IOException {
                stream.close();
            }
        };
    }

    public TypeInformation<Byte> getProducedType() {
        return BasicTypeInfo.BYTE_TYPE_INFO;
    }

    public static BulkFormat<Byte, FileSourceSplit> bulkFormat() {
        return new StreamFormatAdapter((StreamFormat)new TestByteFormat());
    }
}

