/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream.compact;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.flink.core.fs.Path;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;

public abstract class AbstractCompactTestBase {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    public static final int TARGET_SIZE = 9;
    Path folder;

    @Before
    public void before() throws IOException {
        this.folder = new Path(TEMP_FOLDER.newFolder().getPath());
    }

    Path newFile(String name, int len) throws IOException {
        Path path = new Path(this.folder, name);
        File file = new File(path.getPath());
        file.delete();
        file.createNewFile();
        try (FileOutputStream out = new FileOutputStream(file);){
            for (int i = 0; i < len; ++i) {
                out.write(i);
            }
        }
        return path;
    }
}

