/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.filesystem.DynamicPartitionWriter;
import org.apache.flink.table.filesystem.FileSystemFactory;
import org.apache.flink.table.filesystem.GroupedPartitionWriter;
import org.apache.flink.table.filesystem.OutputFormatFactory;
import org.apache.flink.table.filesystem.PartitionComputer;
import org.apache.flink.table.filesystem.PartitionTempFileManager;
import org.apache.flink.table.filesystem.PartitionWriter;
import org.apache.flink.table.filesystem.SingleDirectoryWriter;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class PartitionWriterTest {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    private Map<String, List<Row>> records = new HashMap<String, List<Row>>();
    private OutputFormatFactory<Row> factory = (OutputFormatFactory & Serializable)path -> new OutputFormat<Row>(){

        public void configure(Configuration parameters) {
        }

        public void open(int taskNumber, int numTasks) {
            PartitionWriterTest.this.records.put(this.getKey(), new ArrayList());
        }

        private String getKey() {
            Path parent = path.getParent();
            return parent.getName().startsWith("task-") ? parent.getParent().getName() : parent.getParent().getParent().getName() + "/" + parent.getName();
        }

        public void writeRecord(Row record) {
            ((List)PartitionWriterTest.this.records.get(this.getKey())).add(record);
        }

        public void close() {
        }
    };
    private final String basePath = TEMP_FOLDER.newFolder().getPath();
    private final PartitionWriter.Context<Row> context = new PartitionWriter.Context(null, (OutputFormatFactory & Serializable)path -> this.factory.createOutputFormat(path));
    private FileSystemFactory fsFactory = FileSystem::get;
    private Path tmpPath = new Path(this.basePath);
    private PartitionTempFileManager manager = new PartitionTempFileManager(this.fsFactory, this.tmpPath, 0, 1L);
    private PartitionComputer<Row> computer = new PartitionComputer<Row>(){

        public LinkedHashMap<String, String> generatePartValues(Row in) {
            LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>(1);
            ret.put("p", in.getField(0).toString());
            return ret;
        }

        public Row projectColumnsToWrite(Row in) {
            return in;
        }
    };

    @Test
    public void testEmptySingleDirectoryWriter() throws Exception {
        SingleDirectoryWriter writer = new SingleDirectoryWriter(this.context, this.manager, this.computer, new LinkedHashMap());
        writer.close();
        Assert.assertTrue((boolean)this.records.isEmpty());
    }

    @Test
    public void testSingleDirectoryWriter() throws Exception {
        SingleDirectoryWriter writer = new SingleDirectoryWriter(this.context, this.manager, this.computer, new LinkedHashMap());
        writer.write((Object)Row.of((Object[])new Object[]{"p1", 1}));
        writer.write((Object)Row.of((Object[])new Object[]{"p1", 2}));
        writer.write((Object)Row.of((Object[])new Object[]{"p2", 2}));
        writer.close();
        Assert.assertEquals((Object)"{cp-1=[p1,1, p1,2, p2,2]}", (Object)this.records.toString());
        this.manager = new PartitionTempFileManager(this.fsFactory, this.tmpPath, 0, 2L);
        writer = new SingleDirectoryWriter(this.context, this.manager, this.computer, new LinkedHashMap());
        writer.write((Object)Row.of((Object[])new Object[]{"p3", 3}));
        writer.write((Object)Row.of((Object[])new Object[]{"p5", 5}));
        writer.write((Object)Row.of((Object[])new Object[]{"p2", 2}));
        writer.close();
        Assert.assertEquals((Object)"{cp-2=[p3,3, p5,5, p2,2], cp-1=[p1,1, p1,2, p2,2]}", (Object)this.records.toString());
    }

    @Test
    public void testGroupedPartitionWriter() throws Exception {
        GroupedPartitionWriter writer = new GroupedPartitionWriter(this.context, this.manager, this.computer);
        writer.write((Object)Row.of((Object[])new Object[]{"p1", 1}));
        writer.write((Object)Row.of((Object[])new Object[]{"p1", 2}));
        writer.write((Object)Row.of((Object[])new Object[]{"p2", 2}));
        writer.close();
        Assert.assertEquals((Object)"{cp-1/p=p1=[p1,1, p1,2], cp-1/p=p2=[p2,2]}", (Object)this.records.toString());
        this.manager = new PartitionTempFileManager(this.fsFactory, this.tmpPath, 0, 2L);
        writer = new GroupedPartitionWriter(this.context, this.manager, this.computer);
        writer.write((Object)Row.of((Object[])new Object[]{"p3", 3}));
        writer.write((Object)Row.of((Object[])new Object[]{"p4", 5}));
        writer.write((Object)Row.of((Object[])new Object[]{"p5", 2}));
        writer.close();
        Assert.assertEquals((Object)"{cp-2/p=p5=[p5,2], cp-2/p=p4=[p4,5], cp-2/p=p3=[p3,3], cp-1/p=p1=[p1,1, p1,2], cp-1/p=p2=[p2,2]}", (Object)this.records.toString());
    }

    @Test
    public void testDynamicPartitionWriter() throws Exception {
        DynamicPartitionWriter writer = new DynamicPartitionWriter(this.context, this.manager, this.computer);
        writer.write((Object)Row.of((Object[])new Object[]{"p1", 1}));
        writer.write((Object)Row.of((Object[])new Object[]{"p2", 2}));
        writer.write((Object)Row.of((Object[])new Object[]{"p1", 2}));
        writer.close();
        Assert.assertEquals((Object)"{cp-1/p=p1=[p1,1, p1,2], cp-1/p=p2=[p2,2]}", (Object)this.records.toString());
        this.manager = new PartitionTempFileManager(this.fsFactory, this.tmpPath, 0, 2L);
        writer = new DynamicPartitionWriter(this.context, this.manager, this.computer);
        writer.write((Object)Row.of((Object[])new Object[]{"p4", 5}));
        writer.write((Object)Row.of((Object[])new Object[]{"p3", 3}));
        writer.write((Object)Row.of((Object[])new Object[]{"p5", 2}));
        writer.close();
        Assert.assertEquals((Object)"{cp-2/p=p5=[p5,2], cp-2/p=p4=[p4,5], cp-2/p=p3=[p3,3], cp-1/p=p1=[p1,1, p1,2], cp-1/p=p2=[p2,2]}", (Object)this.records.toString());
    }
}

