/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.filesystem.FileSystemCommitter;
import org.apache.flink.table.filesystem.FileSystemFactory;
import org.apache.flink.table.filesystem.TableMetaStoreFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileSystemCommitterTest {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    private File tmpFile;
    private File outputFile;
    private Path tmpPath;
    private FileSystemFactory fileSystemFactory = FileSystem::get;
    private TableMetaStoreFactory metaStoreFactory;

    @Before
    public void before() throws IOException {
        this.tmpFile = TEMP_FOLDER.newFolder();
        this.outputFile = TEMP_FOLDER.newFolder();
        this.tmpPath = new Path(this.tmpFile.getPath());
        Path outputPath = new Path(this.outputFile.getPath());
        this.metaStoreFactory = new TestMetaStoreFactory(outputPath);
    }

    private void createFile(String path, String ... files) throws IOException {
        File p1 = new File(this.tmpFile, path);
        p1.mkdirs();
        for (String file : files) {
            new File(p1, file).createNewFile();
        }
    }

    @Test
    public void testPartition() throws Exception {
        FileSystemCommitter committer = new FileSystemCommitter(this.fileSystemFactory, this.metaStoreFactory, true, this.tmpPath, 2);
        this.createFile("cp-1/task-1/p1=0/p2=0/", "f1", "f2");
        this.createFile("cp-1/task-2/p1=0/p2=0/", "f3");
        this.createFile("cp-1/task-2/p1=0/p2=1/", "f4");
        committer.commitUpToCheckpoint(1L);
        Assert.assertTrue((boolean)new File(this.outputFile, "p1=0/p2=0/f1").exists());
        Assert.assertTrue((boolean)new File(this.outputFile, "p1=0/p2=0/f2").exists());
        Assert.assertTrue((boolean)new File(this.outputFile, "p1=0/p2=0/f3").exists());
        Assert.assertTrue((boolean)new File(this.outputFile, "p1=0/p2=1/f4").exists());
        this.createFile("cp-1/task-2/p1=0/p2=1/", "f5");
        committer.commitUpToCheckpoint(1L);
        Assert.assertTrue((boolean)new File(this.outputFile, "p1=0/p2=0/f1").exists());
        Assert.assertTrue((boolean)new File(this.outputFile, "p1=0/p2=0/f2").exists());
        Assert.assertTrue((boolean)new File(this.outputFile, "p1=0/p2=0/f3").exists());
        Assert.assertTrue((boolean)new File(this.outputFile, "p1=0/p2=1/f5").exists());
        committer = new FileSystemCommitter(this.fileSystemFactory, this.metaStoreFactory, false, this.tmpPath, 2);
        this.createFile("cp-1/task-2/p1=0/p2=1/", "f6");
        committer.commitUpToCheckpoint(1L);
        Assert.assertTrue((boolean)new File(this.outputFile, "p1=0/p2=1/f5").exists());
        Assert.assertTrue((boolean)new File(this.outputFile, "p1=0/p2=1/f6").exists());
    }

    @Test
    public void testNotPartition() throws Exception {
        FileSystemCommitter committer = new FileSystemCommitter(this.fileSystemFactory, this.metaStoreFactory, true, this.tmpPath, 0);
        this.createFile("cp-1/task-1/", "f1", "f2");
        this.createFile("cp-1/task-2/", "f3");
        committer.commitUpToCheckpoint(1L);
        Assert.assertTrue((boolean)new File(this.outputFile, "f1").exists());
        Assert.assertTrue((boolean)new File(this.outputFile, "f2").exists());
        Assert.assertTrue((boolean)new File(this.outputFile, "f3").exists());
        this.createFile("cp-1/task-2/", "f4");
        committer.commitUpToCheckpoint(1L);
        Assert.assertTrue((boolean)new File(this.outputFile, "f4").exists());
        committer = new FileSystemCommitter(this.fileSystemFactory, this.metaStoreFactory, false, this.tmpPath, 0);
        this.createFile("cp-1/task-2/", "f5");
        committer.commitUpToCheckpoint(1L);
        Assert.assertTrue((boolean)new File(this.outputFile, "f4").exists());
        Assert.assertTrue((boolean)new File(this.outputFile, "f5").exists());
    }

    static class TestMetaStoreFactory
    implements TableMetaStoreFactory {
        private final Path outputPath;

        TestMetaStoreFactory(Path outputPath) {
            this.outputPath = outputPath;
        }

        public TableMetaStoreFactory.TableMetaStore createTableMetaStore() {
            return new TableMetaStoreFactory.TableMetaStore(){

                public Path getLocationPath() {
                    return outputPath;
                }

                public Optional<Path> getPartition(LinkedHashMap<String, String> partSpec) {
                    return Optional.empty();
                }

                public void createOrAlterPartition(LinkedHashMap<String, String> partitionSpec, Path partitionPath) throws Exception {
                }

                public void close() {
                }
            };
        }
    }
}

