/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.typeutils.ArrayDataSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.types.RowKind;

public class StreamRecordUtils {
    public static StreamRecord<RowData> record(RowKind rowKind, Object ... fields) {
        RowData row = StreamRecordUtils.row(fields);
        row.setRowKind(rowKind);
        return new StreamRecord((Object)row);
    }

    public static StreamRecord<RowData> insertRecord(Object ... fields) {
        return new StreamRecord((Object)StreamRecordUtils.row(fields));
    }

    public static StreamRecord<RowData> binaryRecord(RowKind rowKind, Object ... fields) {
        BinaryRowData row = StreamRecordUtils.binaryrow(fields);
        row.setRowKind(rowKind);
        return new StreamRecord((Object)row);
    }

    public static StreamRecord<RowData> updateBeforeRecord(Object ... fields) {
        RowData row = StreamRecordUtils.row(fields);
        row.setRowKind(RowKind.UPDATE_BEFORE);
        return new StreamRecord((Object)row);
    }

    public static StreamRecord<RowData> updateAfterRecord(Object ... fields) {
        RowData row = StreamRecordUtils.row(fields);
        row.setRowKind(RowKind.UPDATE_AFTER);
        return new StreamRecord((Object)row);
    }

    public static StreamRecord<RowData> deleteRecord(Object ... fields) {
        RowData row = StreamRecordUtils.row(fields);
        row.setRowKind(RowKind.DELETE);
        return new StreamRecord((Object)row);
    }

    public static RowData row(Object ... fields) {
        Object[] objects = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Object field = fields[i];
            objects[i] = field instanceof String ? StringData.fromString((String)((String)field)) : field;
        }
        return GenericRowData.of((Object[])objects);
    }

    public static BinaryRowData binaryrow(Object ... fields) {
        BinaryRowData row = new BinaryRowData(fields.length);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        for (int j = 0; j < fields.length; ++j) {
            ArrayDataSerializer serializer;
            Object value = fields[j];
            if (value == null) {
                writer.setNullAt(j);
                continue;
            }
            if (value instanceof Byte) {
                writer.writeByte(j, ((Byte)value).byteValue());
                continue;
            }
            if (value instanceof Short) {
                writer.writeShort(j, ((Short)value).shortValue());
                continue;
            }
            if (value instanceof Integer) {
                writer.writeInt(j, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof String) {
                writer.writeString(j, StringData.fromString((String)((String)value)));
                continue;
            }
            if (value instanceof Double) {
                writer.writeDouble(j, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Float) {
                writer.writeFloat(j, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Long) {
                writer.writeLong(j, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Boolean) {
                writer.writeBoolean(j, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof byte[]) {
                writer.writeBinary(j, (byte[])value);
                continue;
            }
            if (value instanceof DecimalData) {
                DecimalData decimal = (DecimalData)value;
                writer.writeDecimal(j, decimal, decimal.precision());
                continue;
            }
            if (value instanceof Tuple2 && ((Tuple2)value).f0 instanceof TimestampData) {
                TimestampData timestamp = (TimestampData)((Tuple2)value).f0;
                writer.writeTimestamp(j, timestamp, ((Integer)((Tuple2)value).f1).intValue());
                continue;
            }
            if (value instanceof Tuple2 && ((Tuple2)value).f0 instanceof ArrayData) {
                ArrayData array = (ArrayData)((Tuple2)value).f0;
                serializer = (ArrayDataSerializer)((Tuple2)value).f1;
                writer.writeArray(j, array, serializer);
                continue;
            }
            if (value instanceof Tuple2 && ((Tuple2)value).f0 instanceof RowData) {
                RowData rowData = (RowData)((Tuple2)value).f0;
                serializer = (RowDataSerializer)((Tuple2)value).f1;
                writer.writeRow(j, rowData, (RowDataSerializer)serializer);
                continue;
            }
            throw new RuntimeException("Not support yet!");
        }
        writer.complete();
        return row;
    }

    private StreamRecordUtils() {
    }
}

