/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.runtime.typeutils.TimestampDataSerializer;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimestampDataSerializerTest
extends SerializerTestBase<TimestampData> {
    private int precision;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({0}, {3}, {6}, {9});
    }

    public TimestampDataSerializerTest(int precision) {
        this.precision = precision;
    }

    protected TypeSerializer<TimestampData> createSerializer() {
        return new TimestampDataSerializer(this.precision);
    }

    protected int getLength() {
        return this.precision <= 3 ? 8 : 12;
    }

    protected Class<TimestampData> getTypeClass() {
        return TimestampData.class;
    }

    protected TimestampData[] getTestData() {
        return new TimestampData[]{TimestampData.fromEpochMillis((long)1L), TimestampData.fromEpochMillis((long)2L), TimestampData.fromEpochMillis((long)3L), TimestampData.fromEpochMillis((long)4L)};
    }
}

