/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.assigners;

import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.WindowTestUtils;
import org.apache.flink.table.runtime.operators.window.assigners.TumblingWindowAssigner;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TumblingWindowAssignerTest {
    private static final RowData ELEMENT = GenericRowData.of((Object[])new Object[]{"String"});
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testWindowAssignment() {
        TumblingWindowAssigner assigner = TumblingWindowAssigner.of((Duration)Duration.ofMillis(5000L));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 0L), (Matcher)Matchers.contains(WindowTestUtils.timeWindow(0L, 5000L)));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 4999L), (Matcher)Matchers.contains(WindowTestUtils.timeWindow(0L, 5000L)));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 5000L), (Matcher)Matchers.contains(WindowTestUtils.timeWindow(5000L, 10000L)));
    }

    @Test
    public void testWindowAssignmentWithOffset() {
        TumblingWindowAssigner assigner = TumblingWindowAssigner.of((Duration)Duration.ofMillis(5000L)).withOffset(Duration.ofMillis(100L));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 100L), (Matcher)Matchers.contains(WindowTestUtils.timeWindow(100L, 5100L)));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 5099L), (Matcher)Matchers.contains(WindowTestUtils.timeWindow(100L, 5100L)));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 5100L), (Matcher)Matchers.contains(WindowTestUtils.timeWindow(5100L, 10100L)));
    }

    @Test
    public void testInvalidParameters() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("size > 0");
        TumblingWindowAssigner.of((Duration)Duration.ofSeconds(-1L));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("size > 0");
        TumblingWindowAssigner.of((Duration)Duration.ofSeconds(10L)).withOffset(Duration.ofSeconds(20L));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("size > 0");
        TumblingWindowAssigner.of((Duration)Duration.ofSeconds(10L)).withOffset(Duration.ofSeconds(-1L));
    }

    @Test
    public void testProperties() {
        TumblingWindowAssigner assigner = TumblingWindowAssigner.of((Duration)Duration.ofMillis(5000L));
        Assert.assertTrue((boolean)assigner.isEventTime());
        Assert.assertEquals((Object)new TimeWindow.Serializer(), (Object)assigner.getWindowSerializer(new ExecutionConfig()));
        Assert.assertTrue((boolean)assigner.withEventTime().isEventTime());
        Assert.assertFalse((boolean)assigner.withProcessingTime().isEventTime());
    }
}

