/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput.output;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.runtime.operators.multipleinput.MultipleInputTestBase;
import org.apache.flink.table.runtime.operators.multipleinput.TestingOneInputStreamOperator;
import org.apache.flink.table.runtime.operators.multipleinput.TestingTwoInputStreamOperator;
import org.apache.flink.table.runtime.operators.multipleinput.output.BroadcastingOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.CopyingBroadcastingOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.CopyingFirstInputOfTwoInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.CopyingOneInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.CopyingSecondInputOfTwoInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.FirstInputOfTwoInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.OneInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.SecondInputOfTwoInputStreamOperatorOutput;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OutputTest
extends MultipleInputTestBase {
    private StreamRecord<RowData> element;
    private Watermark watermark;
    private LatencyMarker latencyMarker;
    private TypeSerializer<RowData> serializer;

    @Before
    public void setup() {
        this.element = new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"123")}), 456L);
        this.watermark = new Watermark(1223456789L);
        this.latencyMarker = new LatencyMarker(122345678L, new OperatorID(123L, 456L), 1);
        this.serializer = InternalTypeInfo.of((RowType)RowType.of((LogicalType[])new LogicalType[]{DataTypes.STRING().getLogicalType()})).createSerializer(new ExecutionConfig());
    }

    @Test
    public void testOneInput() throws Exception {
        TestingOneInputStreamOperator op = this.createOneInputStreamOperator();
        OneInputStreamOperatorOutput output = new OneInputStreamOperatorOutput((OneInputStreamOperator)op);
        output.collect(this.element);
        Assert.assertEquals(this.element, op.getCurrentElement());
        output.emitWatermark(this.watermark);
        Assert.assertEquals((Object)this.watermark, (Object)op.getCurrentWatermark());
        output.emitLatencyMarker(this.latencyMarker);
        Assert.assertEquals((Object)this.latencyMarker, (Object)op.getCurrentLatencyMarker());
    }

    @Test
    public void testCopyingOneInput() throws Exception {
        TestingOneInputStreamOperator op = this.createOneInputStreamOperator();
        CopyingOneInputStreamOperatorOutput output = new CopyingOneInputStreamOperatorOutput((OneInputStreamOperator)op, this.serializer);
        output.collect(this.element);
        Assert.assertNotSame(this.element, op.getCurrentElement());
        Assert.assertEquals(this.element, op.getCurrentElement());
        output.emitWatermark(this.watermark);
        Assert.assertSame((Object)this.watermark, (Object)op.getCurrentWatermark());
        output.emitLatencyMarker(this.latencyMarker);
        Assert.assertSame((Object)this.latencyMarker, (Object)op.getCurrentLatencyMarker());
    }

    @Test
    public void testFirstInputOfTwoInput() throws Exception {
        TestingTwoInputStreamOperator op = this.createTwoInputStreamOperator();
        FirstInputOfTwoInputStreamOperatorOutput output = new FirstInputOfTwoInputStreamOperatorOutput((TwoInputStreamOperator)op);
        output.collect(this.element);
        Assert.assertEquals(this.element, op.getCurrentElement1());
        Assert.assertNull(op.getCurrentElement2());
        output.emitWatermark(this.watermark);
        Assert.assertEquals((Object)this.watermark, (Object)op.getCurrentWatermark1());
        Assert.assertNull((Object)op.getCurrentWatermark2());
        output.emitLatencyMarker(this.latencyMarker);
        Assert.assertEquals((Object)this.latencyMarker, (Object)op.getCurrentLatencyMarker1());
        Assert.assertNull((Object)op.getCurrentLatencyMarker2());
    }

    @Test
    public void testCopyingFirstInputOfTwoInput() throws Exception {
        TestingTwoInputStreamOperator op = this.createTwoInputStreamOperator();
        CopyingFirstInputOfTwoInputStreamOperatorOutput output = new CopyingFirstInputOfTwoInputStreamOperatorOutput((TwoInputStreamOperator)op, this.serializer);
        output.collect(this.element);
        Assert.assertNotSame(this.element, op.getCurrentElement1());
        Assert.assertEquals(this.element, op.getCurrentElement1());
        Assert.assertNull(op.getCurrentElement2());
        output.emitWatermark(this.watermark);
        Assert.assertSame((Object)this.watermark, (Object)op.getCurrentWatermark1());
        Assert.assertNull((Object)op.getCurrentWatermark2());
        output.emitLatencyMarker(this.latencyMarker);
        Assert.assertSame((Object)this.latencyMarker, (Object)op.getCurrentLatencyMarker1());
        Assert.assertNull((Object)op.getCurrentLatencyMarker2());
    }

    @Test
    public void testSecondInputOfTwoInput() throws Exception {
        TestingTwoInputStreamOperator op = this.createTwoInputStreamOperator();
        SecondInputOfTwoInputStreamOperatorOutput output = new SecondInputOfTwoInputStreamOperatorOutput((TwoInputStreamOperator)op);
        output.collect(this.element);
        Assert.assertEquals(this.element, op.getCurrentElement2());
        Assert.assertNull(op.getCurrentElement1());
        output.emitWatermark(this.watermark);
        Assert.assertEquals((Object)this.watermark, (Object)op.getCurrentWatermark2());
        Assert.assertNull((Object)op.getCurrentWatermark1());
        output.emitLatencyMarker(this.latencyMarker);
        Assert.assertEquals((Object)this.latencyMarker, (Object)op.getCurrentLatencyMarker2());
        Assert.assertNull((Object)op.getCurrentLatencyMarker1());
    }

    @Test
    public void testCopyingSecondInputOfTwoInput() throws Exception {
        TestingTwoInputStreamOperator op = this.createTwoInputStreamOperator();
        CopyingSecondInputOfTwoInputStreamOperatorOutput output = new CopyingSecondInputOfTwoInputStreamOperatorOutput((TwoInputStreamOperator)op, this.serializer);
        output.collect(this.element);
        Assert.assertNotSame(this.element, op.getCurrentElement2());
        Assert.assertEquals(this.element, op.getCurrentElement2());
        Assert.assertNull(op.getCurrentElement1());
        output.emitWatermark(this.watermark);
        Assert.assertSame((Object)this.watermark, (Object)op.getCurrentWatermark2());
        Assert.assertNull((Object)op.getCurrentWatermark1());
        output.emitLatencyMarker(this.latencyMarker);
        Assert.assertSame((Object)this.latencyMarker, (Object)op.getCurrentLatencyMarker2());
        Assert.assertNull((Object)op.getCurrentLatencyMarker1());
    }

    @Test
    public void testBroadcasting() throws Exception {
        TestingOneInputStreamOperator op1 = this.createOneInputStreamOperator();
        TestingOneInputStreamOperator op2 = this.createOneInputStreamOperator();
        BroadcastingOutput output = new BroadcastingOutput(new Output[]{new OneInputStreamOperatorOutput((OneInputStreamOperator)op1), new OneInputStreamOperatorOutput((OneInputStreamOperator)op2)});
        output.collect(this.element);
        Assert.assertEquals(this.element, op1.getCurrentElement());
        Assert.assertEquals(this.element, op2.getCurrentElement());
        output.emitWatermark(this.watermark);
        Assert.assertEquals((Object)this.watermark, (Object)op1.getCurrentWatermark());
        Assert.assertEquals((Object)this.watermark, (Object)op2.getCurrentWatermark());
        output.emitLatencyMarker(this.latencyMarker);
        if (op1.getCurrentLatencyMarker() != null) {
            Assert.assertEquals((Object)this.latencyMarker, (Object)op1.getCurrentLatencyMarker());
            Assert.assertNull((Object)op2.getCurrentLatencyMarker());
        } else {
            Assert.assertEquals((Object)this.latencyMarker, (Object)op2.getCurrentLatencyMarker());
        }
    }

    @Test
    public void testCopyingBroadcasting() throws Exception {
        TestingOneInputStreamOperator op1 = this.createOneInputStreamOperator();
        TestingOneInputStreamOperator op2 = this.createOneInputStreamOperator();
        CopyingBroadcastingOutput output = new CopyingBroadcastingOutput(new Output[]{new OneInputStreamOperatorOutput((OneInputStreamOperator)op1), new OneInputStreamOperatorOutput((OneInputStreamOperator)op2)});
        output.collect(this.element);
        Assert.assertNotSame(this.element, op1.getCurrentElement());
        Assert.assertEquals(this.element, op1.getCurrentElement());
        Assert.assertSame(this.element, op2.getCurrentElement());
        output.emitWatermark(this.watermark);
        Assert.assertSame((Object)this.watermark, (Object)op1.getCurrentWatermark());
        Assert.assertSame((Object)this.watermark, (Object)op2.getCurrentWatermark());
        output.emitLatencyMarker(this.latencyMarker);
        if (op1.getCurrentLatencyMarker() != null) {
            Assert.assertSame((Object)this.latencyMarker, (Object)op1.getCurrentLatencyMarker());
            Assert.assertNull((Object)op2.getCurrentLatencyMarker());
        } else {
            Assert.assertSame((Object)this.latencyMarker, (Object)op2.getCurrentLatencyMarker());
        }
    }
}

