/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.formats.raw;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TestDynamicTableFactory;
import org.apache.flink.table.formats.raw.RawFormatDeserializationSchema;
import org.apache.flink.table.formats.raw.RawFormatSerializationSchema;
import org.apache.flink.table.runtime.connector.sink.SinkRuntimeProviderContext;
import org.apache.flink.table.runtime.connector.source.ScanRuntimeProviderContext;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class RawFormatFactoryTest
extends TestLogger {
    private static final TableSchema SCHEMA = TableSchema.builder().field("field1", DataTypes.STRING()).build();
    private static final RowType ROW_TYPE = (RowType)SCHEMA.toRowDataType().getLogicalType();

    @Test
    public void testSeDeSchema() {
        Map<String, String> tableOptions = this.getBasicOptions();
        RawFormatDeserializationSchema expectedDeser = new RawFormatDeserializationSchema(ROW_TYPE.getTypeAt(0), (TypeInformation)InternalTypeInfo.of((RowType)ROW_TYPE), "UTF-8", true);
        DeserializationSchema<RowData> actualDeser = RawFormatFactoryTest.createDeserializationSchema(SCHEMA, tableOptions);
        Assert.assertEquals((Object)expectedDeser, actualDeser);
        RawFormatSerializationSchema expectedSer = new RawFormatSerializationSchema(ROW_TYPE.getTypeAt(0), "UTF-8", true);
        SerializationSchema<RowData> actualSer = RawFormatFactoryTest.createSerializationSchema(SCHEMA, tableOptions);
        Assert.assertEquals((Object)expectedSer, actualSer);
    }

    @Test
    public void testCharsetAndEndiannessOption() {
        Map<String, String> tableOptions = this.getModifiedOptions(options -> {
            options.put("raw.charset", "UTF-16");
            options.put("raw.endianness", "little-endian");
        });
        RawFormatDeserializationSchema expectedDeser = new RawFormatDeserializationSchema(ROW_TYPE.getTypeAt(0), (TypeInformation)InternalTypeInfo.of((RowType)ROW_TYPE), "UTF-16", false);
        DeserializationSchema<RowData> actualDeser = RawFormatFactoryTest.createDeserializationSchema(SCHEMA, tableOptions);
        Assert.assertEquals((Object)expectedDeser, actualDeser);
        RawFormatSerializationSchema expectedSer = new RawFormatSerializationSchema(ROW_TYPE.getTypeAt(0), "UTF-16", false);
        SerializationSchema<RowData> actualSer = RawFormatFactoryTest.createSerializationSchema(SCHEMA, tableOptions);
        Assert.assertEquals((Object)expectedSer, actualSer);
    }

    @Test
    public void testInvalidSchema() {
        TableSchema invalidSchema = TableSchema.builder().field("f0", DataTypes.STRING()).field("f1", DataTypes.BIGINT()).build();
        String expectedError = "The 'raw' format only supports single physical column. However the defined schema contains multiple physical columns: [`f0` STRING, `f1` BIGINT]";
        try {
            RawFormatFactoryTest.createDeserializationSchema(invalidSchema, this.getBasicOptions());
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)expectedError)));
        }
        try {
            RawFormatFactoryTest.createSerializationSchema(invalidSchema, this.getBasicOptions());
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)expectedError)));
        }
    }

    @Test
    public void testInvalidCharset() {
        Map<String, String> tableOptions = this.getModifiedOptions(options -> options.put("raw.charset", "UNKNOWN"));
        String expectedError = "Unsupported 'raw.charset' name: UNKNOWN.";
        try {
            RawFormatFactoryTest.createDeserializationSchema(SCHEMA, tableOptions);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause().getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)expectedError)));
        }
        try {
            RawFormatFactoryTest.createSerializationSchema(SCHEMA, tableOptions);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause().getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)expectedError)));
        }
    }

    @Test
    public void testInvalidEndianness() {
        Map<String, String> tableOptions = this.getModifiedOptions(options -> options.put("raw.endianness", "BIG_ENDIAN"));
        String expectedError = "Unsupported endianness name: BIG_ENDIAN. Valid values of 'raw.endianness' option are 'big-endian' and 'little-endian'.";
        try {
            RawFormatFactoryTest.createDeserializationSchema(SCHEMA, tableOptions);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause().getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)expectedError)));
        }
        try {
            RawFormatFactoryTest.createSerializationSchema(SCHEMA, tableOptions);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause().getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)expectedError)));
        }
    }

    @Test
    public void testInvalidFieldTypes() {
        try {
            RawFormatFactoryTest.createDeserializationSchema(TableSchema.builder().field("field1", DataTypes.TIMESTAMP((int)3)).build(), this.getBasicOptions());
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"The 'raw' format doesn't supports 'TIMESTAMP(3)' as column type.")));
        }
        try {
            RawFormatFactoryTest.createDeserializationSchema(TableSchema.builder().field("field1", DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING())).build(), this.getBasicOptions());
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"The 'raw' format doesn't supports 'MAP<INT, STRING>' as column type.")));
        }
    }

    private static DeserializationSchema<RowData> createDeserializationSchema(TableSchema schema, Map<String, String> options) {
        DynamicTableSource actualSource = RawFormatFactoryTest.createTableSource(schema, options);
        Assert.assertThat((Object)actualSource, (Matcher)CoreMatchers.instanceOf(TestDynamicTableFactory.DynamicTableSourceMock.class));
        TestDynamicTableFactory.DynamicTableSourceMock scanSourceMock = (TestDynamicTableFactory.DynamicTableSourceMock)actualSource;
        return (DeserializationSchema)scanSourceMock.valueFormat.createRuntimeDecoder((DynamicTableSource.Context)ScanRuntimeProviderContext.INSTANCE, schema.toRowDataType());
    }

    private static SerializationSchema<RowData> createSerializationSchema(TableSchema schema, Map<String, String> options) {
        DynamicTableSink actualSink = RawFormatFactoryTest.createTableSink(schema, options);
        Assert.assertThat((Object)actualSink, (Matcher)CoreMatchers.instanceOf(TestDynamicTableFactory.DynamicTableSinkMock.class));
        TestDynamicTableFactory.DynamicTableSinkMock sinkMock = (TestDynamicTableFactory.DynamicTableSinkMock)actualSink;
        return (SerializationSchema)sinkMock.valueFormat.createRuntimeEncoder((DynamicTableSink.Context)new SinkRuntimeProviderContext(false), schema.toRowDataType());
    }

    private static DynamicTableSource createTableSource(TableSchema schema, Map<String, String> options) {
        return FactoryUtil.createTableSource(null, (ObjectIdentifier)ObjectIdentifier.of((String)"default", (String)"default", (String)"t1"), (CatalogTable)new CatalogTableImpl(schema, options, "Mock scan table"), (ReadableConfig)new Configuration(), (ClassLoader)RawFormatFactoryTest.class.getClassLoader(), (boolean)false);
    }

    private static DynamicTableSink createTableSink(TableSchema schema, Map<String, String> options) {
        return FactoryUtil.createTableSink(null, (ObjectIdentifier)ObjectIdentifier.of((String)"default", (String)"default", (String)"t1"), (CatalogTable)new CatalogTableImpl(schema, options, "Mock sink table"), (ReadableConfig)new Configuration(), (ClassLoader)RawFormatFactoryTest.class.getClassLoader(), (boolean)false);
    }

    private Map<String, String> getModifiedOptions(Consumer<Map<String, String>> optionModifier) {
        Map<String, String> options = this.getBasicOptions();
        optionModifier.accept(options);
        return options;
    }

    private Map<String, String> getBasicOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "test-connector");
        options.put("target", "MyTarget");
        options.put("buffer-size", "1000");
        options.put("format", "raw");
        return options;
    }
}

