/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.io.RowCsvInputFormat;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.types.Row;

public class TestRowDataCsvInputFormat
extends RichInputFormat<RowData, FileInputSplit> {
    private final List<String> partitionKeys;
    private final String defaultPartValue;
    private final int[] selectFields;
    private final long limit;
    private final RowCsvInputFormat inputFormat;
    private final List<TypeInformation> fieldTypes;
    private final List<String> fieldNames;
    private final List<DataFormatConverters.DataFormatConverter> csvSelectConverters;
    private final int[] csvFieldMapping;
    private transient Row csvRow;
    private transient GenericRowData row;
    private transient long emitted;

    public TestRowDataCsvInputFormat(Path[] paths, TableSchema schema, List<String> partitionKeys, String defaultPartValue, int[] selectFields, long limit) {
        this.partitionKeys = partitionKeys;
        this.defaultPartValue = defaultPartValue;
        this.selectFields = selectFields;
        this.limit = limit;
        RowTypeInfo rowType = (RowTypeInfo)schema.toRowType();
        this.fieldTypes = Arrays.asList(rowType.getFieldTypes());
        this.fieldNames = Arrays.asList(rowType.getFieldNames());
        List csvFieldNames = this.fieldNames.stream().filter(name -> !partitionKeys.contains(name)).collect(Collectors.toList());
        List selectFieldNames = Arrays.stream(selectFields).mapToObj(this.fieldNames::get).collect(Collectors.toList());
        List csvSelectFieldNames = selectFieldNames.stream().filter(name -> !partitionKeys.contains(name)).collect(Collectors.toList());
        List<TypeInformation> csvSelectTypes = csvSelectFieldNames.stream().map(name -> this.fieldTypes.get(this.fieldNames.indexOf(name))).collect(Collectors.toList());
        this.csvSelectConverters = csvSelectTypes.stream().map(TypeConversions::fromLegacyInfoToDataType).map(DataFormatConverters::getConverterForDataType).collect(Collectors.toList());
        int[] csvSelectFields = csvSelectFieldNames.stream().mapToInt(csvFieldNames::indexOf).toArray();
        this.inputFormat = new RowCsvInputFormat(null, csvSelectTypes.toArray(new TypeInformation[0]), csvSelectFields);
        this.inputFormat.setFilePaths(paths);
        this.csvFieldMapping = csvSelectFieldNames.stream().mapToInt(selectFieldNames::indexOf).toArray();
        this.emitted = 0L;
    }

    public void configure(Configuration parameters) {
        this.inputFormat.configure(parameters);
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStatistics) throws IOException {
        return this.inputFormat.getStatistics(cachedStatistics);
    }

    public FileInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        return this.inputFormat.createInputSplits(minNumSplits);
    }

    public InputSplitAssigner getInputSplitAssigner(FileInputSplit[] inputSplits) {
        return this.inputFormat.getInputSplitAssigner(inputSplits);
    }

    public void open(FileInputSplit split) throws IOException {
        this.inputFormat.open(split);
        Path path = split.getPath();
        LinkedHashMap partSpec = PartitionPathUtils.extractPartitionSpecFromPath((Path)path);
        this.row = new GenericRowData(this.selectFields.length);
        for (int i = 0; i < this.selectFields.length; ++i) {
            int selectField = this.selectFields[i];
            String name = this.fieldNames.get(selectField);
            if (!this.partitionKeys.contains(name)) continue;
            String value = (String)partSpec.get(name);
            value = this.defaultPartValue.equals(value) ? null : value;
            this.row.setField(i, this.convertStringToInternal(value, this.fieldTypes.get(selectField)));
        }
        this.csvRow = new Row(this.csvSelectConverters.size());
    }

    private Object convertStringToInternal(String value, TypeInformation type) {
        if (type.equals((Object)Types.INT)) {
            return Integer.parseInt(value);
        }
        if (type.equals((Object)Types.LONG)) {
            return Long.parseLong(value);
        }
        if (type.equals((Object)Types.STRING)) {
            return StringData.fromString((String)value);
        }
        throw new UnsupportedOperationException("Unsupported partition type: " + type);
    }

    public boolean reachedEnd() {
        return this.emitted >= this.limit || this.inputFormat.reachedEnd();
    }

    public RowData nextRecord(RowData reuse) throws IOException {
        Row csvRow = (Row)this.inputFormat.nextRecord((Object)this.csvRow);
        if (csvRow == null) {
            return null;
        }
        for (int i = 0; i < this.csvSelectConverters.size(); ++i) {
            this.row.setField(this.csvFieldMapping[i], this.csvSelectConverters.get(i).toInternal(csvRow.getField(i)));
        }
        ++this.emitted;
        return this.row;
    }

    public void close() throws IOException {
        this.inputFormat.close();
    }
}

