/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.filesystem.FileSystemTableSink;
import org.apache.flink.table.filesystem.FileSystemTableSource;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FileSystemTableFactoryTest {
    private static final TableSchema TEST_SCHEMA = TableSchema.builder().field("f0", DataTypes.STRING()).field("f1", DataTypes.BIGINT()).field("f2", DataTypes.BIGINT()).build();

    @Test
    public void testSourceSink() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        descriptor.putString("format", "testcsv");
        descriptor.putString("testcsv.my_option", "my_value");
        DynamicTableSource source = FileSystemTableFactoryTest.createSource(descriptor);
        Assert.assertTrue((boolean)(source instanceof FileSystemTableSource));
        DynamicTableSink sink = FileSystemTableFactoryTest.createSink(descriptor);
        Assert.assertTrue((boolean)(sink instanceof FileSystemTableSink));
    }

    @Test
    public void testLackOptionSource() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        try {
            FileSystemTableFactoryTest.createSource(descriptor);
        }
        catch (ValidationException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((String)cause.toString(), (boolean)(cause instanceof ValidationException));
            Assert.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().contains("Missing required options are:\n\nformat"));
            return;
        }
        Assert.fail((String)"Should fail by ValidationException.");
    }

    @Test
    public void testLackOptionSink() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        try {
            FileSystemTableFactoryTest.createSink(descriptor);
        }
        catch (ValidationException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((String)cause.toString(), (boolean)(cause instanceof ValidationException));
            Assert.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().contains("Missing required options are:\n\nformat"));
            return;
        }
        Assert.fail((String)"Should fail by ValidationException.");
    }

    @Test
    public void testUnsupportedOptionSource() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        descriptor.putString("format", "csv");
        descriptor.putString("my_option", "my");
        try {
            FileSystemTableFactoryTest.createSource(descriptor);
        }
        catch (ValidationException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((String)cause.toString(), (boolean)(cause instanceof ValidationException));
            Assert.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().contains("Unsupported options:\n\nmy_option"));
            return;
        }
        Assert.fail((String)"Should fail by ValidationException.");
    }

    @Test
    public void testUnsupportedOptionSink() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        descriptor.putString("format", "csv");
        descriptor.putString("my_option", "my");
        try {
            FileSystemTableFactoryTest.createSink(descriptor);
        }
        catch (ValidationException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((String)cause.toString(), (boolean)(cause instanceof ValidationException));
            Assert.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().contains("Unsupported options:\n\nmy_option"));
            return;
        }
        Assert.fail((String)"Should fail by ValidationException.");
    }

    @Test
    public void testNoFormatFactoryFound() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        descriptor.putString("format", "invalid");
        ValidationException expected = new ValidationException("Could not find any format factory for identifier 'invalid' in the classpath.");
        try {
            FileSystemTableFactoryTest.createSource(descriptor);
            Assert.fail((String)"Should fail");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)FlinkMatchers.containsCause((Throwable)expected));
        }
        try {
            FileSystemTableFactoryTest.createSink(descriptor);
            Assert.fail((String)"Should fail");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)FlinkMatchers.containsCause((Throwable)expected));
        }
    }

    @Test
    public void testFormatOptionsError() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putString(FactoryUtil.CONNECTOR.key(), "filesystem");
        descriptor.putString("path", "/tmp");
        descriptor.putString("format", "test-format");
        ValidationException expected = new ValidationException("One or more required options are missing.\n\nMissing required options are:\n\ndelimiter");
        try {
            FileSystemTableFactoryTest.createSource(descriptor);
            Assert.fail((String)"Should fail");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause().getCause(), (Matcher)FlinkMatchers.containsCause((Throwable)expected));
        }
        try {
            FileSystemTableFactoryTest.createSink(descriptor);
            Assert.fail((String)"Should fail");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause().getCause(), (Matcher)FlinkMatchers.containsCause((Throwable)expected));
        }
    }

    private static DynamicTableSource createSource(DescriptorProperties properties) {
        return FactoryUtil.createTableSource(null, (ObjectIdentifier)ObjectIdentifier.of((String)"mycatalog", (String)"mydb", (String)"mytable"), (CatalogTable)new CatalogTableImpl(TEST_SCHEMA, properties.asMap(), ""), (ReadableConfig)new Configuration(), (ClassLoader)Thread.currentThread().getContextClassLoader(), (boolean)false);
    }

    private static DynamicTableSink createSink(DescriptorProperties properties) {
        return FactoryUtil.createTableSink(null, (ObjectIdentifier)ObjectIdentifier.of((String)"mycatalog", (String)"mydb", (String)"mytable"), (CatalogTable)new CatalogTableImpl(TEST_SCHEMA, properties.asMap(), ""), (ReadableConfig)new Configuration(), (ClassLoader)Thread.currentThread().getContextClassLoader(), (boolean)false);
    }
}

