/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.io.TextOutputFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.OutputFormatSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.filesystem.FileSystemCommitterTest;
import org.apache.flink.table.filesystem.FileSystemOutputFormat;
import org.apache.flink.table.filesystem.PartitionComputer;
import org.apache.flink.table.filesystem.RowPartitionComputer;
import org.apache.flink.table.filesystem.TableMetaStoreFactory;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileSystemOutputFormatTest {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    private File tmpFile;
    private File outputFile;

    private static Map<File, String> getFileContentByPath(File directory) throws IOException {
        HashMap<File, String> contents = new HashMap<File, String>(4);
        if (!directory.exists() || !directory.isDirectory()) {
            return contents;
        }
        Collection filesInBucket = FileUtils.listFiles((File)directory, null, (boolean)true);
        for (File file : filesInBucket) {
            contents.put(file, FileUtils.readFileToString((File)file));
        }
        return contents;
    }

    @Before
    public void before() throws IOException {
        this.tmpFile = TEMP_FOLDER.newFolder();
        this.outputFile = TEMP_FOLDER.newFolder();
    }

    @Test
    public void testClosingWithoutInput() throws Exception {
        try (OneInputStreamOperatorTestHarness<Row, Object> testHarness = this.createSink(false, false, false, new LinkedHashMap<String, String>(), new AtomicReference<FileSystemOutputFormat<Row>>());){
            testHarness.setup();
            testHarness.open();
        }
    }

    @Test
    public void testNonPartition() throws Exception {
        AtomicReference<FileSystemOutputFormat<Row>> ref = new AtomicReference<FileSystemOutputFormat<Row>>();
        try (OneInputStreamOperatorTestHarness<Row, Object> testHarness = this.createSink(false, false, false, new LinkedHashMap<String, String>(), ref);){
            this.writeUnorderedRecords(testHarness);
            Assert.assertEquals((long)1L, (long)FileSystemOutputFormatTest.getFileContentByPath(new File(this.tmpFile, "cp-0")).size());
        }
        ref.get().finalizeGlobal(1);
        Map<File, String> content = FileSystemOutputFormatTest.getFileContentByPath(this.outputFile);
        Assert.assertEquals((long)1L, (long)content.size());
        Assert.assertEquals((Object)"a1,1,p1\na2,2,p1\na2,2,p2\na3,3,p1\n", (Object)content.values().iterator().next());
    }

    private void writeUnorderedRecords(OneInputStreamOperatorTestHarness<Row, Object> testHarness) throws Exception {
        testHarness.setup();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a1", 1, "p1"}), 1L));
        testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a2", 2, "p1"}), 1L));
        testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a2", 2, "p2"}), 1L));
        testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a3", 3, "p1"}), 1L));
    }

    @Test
    public void testOverrideNonPartition() throws Exception {
        this.testNonPartition();
        AtomicReference<FileSystemOutputFormat<Row>> ref = new AtomicReference<FileSystemOutputFormat<Row>>();
        try (OneInputStreamOperatorTestHarness<Row, Object> testHarness = this.createSink(true, false, false, new LinkedHashMap<String, String>(), ref);){
            this.writeUnorderedRecords(testHarness);
            Assert.assertEquals((long)1L, (long)FileSystemOutputFormatTest.getFileContentByPath(new File(this.tmpFile, "cp-0")).size());
        }
        ref.get().finalizeGlobal(1);
        Map<File, String> content = FileSystemOutputFormatTest.getFileContentByPath(this.outputFile);
        Assert.assertEquals((long)1L, (long)content.size());
        Assert.assertEquals((Object)"a1,1,p1\na2,2,p1\na2,2,p2\na3,3,p1\n", (Object)content.values().iterator().next());
        Assert.assertFalse((boolean)new File(this.tmpFile.toURI()).exists());
    }

    @Test
    public void testStaticPartition() throws Exception {
        AtomicReference<FileSystemOutputFormat<Row>> ref = new AtomicReference<FileSystemOutputFormat<Row>>();
        LinkedHashMap<String, String> staticParts = new LinkedHashMap<String, String>();
        staticParts.put("c", "p1");
        try (OneInputStreamOperatorTestHarness<Row, Object> testHarness = this.createSink(false, true, false, staticParts, ref);){
            testHarness.setup();
            testHarness.open();
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a1", 1}), 1L));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a2", 2}), 1L));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a2", 2}), 1L));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a3", 3}), 1L));
            Assert.assertEquals((long)1L, (long)FileSystemOutputFormatTest.getFileContentByPath(new File(this.tmpFile, "cp-0")).size());
        }
        ref.get().finalizeGlobal(1);
        Map<File, String> content = FileSystemOutputFormatTest.getFileContentByPath(this.outputFile);
        Assert.assertEquals((long)1L, (long)content.size());
        Assert.assertEquals((Object)"c=p1", (Object)content.keySet().iterator().next().getParentFile().getName());
        Assert.assertEquals((Object)"a1,1\na2,2\na2,2\na3,3\n", (Object)content.values().iterator().next());
        Assert.assertFalse((boolean)new File(this.tmpFile.toURI()).exists());
    }

    @Test
    public void testDynamicPartition() throws Exception {
        AtomicReference<FileSystemOutputFormat<Row>> ref = new AtomicReference<FileSystemOutputFormat<Row>>();
        try (OneInputStreamOperatorTestHarness<Row, Object> testHarness = this.createSink(false, true, false, new LinkedHashMap<String, String>(), ref);){
            this.writeUnorderedRecords(testHarness);
            Assert.assertEquals((long)2L, (long)FileSystemOutputFormatTest.getFileContentByPath(new File(this.tmpFile, "cp-0")).size());
        }
        ref.get().finalizeGlobal(1);
        Map<File, String> content = FileSystemOutputFormatTest.getFileContentByPath(this.outputFile);
        TreeMap sortedContent = new TreeMap();
        content.forEach((file, s) -> sortedContent.put(file.getParentFile().getName(), s));
        Assert.assertEquals((long)2L, (long)sortedContent.size());
        Assert.assertEquals((Object)"a1,1\na2,2\na3,3\n", sortedContent.get("c=p1"));
        Assert.assertEquals((Object)"a2,2\n", sortedContent.get("c=p2"));
        Assert.assertFalse((boolean)new File(this.tmpFile.toURI()).exists());
    }

    @Test
    public void testGroupedDynamicPartition() throws Exception {
        AtomicReference<FileSystemOutputFormat<Row>> ref = new AtomicReference<FileSystemOutputFormat<Row>>();
        try (OneInputStreamOperatorTestHarness<Row, Object> testHarness = this.createSink(false, true, true, new LinkedHashMap<String, String>(), ref);){
            testHarness.setup();
            testHarness.open();
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a1", 1, "p1"}), 1L));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a2", 2, "p1"}), 1L));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a3", 3, "p1"}), 1L));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a2", 2, "p2"}), 1L));
            Assert.assertEquals((long)2L, (long)FileSystemOutputFormatTest.getFileContentByPath(new File(this.tmpFile, "cp-0")).size());
        }
        ref.get().finalizeGlobal(1);
        Map<File, String> content = FileSystemOutputFormatTest.getFileContentByPath(this.outputFile);
        TreeMap sortedContent = new TreeMap();
        content.forEach((file, s) -> sortedContent.put(file.getParentFile().getName(), s));
        Assert.assertEquals((long)2L, (long)sortedContent.size());
        Assert.assertEquals((Object)"a1,1\na2,2\na3,3\n", sortedContent.get("c=p1"));
        Assert.assertEquals((Object)"a2,2\n", sortedContent.get("c=p2"));
        Assert.assertFalse((boolean)new File(this.tmpFile.toURI()).exists());
    }

    private OneInputStreamOperatorTestHarness<Row, Object> createSink(boolean override, boolean partition, boolean dynamicGrouped, LinkedHashMap<String, String> staticPartitions, AtomicReference<FileSystemOutputFormat<Row>> sinkRef) throws Exception {
        String[] stringArray;
        String[] columnNames = new String[]{"a", "b", "c"};
        if (partition) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "c";
        } else {
            stringArray = new String[]{};
        }
        String[] partitionColumns = stringArray;
        FileSystemCommitterTest.TestMetaStoreFactory msFactory = new FileSystemCommitterTest.TestMetaStoreFactory(new Path(this.outputFile.getPath()));
        FileSystemOutputFormat sink = new FileSystemOutputFormat.Builder().setMetaStoreFactory((TableMetaStoreFactory)msFactory).setTempPath(new Path(this.tmpFile.getPath())).setOverwrite(override).setPartitionColumns(partitionColumns).setPartitionComputer((PartitionComputer)new RowPartitionComputer("default", columnNames, partitionColumns)).setFormatFactory(TextOutputFormat::new).setDynamicGrouped(dynamicGrouped).setStaticPartitions(staticPartitions).build();
        sinkRef.set((FileSystemOutputFormat<Row>)sink);
        return new OneInputStreamOperatorTestHarness((OneInputStreamOperator)new StreamSink((SinkFunction)new OutputFormatSinkFunction((OutputFormat)sink)), 3, 3, 0);
    }
}

