/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.TimeZone;
import org.apache.flink.table.data.TimestampData;
import org.junit.Assert;
import org.junit.Test;

public class TimestampDataTest {
    @Test
    public void testNormal() {
        Assert.assertEquals((long)1123L, (long)TimestampData.fromEpochMillis((long)1123L).getMillisecond());
        Assert.assertEquals((long)-1123L, (long)TimestampData.fromEpochMillis((long)-1123L).getMillisecond());
        Assert.assertEquals((long)1123L, (long)TimestampData.fromEpochMillis((long)1123L, (int)45678).getMillisecond());
        Assert.assertEquals((long)45678L, (long)TimestampData.fromEpochMillis((long)1123L, (int)45678).getNanoOfMillisecond());
        Assert.assertEquals((long)-1123L, (long)TimestampData.fromEpochMillis((long)-1123L, (int)45678).getMillisecond());
        Assert.assertEquals((long)45678L, (long)TimestampData.fromEpochMillis((long)-1123L, (int)45678).getNanoOfMillisecond());
        Timestamp t19 = Timestamp.valueOf("1969-01-02 00:00:00.123456789");
        Timestamp t16 = Timestamp.valueOf("1969-01-02 00:00:00.123456");
        Timestamp t13 = Timestamp.valueOf("1969-01-02 00:00:00.123");
        Timestamp t10 = Timestamp.valueOf("1969-01-02 00:00:00");
        Assert.assertEquals((Object)t19, (Object)TimestampData.fromTimestamp((Timestamp)t19).toTimestamp());
        Assert.assertEquals((Object)t16, (Object)TimestampData.fromTimestamp((Timestamp)t16).toTimestamp());
        Assert.assertEquals((Object)t13, (Object)TimestampData.fromTimestamp((Timestamp)t13).toTimestamp());
        Assert.assertEquals((Object)t10, (Object)TimestampData.fromTimestamp((Timestamp)t10).toTimestamp());
        Timestamp t2 = Timestamp.valueOf("1979-01-02 00:00:00.123456");
        Assert.assertEquals((Object)t2, (Object)TimestampData.fromTimestamp((Timestamp)t2).toTimestamp());
        Timestamp t3 = new Timestamp(1572333940000L);
        Assert.assertEquals((Object)t3, (Object)TimestampData.fromTimestamp((Timestamp)t3).toTimestamp());
        LocalDateTime ldt19 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123456789);
        LocalDateTime ldt16 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123456000);
        LocalDateTime ldt13 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123000000);
        LocalDateTime ldt10 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 0);
        Assert.assertEquals((Object)ldt19, (Object)TimestampData.fromLocalDateTime((LocalDateTime)ldt19).toLocalDateTime());
        Assert.assertEquals((Object)ldt16, (Object)TimestampData.fromLocalDateTime((LocalDateTime)ldt16).toLocalDateTime());
        Assert.assertEquals((Object)ldt13, (Object)TimestampData.fromLocalDateTime((LocalDateTime)ldt13).toLocalDateTime());
        Assert.assertEquals((Object)ldt10, (Object)TimestampData.fromLocalDateTime((LocalDateTime)ldt10).toLocalDateTime());
        LocalDateTime ldt2 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 0);
        Assert.assertEquals((Object)ldt2, (Object)TimestampData.fromLocalDateTime((LocalDateTime)ldt2).toLocalDateTime());
        LocalDateTime ldt3 = LocalDateTime.of(1989, 1, 2, 0, 0, 0, 123456789);
        Assert.assertEquals((Object)ldt3, (Object)TimestampData.fromLocalDateTime((LocalDateTime)ldt3).toLocalDateTime());
        LocalDateTime ldt4 = LocalDateTime.of(1989, 1, 2, 0, 0, 0, 123456789);
        Timestamp t4 = Timestamp.valueOf(ldt4);
        Assert.assertEquals((Object)TimestampData.fromLocalDateTime((LocalDateTime)ldt4), (Object)TimestampData.fromTimestamp((Timestamp)t4));
        Instant instant1 = Instant.ofEpochMilli(123L);
        Instant instant2 = Instant.ofEpochSecond(0L, 123456789L);
        Instant instant3 = Instant.ofEpochSecond(-2L, 123456789L);
        Assert.assertEquals((Object)instant1, (Object)TimestampData.fromInstant((Instant)instant1).toInstant());
        Assert.assertEquals((Object)instant2, (Object)TimestampData.fromInstant((Instant)instant2).toInstant());
        Assert.assertEquals((Object)instant3, (Object)TimestampData.fromInstant((Instant)instant3).toInstant());
    }

    @Test
    public void testDaylightSavingTime() {
        TimeZone tz = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
        Timestamp dstBegin2018 = Timestamp.valueOf("2018-03-11 03:00:00");
        Assert.assertEquals((Object)dstBegin2018, (Object)TimestampData.fromTimestamp((Timestamp)dstBegin2018).toTimestamp());
        Timestamp dstBegin2019 = Timestamp.valueOf("2019-03-10 02:00:00");
        Assert.assertEquals((Object)dstBegin2019, (Object)TimestampData.fromTimestamp((Timestamp)dstBegin2019).toTimestamp());
        TimeZone.setDefault(tz);
    }

    @Test
    public void testToString() {
        Timestamp t = Timestamp.valueOf("1969-01-02 00:00:00.123456789");
        Assert.assertEquals((Object)"1969-01-02T00:00:00.123456789", (Object)TimestampData.fromTimestamp((Timestamp)t).toString());
        Assert.assertEquals((Object)"1970-01-01T00:00:00.123", (Object)TimestampData.fromEpochMillis((long)123L).toString());
        Assert.assertEquals((Object)"1970-01-01T00:00:00.123456789", (Object)TimestampData.fromEpochMillis((long)123L, (int)456789).toString());
        Assert.assertEquals((Object)"1969-12-31T23:59:59.877", (Object)TimestampData.fromEpochMillis((long)-123L).toString());
        Assert.assertEquals((Object)"1969-12-31T23:59:59.877456789", (Object)TimestampData.fromEpochMillis((long)-123L, (int)456789).toString());
        LocalDateTime ldt = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123456789);
        Assert.assertEquals((Object)"1969-01-02T00:00:00.123456789", (Object)TimestampData.fromLocalDateTime((LocalDateTime)ldt).toString());
        Instant instant = Instant.ofEpochSecond(0L, 123456789L);
        Assert.assertEquals((Object)"1970-01-01T00:00:00.123456789", (Object)TimestampData.fromInstant((Instant)instant).toString());
    }
}

