/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.dataformat.Decimal;

@Internal
public final class DecimalSerializer
extends TypeSerializer<Decimal> {
    private static final long serialVersionUID = 1L;
    private final int precision;
    private final int scale;

    public DecimalSerializer(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
    }

    public boolean isImmutableType() {
        return false;
    }

    public Decimal createInstance() {
        return Decimal.zero(this.precision, this.scale);
    }

    public Decimal copy(Decimal from) {
        return from.copy();
    }

    public Decimal copy(Decimal from, Decimal reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(Decimal record, DataOutputView target) throws IOException {
        if (Decimal.isCompact(this.precision)) {
            assert (record.isCompact());
            target.writeLong(record.toUnscaledLong());
        } else {
            byte[] bytes = record.toUnscaledBytes();
            target.writeInt(bytes.length);
            target.write(bytes);
        }
    }

    public Decimal deserialize(DataInputView source) throws IOException {
        if (Decimal.isCompact(this.precision)) {
            long longVal = source.readLong();
            return Decimal.fromUnscaledLong(this.precision, this.scale, longVal);
        }
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        return Decimal.fromUnscaledBytes(this.precision, this.scale, bytes);
    }

    public Decimal deserialize(Decimal record, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        if (Decimal.isCompact(this.precision)) {
            target.writeLong(source.readLong());
        } else {
            int len = source.readInt();
            target.writeInt(len);
            target.write(source, len);
        }
    }

    public DecimalSerializer duplicate() {
        return new DecimalSerializer(this.precision, this.scale);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DecimalSerializer that = (DecimalSerializer)((Object)o);
        return this.precision == that.precision && this.scale == that.scale;
    }

    public int hashCode() {
        int result = this.precision;
        result = 31 * result + this.scale;
        return result;
    }

    public TypeSerializerSnapshot<Decimal> snapshotConfiguration() {
        return new DecimalSerializerSnapshot(this.precision, this.scale);
    }

    public static final class DecimalSerializerSnapshot
    implements TypeSerializerSnapshot<Decimal> {
        private static final int CURRENT_VERSION = 3;
        private int previousPrecision;
        private int previousScale;

        public DecimalSerializerSnapshot() {
        }

        DecimalSerializerSnapshot(int precision, int scale) {
            this.previousPrecision = precision;
            this.previousScale = scale;
        }

        public int getCurrentVersion() {
            return 3;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.previousPrecision);
            out.writeInt(this.previousScale);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.previousPrecision = in.readInt();
            this.previousScale = in.readInt();
        }

        public TypeSerializer<Decimal> restoreSerializer() {
            return new DecimalSerializer(this.previousPrecision, this.previousScale);
        }

        public TypeSerializerSchemaCompatibility<Decimal> resolveSchemaCompatibility(TypeSerializer<Decimal> newSerializer) {
            if (!(newSerializer instanceof DecimalSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            DecimalSerializer newDecimalSerializer = (DecimalSerializer)newSerializer;
            if (this.previousPrecision != newDecimalSerializer.precision || this.previousScale != newDecimalSerializer.scale) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

